/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.CachedNotifyAttribute;
import java.util.ArrayList;
import java.util.List;

public class CachedNotifyObject {
    private String objectName;
    private String relationship;
    private String parent;
    private List<CachedNotifyAttribute> attributes = new ArrayList<CachedNotifyAttribute>();
    private List<CachedNotifyObject> children = new ArrayList<CachedNotifyObject>();

    public CachedNotifyObject(CachedNotifyObject original) {
        if (original != null) {
            List<CachedNotifyObject> origChildren;
            this.objectName = original.getObjectName();
            this.relationship = original.getRelationship();
            this.parent = original.getParent();
            List<CachedNotifyAttribute> origAttributes = original.getAttributes();
            if (origAttributes != null) {
                for (CachedNotifyAttribute origAttribute : origAttributes) {
                    this.attributes.add(new CachedNotifyAttribute(origAttribute));
                }
            }
            if ((origChildren = original.getChildren()) != null) {
                for (CachedNotifyObject origChild : origChildren) {
                    this.children.add(new CachedNotifyObject(origChild));
                }
            }
        }
    }

    public CachedNotifyObject(String objectName) {
        this(objectName, null, null);
    }

    public CachedNotifyObject(String objectName, String relationship, String parent) {
        this.objectName = objectName;
        this.relationship = relationship;
        this.parent = parent;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public List<CachedNotifyAttribute> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(CachedNotifyAttribute attribute) {
        this.attributes.add(attribute);
    }

    public void setAttributes(List<CachedNotifyAttribute> attributes) {
        this.attributes = attributes;
    }

    public List<CachedNotifyObject> getChildren() {
        return this.children;
    }

    public void addChild(CachedNotifyObject child) {
        this.children.add(child);
    }

    public void setChildren(List<CachedNotifyObject> children) {
        this.children = children;
    }

    public CachedNotifyObject clone() {
        return new CachedNotifyObject(this);
    }
}

