/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.sqlite;

import com.interlocsolutions.maximo.notify.sqlite.AttributeMapping;
import com.interlocsolutions.maximo.notify.sqlite.DataTypes;
import com.interlocsolutions.maximo.notify.sqlite.SqliteHelperKt;
import com.interlocsolutions.maximo.notify.sqlite.SqliteRecordInserter;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/interlocsolutions/maximo/notify/sqlite/XmlRecordInserter;", "Lcom/interlocsolutions/maximo/notify/sqlite/SqliteRecordInserter;", "catalog", "Lpsdi/mbo/MboRemote;", "statement", "Ljava/sql/PreparedStatement;", "attributes", "", "", "Lcom/interlocsolutions/maximo/notify/sqlite/AttributeMapping;", "(Lpsdi/mbo/MboRemote;Ljava/sql/PreparedStatement;Ljava/util/Map;)V", "builder", "Lorg/jdom/input/SAXBuilder;", "insert", "", "isCatalogData", "isinformer"})
public final class XmlRecordInserter
extends SqliteRecordInserter {
    @NotNull
    private final SAXBuilder builder;

    public XmlRecordInserter(@NotNull MboRemote catalog, @NotNull PreparedStatement statement, @NotNull Map<String, AttributeMapping> attributes) {
        Intrinsics.checkNotNullParameter((Object)catalog, (String)"catalog");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        super(catalog, statement, attributes);
        this.builder = new SAXBuilder();
    }

    @Override
    public void insert(@NotNull MboRemote isCatalogData) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)isCatalogData, (String)"isCatalogData");
        Set $this$insert_u24lambda_u240 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        $this$insert_u24lambda_u240.addAll((Collection)this.getAttributes().keySet());
        Set columns = set;
        if (!isCatalogData.getBoolean("INSCOPE")) {
            return;
        }
        Document doc = this.builder.build((Reader)new StringReader(isCatalogData.getString("XML")));
        if (Boolean.parseBoolean(doc.getRootElement().getAttribute("deleted").getValue())) {
            return;
        }
        this.getStatement().setString(1, UUID.randomUUID().toString());
        this.getStatement().setLong(2, isCatalogData.getLong("RECORDID"));
        for (Object element : doc.getRootElement().getChildren()) {
            AttributeMapping attribute;
            Intrinsics.checkNotNull(element, (String)"null cannot be cast to non-null type org.jdom.Element");
            String columnName = ((Element)element).getAttribute("name").getValue();
            Intrinsics.checkNotNull((Object)this.getAttributes().get(columnName));
            switch (WhenMappings.$EnumSwitchMapping$0[attribute.getDataType().ordinal()]) {
                case 1: {
                    SqliteHelperKt.bindString(this.getStatement(), attribute, ((Element)element).getValue());
                    break;
                }
                case 2: {
                    PreparedStatement preparedStatement = this.getStatement();
                    String string = ((Element)element).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.value");
                    SqliteHelperKt.bindLong(preparedStatement, attribute, Long.parseLong(string));
                    break;
                }
                case 3: {
                    PreparedStatement preparedStatement = this.getStatement();
                    String string = ((Element)element).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.value");
                    SqliteHelperKt.bindDate(preparedStatement, attribute, string);
                    break;
                }
                case 4: {
                    PreparedStatement preparedStatement = this.getStatement();
                    String string = ((Element)element).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.value");
                    SqliteHelperKt.bindYORN(preparedStatement, attribute, Integer.parseInt(string));
                    break;
                }
                case 5: {
                    PreparedStatement preparedStatement = this.getStatement();
                    String string = ((Element)element).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.value");
                    SqliteHelperKt.bindDecimal(preparedStatement, attribute, Double.parseDouble(string));
                    break;
                }
                case 6: {
                    SqliteHelperKt.bindBlob(this.getStatement(), attribute, Base64.decodeBase64(((Element)element).getValue()));
                }
            }
            columns.remove(columnName);
        }
        for (String columnName : columns) {
            AttributeMapping attribute;
            Intrinsics.checkNotNull((Object)this.getAttributes().get(columnName));
            switch (WhenMappings.$EnumSwitchMapping$0[attribute.getDataType().ordinal()]) {
                case 1: {
                    SqliteHelperKt.bindString(this.getStatement(), attribute, null);
                    break;
                }
                case 2: {
                    SqliteHelperKt.bindLong(this.getStatement(), attribute, null);
                    break;
                }
                case 3: {
                    SqliteHelperKt.bindDate(this.getStatement(), attribute, null);
                    break;
                }
                case 4: {
                    SqliteHelperKt.bindYORN(this.getStatement(), attribute, null);
                    break;
                }
                case 5: {
                    SqliteHelperKt.bindDecimal(this.getStatement(), attribute, null);
                    break;
                }
                case 6: {
                    SqliteHelperKt.bindBlob(this.getStatement(), attribute, null);
                }
            }
        }
        this.getStatement().execute();
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataTypes.values().length];
            try {
                nArray[DataTypes.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.INTEGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.DATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.YORN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.DECIMAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.BLOB.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

