/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.sqlite;

import com.interlocsolutions.maximo.notify.sqlite.AttributeMapping;
import com.interlocsolutions.maximo.notify.sqlite.DataTypes;
import com.interlocsolutions.maximo.notify.sqlite.SqliteHelperKt;
import com.interlocsolutions.maximo.notify.util.ConnectionCloseableWrapper;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.StatementCloseableWrapper;
import java.io.Closeable;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J*\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bJ*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\u0012"}, d2={"Lcom/interlocsolutions/maximo/notify/sqlite/SqliteTableGenerator;", "", "()V", "createCatalogTable", "", "dbFile", "Ljava/io/File;", "createTableForCatalog", "catalogName", "", "catalogMappings", "", "Lcom/interlocsolutions/maximo/notify/sqlite/AttributeMapping;", "generateSqlStatement", "Ljava/sql/PreparedStatement;", "connection", "Ljava/sql/Connection;", "mappings", "isinformer"})
public final class SqliteTableGenerator {
    @NotNull
    public static final SqliteTableGenerator INSTANCE = new SqliteTableGenerator();

    private SqliteTableGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createCatalogTable(@NotNull File dbFile) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Connection $this$use$iv = SqliteHelperKt.openConnection(dbFile);
        boolean $i$f$use = false;
        Closeable closeable = (Closeable)new ConnectionCloseableWrapper($this$use$iv);
        Throwable throwable = null;
        try {
            boolean bl;
            ConnectionCloseableWrapper it$iv = (ConnectionCloseableWrapper)closeable;
            boolean bl2 = false;
            Connection connection = $this$use$iv;
            boolean bl3 = false;
            Statement $this$use$iv2 = connection.createStatement();
            boolean $i$f$use2 = false;
            Closeable closeable2 = (Closeable)new StatementCloseableWrapper($this$use$iv2);
            Throwable throwable2 = null;
            try {
                StatementCloseableWrapper it$iv2 = (StatementCloseableWrapper)closeable2;
                boolean bl4 = false;
                Statement s = $this$use$iv2;
                boolean bl5 = false;
                bl = s.execute("CREATE TABLE \"catalog_table\" (\"client_id\" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, \n                              \"count\" INTEGER NULL, \n                              \"device_id\" INTEGER NOT NULL, \n                              \"is_more_record\" INTEGER NULL CHECK (\"is_more_record\" IN (0, 1)), \n                              \"last_update_date\" TEXT NULL, \n                              \"name\" TEXT NOT NULL, \n                              \"notification_name\" TEXT NOT NULL, \n                              \"partition\" TEXT NULL, \n                              \"position\" INTEGER NOT NULL, \n                              \"update_sequence\" INTEGER NOT NULL)");
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            boolean bl6 = bl;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createTableForCatalog(@NotNull File dbFile, @NotNull String catalogName, @NotNull Map<String, AttributeMapping> catalogMappings) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter((Object)catalogName, (String)"catalogName");
        Intrinsics.checkNotNullParameter(catalogMappings, (String)"catalogMappings");
        Connection $this$use$iv = SqliteHelperKt.openConnection(dbFile);
        boolean $i$f$use = false;
        Closeable closeable = (Closeable)new ConnectionCloseableWrapper($this$use$iv);
        Throwable throwable = null;
        try {
            boolean bl;
            ConnectionCloseableWrapper it$iv = (ConnectionCloseableWrapper)closeable;
            boolean bl2 = false;
            Connection connection = $this$use$iv;
            boolean bl3 = false;
            StringBuilder sb = new StringBuilder(StringsKt.trimIndent((String)("\n            CREATE TABLE \"" + catalogName + "\" (CLIENT_ID TEXT NOT NULL PRIMARY KEY, \n                DELETED INTEGER NOT NULL CHECK (DELETED IN (0, 1)), \n                RECORD_ID INTEGER NULL \n        ")));
            for (AttributeMapping attribute : catalogMappings.values()) {
                String required = attribute.getRequired() ? "NOT NULL" : "NULL";
                switch (WhenMappings.$EnumSwitchMapping$0[attribute.getDataType().ordinal()]) {
                    case 1: {
                        sb.append(", " + attribute.getColumnName() + " TEXT " + required);
                        if (attribute.getStatic()) break;
                        sb.append(", " + attribute.getMaxColumnName() + " TEXT " + required);
                        break;
                    }
                    case 2: {
                        sb.append(", " + attribute.getColumnName() + " INTEGER " + required + " CHECK (\"" + attribute.getColumnName() + "\" in (null, 0, 1))");
                        if (attribute.getStatic()) break;
                        sb.append(", " + attribute.getMaxColumnName() + " INTEGER " + required + " CHECK (\"" + attribute.getMaxColumnName() + "\" in (null, 0, 1))");
                        break;
                    }
                    case 3: {
                        sb.append(", " + attribute.getColumnName() + " TEXT " + required);
                        if (attribute.getStatic()) break;
                        sb.append(", " + attribute.getMaxColumnName() + " TEXT " + required);
                        break;
                    }
                    case 4: {
                        sb.append(", " + attribute.getColumnName() + " INTEGER " + required);
                        if (attribute.getStatic()) break;
                        sb.append(", " + attribute.getMaxColumnName() + " INTEGER " + required);
                        break;
                    }
                    case 5: {
                        sb.append(", " + attribute.getColumnName() + " NUMERIC " + required);
                        if (attribute.getStatic()) break;
                        sb.append(", " + attribute.getMaxColumnName() + " NUMERIC " + required);
                        break;
                    }
                    case 6: {
                        sb.append(", " + attribute.getColumnName() + " BLOB " + required);
                        if (attribute.getStatic()) break;
                        sb.append(", " + attribute.getMaxColumnName() + " BLOB " + required);
                    }
                }
            }
            sb.append(")");
            Statement $this$use$iv2 = connection.createStatement();
            boolean $i$f$use2 = false;
            Closeable closeable2 = (Closeable)new StatementCloseableWrapper($this$use$iv2);
            Throwable throwable2 = null;
            try {
                boolean bl4;
                StatementCloseableWrapper it$iv2 = (StatementCloseableWrapper)closeable2;
                boolean bl5 = false;
                Statement s = $this$use$iv2;
                boolean bl6 = false;
                try {
                    bl4 = s.execute(sb.toString());
                }
                catch (SQLException e) {
                    NotifyConstants.INFORMER_CRQP_LOGGER.error((Object)("Error creating catalog database.  " + e.getMessage() + ". Catalog " + catalogName + ".  " + sb));
                    throw e;
                }
                bl = bl4;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            boolean bl7 = bl;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final PreparedStatement generateSqlStatement(@NotNull Connection connection, @NotNull String catalogName, @NotNull Map<String, AttributeMapping> mappings) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)catalogName, (String)"catalogName");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        StringBuilder columnNameSql = new StringBuilder();
        StringBuilder columnValueSql = new StringBuilder();
        columnNameSql.append("(client_id, deleted, record_id");
        columnValueSql.append("(?, 0, ?");
        int index = 3;
        for (Map.Entry<String, AttributeMapping> attribute : mappings.entrySet()) {
            attribute.getValue().setColumnIndex(index);
            columnNameSql.append(", " + attribute.getValue().getColumnName());
            columnValueSql.append(", ?");
            ++index;
            if (attribute.getValue().getStatic()) continue;
            columnNameSql.append(", " + attribute.getValue().getMaxColumnName());
            columnValueSql.append(", ?");
            ++index;
        }
        columnNameSql.append(")");
        columnValueSql.append(")");
        String sql = "insert into " + catalogName + ' ' + columnNameSql + " values " + columnValueSql;
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"connection.prepareStatement(sql)");
        return preparedStatement;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataTypes.values().length];
            try {
                nArray[DataTypes.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.YORN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.DATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.INTEGER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.DECIMAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.BLOB.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

