/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.sqlite;

import com.interlocsolutions.maximo.notify.sqlite.AttributeMapping;
import com.interlocsolutions.maximo.notify.sqlite.DataTypes;
import com.interlocsolutions.maximo.notify.util.StatementCloseableWrapper;
import java.io.Closeable;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboValue;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\t\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n\u001a%\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\r\u001a%\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010\u001a\u001e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0012\u001a \u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\n\u001a%\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016\u001a\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001b"}, d2={"bindBlob", "", "statement", "Ljava/sql/PreparedStatement;", "attribute", "Lcom/interlocsolutions/maximo/notify/sqlite/AttributeMapping;", "value", "", "bindDate", "Ljava/util/Date;", "", "bindDecimal", "", "(Ljava/sql/PreparedStatement;Lcom/interlocsolutions/maximo/notify/sqlite/AttributeMapping;Ljava/lang/Double;)V", "bindLong", "", "(Ljava/sql/PreparedStatement;Lcom/interlocsolutions/maximo/notify/sqlite/AttributeMapping;Ljava/lang/Long;)V", "bindMboValue", "Lpsdi/mbo/MboValue;", "bindString", "bindYORN", "", "(Ljava/sql/PreparedStatement;Lcom/interlocsolutions/maximo/notify/sqlite/AttributeMapping;Ljava/lang/Integer;)V", "openConnection", "Ljava/sql/Connection;", "dbFile", "Ljava/io/File;", "isinformer"})
public final class SqliteHelperKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Connection openConnection(@NotNull File dbFile) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Class.forName("org.sqlite.JDBC");
        String dbURL = "jdbc:sqlite:" + dbFile.getPath();
        Connection rc2 = DriverManager.getConnection(dbURL);
        rc2.setAutoCommit(true);
        Statement $this$use$iv = rc2.createStatement();
        boolean $i$f$use = false;
        Closeable closeable = (Closeable)new StatementCloseableWrapper($this$use$iv);
        Throwable throwable = null;
        try {
            StatementCloseableWrapper it$iv = (StatementCloseableWrapper)closeable;
            boolean bl = false;
            Statement statement = $this$use$iv;
            boolean bl2 = false;
            statement.execute("PRAGMA synchronous = OFF");
            boolean bl3 = statement.execute("PRAGMA journal_mode = MEMORY");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)rc2, (String)"rc");
        return rc2;
    }

    public static final void bindMboValue(@NotNull PreparedStatement statement, @NotNull AttributeMapping attribute, @NotNull MboValue value) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (WhenMappings.$EnumSwitchMapping$0[attribute.getDataType().ordinal()]) {
            case 1: {
                if (value.isNull()) {
                    SqliteHelperKt.bindString(statement, attribute, null);
                    break;
                }
                SqliteHelperKt.bindString(statement, attribute, value.getString());
                break;
            }
            case 2: {
                if (value.isNull()) {
                    SqliteHelperKt.bindLong(statement, attribute, null);
                    break;
                }
                SqliteHelperKt.bindLong(statement, attribute, value.getLong());
                break;
            }
            case 3: {
                if (value.isNull()) {
                    SqliteHelperKt.bindYORN(statement, attribute, null);
                    break;
                }
                SqliteHelperKt.bindYORN(statement, attribute, value.getInt());
                break;
            }
            case 4: {
                if (value.isNull()) {
                    SqliteHelperKt.bindDecimal(statement, attribute, null);
                    break;
                }
                SqliteHelperKt.bindDecimal(statement, attribute, value.getDouble());
                break;
            }
            case 5: {
                if (value.isNull()) {
                    SqliteHelperKt.bindDate(statement, attribute, null);
                    break;
                }
                SqliteHelperKt.bindDate(statement, attribute, value.getDate());
                break;
            }
            case 6: {
                if (value.isNull()) {
                    SqliteHelperKt.bindBlob(statement, attribute, null);
                    break;
                }
                SqliteHelperKt.bindBlob(statement, attribute, value.getBytes());
            }
        }
    }

    public static final void bindString(@NotNull PreparedStatement statement, @NotNull AttributeMapping attribute, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        CharSequence charSequence = value;
        if (charSequence == null || charSequence.length() == 0) {
            statement.setNull(attribute.getColumnIndex(), 12);
            if (!attribute.getStatic()) {
                statement.setNull(attribute.getColumnIndex() + 1, 12);
            }
        } else {
            statement.setString(attribute.getColumnIndex(), value);
            if (!attribute.getStatic()) {
                statement.setString(attribute.getColumnIndex() + 1, value);
            }
        }
    }

    public static final void bindLong(@NotNull PreparedStatement statement, @NotNull AttributeMapping attribute, @Nullable Long value) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (value == null) {
            statement.setNull(attribute.getColumnIndex(), 4);
            if (!attribute.getStatic()) {
                statement.setNull(attribute.getColumnIndex() + 1, 4);
            }
        } else {
            statement.setLong(attribute.getColumnIndex(), value);
            if (!attribute.getStatic()) {
                statement.setLong(attribute.getColumnIndex() + 1, value);
            }
        }
    }

    public static final void bindDate(@NotNull PreparedStatement statement, @NotNull AttributeMapping attribute, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        statement.setString(attribute.getColumnIndex(), value);
        if (!attribute.getStatic()) {
            statement.setString(attribute.getColumnIndex() + 1, value);
        }
    }

    public static final void bindDate(@NotNull PreparedStatement statement, @NotNull AttributeMapping attribute, @Nullable Date value) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (value == null) {
            statement.setNull(attribute.getColumnIndex(), 91);
            if (!attribute.getStatic()) {
                statement.setNull(attribute.getColumnIndex() + 1, 91);
            }
        } else {
            String txt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(value);
            statement.setString(attribute.getColumnIndex(), txt);
            if (!attribute.getStatic()) {
                statement.setString(attribute.getColumnIndex() + 1, txt);
            }
        }
    }

    public static final void bindYORN(@NotNull PreparedStatement statement, @NotNull AttributeMapping attribute, @Nullable Integer value) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (value == null) {
            statement.setNull(attribute.getColumnIndex(), 4);
            if (!attribute.getStatic()) {
                statement.setNull(attribute.getColumnIndex() + 1, 4);
            }
        } else {
            statement.setInt(attribute.getColumnIndex(), value);
            if (!attribute.getStatic()) {
                statement.setInt(attribute.getColumnIndex() + 1, value);
            }
        }
    }

    public static final void bindDecimal(@NotNull PreparedStatement statement, @NotNull AttributeMapping attribute, @Nullable Double value) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (value == null) {
            statement.setNull(attribute.getColumnIndex(), 3);
            if (!attribute.getStatic()) {
                statement.setNull(attribute.getColumnIndex() + 1, 3);
            }
        } else {
            statement.setDouble(attribute.getColumnIndex(), value);
            if (!attribute.getStatic()) {
                statement.setDouble(attribute.getColumnIndex() + 1, value);
            }
        }
    }

    public static final void bindBlob(@NotNull PreparedStatement statement, @NotNull AttributeMapping attribute, @Nullable byte[] value) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (value == null) {
            statement.setNull(attribute.getColumnIndex(), 2004);
            if (!attribute.getStatic()) {
                statement.setNull(attribute.getColumnIndex() + 1, 2004);
            }
        } else {
            statement.setBytes(attribute.getColumnIndex(), value);
            if (!attribute.getStatic()) {
                statement.setBytes(attribute.getColumnIndex() + 1, value);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataTypes.values().length];
            try {
                nArray[DataTypes.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.INTEGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.YORN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.DECIMAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.DATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTypes.BLOB.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

