/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.sqlite;

import com.interlocsolutions.maximo.notify.sqlite.AttributeMapping;
import com.interlocsolutions.maximo.notify.sqlite.MaximoSqliteAttributeMapper;
import com.interlocsolutions.maximo.notify.sqlite.MboRecordInserter;
import com.interlocsolutions.maximo.notify.sqlite.SqliteHelperKt;
import com.interlocsolutions.maximo.notify.sqlite.SqliteRecordInserter;
import com.interlocsolutions.maximo.notify.sqlite.SqliteTableGenerator;
import com.interlocsolutions.maximo.notify.sqlite.XmlRecordInserter;
import com.interlocsolutions.maximo.notify.util.ConnectionCloseableWrapper;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.util.ResultSetCloseableWrapper;
import com.interlocsolutions.maximo.notify.util.StatementCloseableWrapper;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.util.MboSetIterator;
import com.interlocsolutions.maximo.util.MboSetLowMemIterator;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/interlocsolutions/maximo/notify/sqlite/SqliteDatabaseGenerator;", "", "profile", "Lpsdi/mbo/MboRemote;", "(Lpsdi/mbo/MboRemote;)V", "catalogMappings", "", "", "", "Lcom/interlocsolutions/maximo/notify/sqlite/AttributeMapping;", "createDatabaseFile", "Ljava/io/File;", "generateDatabase", "langCode", "populateCatalogTable", "", "dbFile", "catalog", "uploadDatabase", "isinformer"})
public final class SqliteDatabaseGenerator {
    @NotNull
    private final MboRemote profile;
    @NotNull
    private final Map<String, Map<String, AttributeMapping>> catalogMappings;

    public SqliteDatabaseGenerator(@NotNull MboRemote profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.profile = profile;
        this.catalogMappings = new LinkedHashMap();
    }

    @NotNull
    public final File generateDatabase(@NotNull String langCode) {
        Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
        MboSetRemote catalogs = this.profile.getMboSet("CATALOG");
        catalogs.setOrderBy("CATALOG");
        File rc2 = this.createDatabaseFile();
        SqliteTableGenerator.INSTANCE.createCatalogTable(rc2);
        for (MboRemote catalog : new MboSetIterator(catalogs)) {
            String catalogName = catalog.getString("CATALOG");
            Intrinsics.checkNotNullExpressionValue((Object)catalogName, (String)"catalogName");
            Intrinsics.checkNotNullExpressionValue((Object)catalog, (String)"catalog");
            this.catalogMappings.put(catalogName, MaximoSqliteAttributeMapper.INSTANCE.createCatalogMappings(catalog));
            Map<String, AttributeMapping> map = this.catalogMappings.get(catalogName);
            Intrinsics.checkNotNull(map);
            SqliteTableGenerator.INSTANCE.createTableForCatalog(rc2, catalogName, map);
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, rc2, langCode, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SqliteDatabaseGenerator this$0;
            final /* synthetic */ File $rc;
            final /* synthetic */ String $langCode;
            {
                this.this$0 = $receiver;
                this.$rc = $rc;
                this.$langCode = $langCode;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        for (MboRemote catalog : new MboSetIterator(SqliteDatabaseGenerator.access$getProfile$p(this.this$0).getMboSet("CATALOG"))) {
                            BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$rc, catalog, this.$langCode, null){
                                int label;
                                final /* synthetic */ SqliteDatabaseGenerator this$0;
                                final /* synthetic */ File $rc;
                                final /* synthetic */ MboRemote $catalog;
                                final /* synthetic */ String $langCode;
                                {
                                    this.this$0 = $receiver;
                                    this.$rc = $rc;
                                    this.$catalog = $catalog;
                                    this.$langCode = $langCode;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            MboRemote mboRemote = this.$catalog;
                                            Intrinsics.checkNotNullExpressionValue((Object)mboRemote, (String)"catalog");
                                            SqliteDatabaseGenerator.access$populateCatalogTable(this.this$0, this.$rc, mboRemote, this.$langCode);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return rc2;
    }

    public final void uploadDatabase(@NotNull File dbFile, @NotNull String langCode) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
        MboSetRemote resourceSet = this.profile.getMboSet("NOTIFYRESOURCE");
        MboRemote resource = resourceSet.add();
        resource.setValue("CREATEDATE", MXServer.getMXServer().getDate(), 2L);
        resource.setValue("NAME", this.profile.getString("NOTIFYNUM"), 2L);
        resource.setValue("RESOURCETYPE", "DATABASE", 3L);
        resource.setValue("LANGCODE", langCode, 3L);
        byte[] data = IOUtils.toByteArray((InputStream)new FileInputStream(dbFile));
        resource.setValue("DATA", Base64.encodeBase64String(data), 2L);
        resourceSet.save();
    }

    private final File createDatabaseFile() {
        File file = File.createTempFile(this.profile.getString("NOTIFYNUM"), ".sqlite");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(profile.g\u2026(\"NOTIFYNUM\"), \".sqlite\")");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void populateCatalogTable(File dbFile, MboRemote catalog, String langCode) {
        Object object = PropUtil.INSTANCE.getProp("informer.catalog.xml.store");
        boolean storeXml = object != null && (object = ((InformerProp)object).asBoolean()) != null ? (Boolean)object : true;
        Connection $this$use$iv = SqliteHelperKt.openConnection(dbFile);
        boolean $i$f$use = false;
        Closeable closeable = (Closeable)new ConnectionCloseableWrapper($this$use$iv);
        Throwable throwable = null;
        try {
            ConnectionCloseableWrapper it$iv = (ConnectionCloseableWrapper)closeable;
            boolean bl = false;
            Connection connection = $this$use$iv;
            boolean bl2 = false;
            String profileName = catalog.getString("NOTIFY.NOTIFYNUM");
            String catalogName = catalog.getString("CATALOG");
            Map catalogTable = new LinkedHashMap();
            Statement $this$use$iv2 = connection.prepareStatement("insert into catalog_table (name, notification_name, partition, device_id, is_more_record, position, update_sequence, count) values (?, ?, ?, -1, 0, 0, 0, 0)", 1);
            boolean $i$f$use2 = false;
            Closeable closeable2 = (Closeable)new StatementCloseableWrapper($this$use$iv2);
            Throwable throwable2 = null;
            try {
                StatementCloseableWrapper it$iv2 = (StatementCloseableWrapper)closeable2;
                boolean bl3 = false;
                PreparedStatement insertStatement = (PreparedStatement)$this$use$iv2;
                boolean bl4 = false;
                Statement $this$use$iv3 = connection.prepareStatement("UPDATE catalog_table SET count = count + 1, position = position + 1, last_update_date = datetime(), update_sequence = ? where client_id = ?");
                boolean $i$f$use3 = false;
                Closeable closeable3 = (Closeable)new StatementCloseableWrapper($this$use$iv3);
                Throwable throwable3 = null;
                try {
                    StatementCloseableWrapper it$iv3 = (StatementCloseableWrapper)closeable3;
                    $i$a$-use-JDBCExtensionsKt$use$2$iv = false;
                    PreparedStatement updateStatement = (PreparedStatement)$this$use$iv3;
                    boolean bl5 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)catalogName, (String)"catalogName");
                    Map<String, AttributeMapping> map = this.catalogMappings.get(catalogName);
                    Intrinsics.checkNotNull(map);
                    Statement $this$use$iv4 = SqliteTableGenerator.INSTANCE.generateSqlStatement(connection, catalogName, map);
                    boolean $i$f$use4 = false;
                    Closeable closeable4 = (Closeable)new StatementCloseableWrapper($this$use$iv4);
                    Throwable throwable4 = null;
                    try {
                        SqliteRecordInserter sqliteRecordInserter;
                        StatementCloseableWrapper it$iv4 = (StatementCloseableWrapper)closeable4;
                        $i$a$-use-JDBCExtensionsKt$use$2$iv = false;
                        PreparedStatement s = (PreparedStatement)$this$use$iv4;
                        boolean bl6 = false;
                        if (storeXml) {
                            Map<String, AttributeMapping> map2 = this.catalogMappings.get(catalog.getString("CATALOG"));
                            Intrinsics.checkNotNull(map2);
                            sqliteRecordInserter = new XmlRecordInserter(catalog, s, map2);
                        } else {
                            Map<String, AttributeMapping> map3 = this.catalogMappings.get(catalog.getString("CATALOG"));
                            Intrinsics.checkNotNull(map3);
                            sqliteRecordInserter = new MboRecordInserter(catalog, s, map3);
                        }
                        SqliteRecordInserter recordInserter = sqliteRecordInserter;
                        SqlFormat sf = new SqlFormat("LANGCODE = :1");
                        sf.setObject(1, "ISCATALOGDATA", "LANGCODE", langCode);
                        MboSetRemote catalogData = catalog.getMboSet("CATALOGDATA");
                        catalogData.setWhere(sf.format());
                        catalogData.setLogLargFetchResultDisabled(true);
                        boolean recordInserted = false;
                        for (MboRemote mboRemote : new MboSetLowMemIterator(catalogData)) {
                            String partitionName = mboRemote.getString("PARTITIONNAME");
                            String key = profileName + ':' + catalogName + ':' + partitionName;
                            if (!catalogTable.containsKey(key)) {
                                insertStatement.setString(1, catalogName);
                                insertStatement.setString(2, profileName);
                                insertStatement.setString(3, partitionName);
                                insertStatement.execute();
                                ResultSet $this$use$iv5 = insertStatement.getGeneratedKeys();
                                boolean $i$f$use5 = false;
                                Closeable closeable5 = (Closeable)new ResultSetCloseableWrapper($this$use$iv5);
                                Throwable throwable5 = null;
                                try {
                                    ResultSetCloseableWrapper it$iv5 = (ResultSetCloseableWrapper)closeable5;
                                    boolean bl7 = false;
                                    ResultSet it = $this$use$iv5;
                                    boolean bl8 = false;
                                    if (!it.next()) {
                                        boolean bl9 = false;
                                        String string = "Unable to retrieve generated id";
                                        throw new IllegalStateException(string.toString());
                                    }
                                    catalogTable.put(key, it.getLong(1));
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable6) {
                                    throwable5 = throwable6;
                                    throw throwable6;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable5, (Throwable)throwable5);
                                }
                                recordInserted = true;
                            }
                            updateStatement.setLong(1, mboRemote.getLong("SEQUENCE"));
                            Object v = catalogTable.get(key);
                            Intrinsics.checkNotNull(v);
                            updateStatement.setLong(2, ((Number)v).longValue());
                            updateStatement.execute();
                            try {
                                Intrinsics.checkNotNullExpressionValue((Object)mboRemote, (String)"mboRemote");
                                recordInserter.insert(mboRemote);
                            }
                            catch (SQLException e) {
                                NotifyConstants.INFORMER_CRQP_LOGGER.error((Object)("Error populating catalog table " + catalog.getString("CATALOG") + ".  ISCATALOGDATA id=" + mboRemote.getUniqueIDValue()), (Throwable)e);
                                throw e;
                            }
                        }
                        if (!recordInserted) {
                            insertStatement.setString(1, catalogName);
                            insertStatement.setString(2, profileName);
                            insertStatement.setString(3, null);
                            insertStatement.execute();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable7) {
                        throwable4 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable8) {
                    throwable3 = throwable8;
                    throw throwable8;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable9) {
                throwable2 = throwable9;
                throw throwable9;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable10) {
            throwable = throwable10;
            throw throwable10;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ MboRemote access$getProfile$p(SqliteDatabaseGenerator $this) {
        return $this.profile;
    }

    public static final /* synthetic */ void access$populateCatalogTable(SqliteDatabaseGenerator $this, File dbFile, MboRemote catalog, String langCode) {
        $this.populateCatalogTable(dbFile, catalog, langCode);
    }
}

