/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.security.datavalidator;

import com.interlocsolutions.maximo.notify.FileFragmentRemote;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.security.datavalidator.SendFileValidator;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.io.IOException;
import java.rmi.RemoteException;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class SendFileValidationManager {
    public static final String PUBLIC_VALIDATOR_CLASSNAME_PROPERTY = "informer.public.sendfile.validator";
    public static final String VALIDATOR_CLASSNAME_PROPERTY = "informer.sendfile.validator";

    public static void validateFileToReceive(SessionInfo session, String docType, String fileName) throws MXApplicationException {
        SendFileValidator sendFileValidator = SendFileValidationManager.getSendFileValidator(session);
        if (sendFileValidator != null) {
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Validating file to receive " + fileName + " with validator " + sendFileValidator.getClass().getName() + " for session " + session.getSessionKey()));
            }
            sendFileValidator.validateFileToReceive(session, docType, fileName);
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Completed validation of file to receive " + fileName + " with validator " + sendFileValidator.getClass().getName() + " for session " + session.getSessionKey()));
            }
        }
    }

    public static long validateAndFinalizeReceivedFile(SessionInfo session, String docType, String fileName, FileFragmentRemote fileFragment) throws MXException, IOException {
        SendFileValidator sendFileValidator = SendFileValidationManager.getSendFileValidator(session);
        if (sendFileValidator != null && sendFileValidator.performsReceivedFileValidation()) {
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Validating received file " + fileName + " with validator " + sendFileValidator.getClass().getName() + " for session " + session.getSessionKey()));
            }
            String temporaryFilePath = sendFileValidator.getTemporaryFilePathForReceivedFileValidation(session, docType, fileName);
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Writing received file to " + temporaryFilePath));
            }
            fileFragment.writeFile(temporaryFilePath);
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Validating received file at " + temporaryFilePath + " with validator " + sendFileValidator.getClass().getName()));
            }
            sendFileValidator.validateReceivedFile(session, docType, fileName, temporaryFilePath);
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Completed validation of received file " + fileName + " with validator " + sendFileValidator.getClass().getName() + " for session " + session.getSessionKey()));
            }
            return fileFragment.moveFileToDestinationFilePath(temporaryFilePath);
        }
        return fileFragment.writeFile();
    }

    public static SendFileValidator getSendFileValidator(SessionInfo session) throws MXApplicationException {
        try {
            String sendFileValidatorClassname = null;
            if (session.isAnonymous()) {
                sendFileValidatorClassname = MXServer.getMXServer().getProperty(PUBLIC_VALIDATOR_CLASSNAME_PROPERTY);
            }
            if (sendFileValidatorClassname == null || sendFileValidatorClassname.trim().length() == 0) {
                sendFileValidatorClassname = MXServer.getMXServer().getProperty(VALIDATOR_CLASSNAME_PROPERTY);
            }
            if (sendFileValidatorClassname != null && sendFileValidatorClassname.trim().length() > 0) {
                try {
                    Class<?> validatorClass = Class.forName(sendFileValidatorClassname.trim());
                    if (SendFileValidator.class.isAssignableFrom(validatorClass)) {
                        return (SendFileValidator)validatorClass.newInstance();
                    }
                    if (NotifyConstants.INFORMER_LOGGER.isErrorEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.error((Object)("Send file validator class: " + sendFileValidatorClassname + " is of incorrect type.  It must implement " + SendFileValidator.class.getName()));
                    }
                    throw new MXApplicationException("informer", "invalidSendFileValidator");
                }
                catch (ClassNotFoundException e) {
                    if (NotifyConstants.INFORMER_LOGGER.isErrorEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.error((Object)("Error instantiating send file validator class: " + sendFileValidatorClassname), (Throwable)e);
                    }
                    throw new MXApplicationException("informer", "invalidSendFileValidator");
                }
                catch (InstantiationException e) {
                    if (NotifyConstants.INFORMER_LOGGER.isErrorEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.error((Object)("Error instantiating send file validator class: " + sendFileValidatorClassname), (Throwable)e);
                    }
                    throw new MXApplicationException("informer", "invalidSendFileValidator");
                }
                catch (IllegalAccessException e) {
                    if (NotifyConstants.INFORMER_LOGGER.isErrorEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.error((Object)("Error instantiating send file validator class: " + sendFileValidatorClassname), (Throwable)e);
                    }
                    throw new MXApplicationException("informer", "invalidSendFileValidator");
                }
            }
            return null;
        }
        catch (RemoteException e) {
            if (NotifyConstants.INFORMER_LOGGER.isErrorEnabled()) {
                NotifyConstants.INFORMER_LOGGER.error((Object)"Error obtaining send file validator class", (Throwable)e);
            }
            throw new MXApplicationException("informer", "invalidSendFileValidator", (Throwable)e);
        }
    }
}

