/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.security.datavalidator;

import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.security.datavalidator.FileExtensionValidator;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import java.util.HashSet;
import psdi.server.MXServer;

public class InformerAllowedExtensionsValidator
extends FileExtensionValidator {
    public static final String PUBLIC_ALLOWED_EXTENSIONS_PROPERTY = "informer.public.sendfile.allowedFileExtensions";
    public static final String ALLOWED_EXTENSIONS_PROPERTY = "informer.sendfile.allowedFileExtensions";
    public static final String DEFAULT_ALLOWED_EXTENSIONS = "jpg,png,gif,mp4,mov,m4v,pdf,doc,docx,xls,xlsx,ppt,pptx,xml,txt,csv";

    @Override
    protected HashSet<String> getAllowableExtensions(SessionInfo session) {
        HashSet<String> allowableExtensions = null;
        if (session.isAnonymous()) {
            allowableExtensions = this.getAllowableExtensions(PUBLIC_ALLOWED_EXTENSIONS_PROPERTY);
        }
        if (allowableExtensions == null) {
            allowableExtensions = this.getAllowableExtensions(ALLOWED_EXTENSIONS_PROPERTY);
        }
        return allowableExtensions;
    }

    protected HashSet<String> getAllowableExtensions(String allowedFileExtensionsProperty) {
        block4: {
            try {
                String allowedFileExtensionsPropertyValue = MXServer.getMXServer().getProperty(allowedFileExtensionsProperty);
                if (allowedFileExtensionsPropertyValue != null) {
                    HashSet<String> allowableFileExtensions = new HashSet<String>();
                    for (String extension : allowedFileExtensionsPropertyValue.split(",")) {
                        if (extension.length() <= 0) continue;
                        allowableFileExtensions.add(extension);
                    }
                    return allowableFileExtensions;
                }
            }
            catch (RemoteException e) {
                if (!NotifyConstants.INFORMER_LOGGER.isErrorEnabled()) break block4;
                NotifyConstants.INFORMER_LOGGER.error((Object)("Error retrieving system property: " + allowedFileExtensionsProperty), (Throwable)e);
            }
        }
        return null;
    }
}

