/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.security;

import com.interlocsolutions.maximo.notify.NotifySesssionSetRemote;
import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.security.SessionCache;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.security.UserIdentifier;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.ConnectionKey;
import psdi.security.UserInfo;
import psdi.server.DBManager;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.MXRowUpdateException;
import psdi.util.logging.MXLogger;

public class SessionManager {
    public static final String THREAD_LABEL = "Informer-SessionRefresh";
    private static final MXLogger logger = NotifyConstants.INFORMER_LOGGER;
    private static SessionManager singleton = new SessionManager();
    private final SessionCache mSessionCache = new SessionCache();
    private final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){
        int sequence = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName(this.sequence < 1 ? SessionManager.THREAD_LABEL : SessionManager.THREAD_LABEL + this.sequence);
            thread.setPriority(3);
            thread.setDaemon(true);
            ++this.sequence;
            return thread;
        }
    });
    private boolean started = false;
    private ScheduledFuture<?> sessionRenewTask;

    private SessionManager() {
    }

    public static SessionManager getInstance() {
        if (singleton == null) {
            singleton = new SessionManager();
        }
        return singleton;
    }

    public static SessionInfo getValidNotifySession(String sessionId, UserInfo userInfo) throws NotifyFault {
        SessionInfo session = SessionManager.getInstance().getValidNotifySession0(sessionId, userInfo);
        if (session.getUserId() == null || session.getUserId().trim().isEmpty()) {
            throw new NotifyFault((MXException)((Object)new InformerException("usernameRequired")));
        }
        return session;
    }

    @NotNull
    public static SessionInfo getValidNotifySessionForProfile(String sessionId, String profile, UserInfo userInfo) throws NotifyFault {
        SessionInfo session = SessionManager.getInstance().getValidNotifySessionForProfile0(sessionId, profile, userInfo);
        if (session.getUserId() == null || session.getUserId().trim().isEmpty()) {
            throw new NotifyFault((MXException)((Object)new InformerException("usernameRequired")));
        }
        return session;
    }

    public static void removeSession(String sessionId) throws NotifyFault {
        SessionManager.getInstance().removeSession0(sessionId);
    }

    public static SessionInfo getValidNotifyAnonymousSession(String sessionId, UserInfo userInfo) throws NotifyFault {
        return SessionManager.getInstance().getValidNotifyAnonymousSession0(sessionId, userInfo);
    }

    public static SessionInfo getValidNotifyAnonymousSessionForProfile(String sessionId, String profile, UserInfo userInfo) throws NotifyFault {
        return SessionManager.getInstance().getValidNotifyAnonymousSessionForProfile0(sessionId, profile, userInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUp() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (!this.started) {
                this.sessionRenewTask = this.executor.scheduleWithFixedDelay(new SessionRenewTask(), 1L, 1L, TimeUnit.MINUTES);
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (this.sessionRenewTask != null) {
                this.sessionRenewTask.cancel(true);
            }
            this.executor.shutdownNow();
        }
    }

    public SessionInfo getValidNotifySession0(String sessionId, UserInfo userInfo) throws NotifyFault {
        return this.getValidSession0(sessionId, false, userInfo);
    }

    @NotNull
    public SessionInfo getValidNotifySessionForProfile0(String sessionId, String profile, UserInfo userInfo) throws NotifyFault {
        return this.getValidSessionForProfile0(sessionId, false, profile, userInfo);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeSession0(String sessionId) throws NotifyFault {
        this.mSessionCache.removeSession(sessionId);
        int attemptNum = 1;
        boolean successful = false;
        while (!successful) {
            MboSetRemote sessionSet = null;
            try {
                MXServer mxServer = MXServer.getMXServer();
                sessionSet = mxServer.getMboSet("ISSESSION", mxServer.getSystemUserInfo());
                SqlFormat sqlf = new SqlFormat("sessionkey = :1");
                sqlf.setObject(1, "ISSESSION", "SESSIONKEY", sessionId);
                sessionSet.setWhere(sqlf.format());
                sessionSet.deleteAll();
                sessionSet.save();
                successful = true;
            }
            catch (MXRowUpdateException e) {
                if (attemptNum >= 3) {
                    logger.error((Object)String.format("Unable to remove session '%s' due to %s (\"%s\"). Giving up.", sessionId, ((Object)((Object)e)).getClass().getName(), e.getMessage()));
                    throw new NotifyFault((MXException)((Object)e));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Unable to remove session '%s' due to %s (\"%s\"). Trying again.", sessionId, ((Object)((Object)e)).getClass().getName(), e.getMessage()));
                }
                ++attemptNum;
                {
                    catch (Throwable throwable) {
                        NotifyUtil.closeAndCleanup(sessionSet);
                        throw throwable;
                    }
                }
                NotifyUtil.closeAndCleanup(sessionSet);
                continue;
                catch (RemoteException e2) {
                    throw new NotifyFault(e2);
                    catch (MXException e3) {
                        throw new NotifyFault(e3);
                    }
                }
            }
            NotifyUtil.closeAndCleanup(sessionSet);
            continue;
            break;
        }
        return;
    }

    public SessionInfo getValidNotifyAnonymousSession0(String sessionId, UserInfo userInfo) throws NotifyFault {
        return this.getValidSession0(sessionId, true, userInfo);
    }

    @NotNull
    public SessionInfo getValidNotifyAnonymousSessionForProfile0(String sessionId, String profile, UserInfo userInfo) throws NotifyFault {
        return this.getValidSessionForProfile0(sessionId, true, profile, userInfo);
    }

    private SessionInfo getValidSession0(String sessionId, boolean isAnonymous, UserInfo userInfo) throws NotifyFault {
        SessionInfo session;
        if (sessionId == null || sessionId.trim().isEmpty()) {
            throw new NotifyFault("[informer:invalidSession]");
        }
        try {
            session = this.mSessionCache.getValidSessionForId(sessionId);
            if (session == null) {
                throw new NotifyFault("[informer:invalidSession]");
            }
            if (session.isAnonymous() != isAnonymous) {
                throw new NotifyFault("[informer:unauthorizedSession]");
            }
            if (!(isAnonymous || session.getUserId().equals(userInfo.getUserName()) || this.isDefaultUser(userInfo.getUserName()).booleanValue())) {
                throw new NotifyFault("[informer:unauthorizedSession]");
            }
        }
        catch (RemoteException | MXException e) {
            throw new NotifyFault((Exception)e);
        }
        try {
            this.mSessionCache.updateLastActive(sessionId);
        }
        catch (RemoteException | MXException e) {
            logger.error((Object)"Session could not be renewed", e);
        }
        return session;
    }

    private Boolean isDefaultUser(String userId) {
        UserIdentifier identifier;
        InformerProp IdentifierClassName = PropUtil.INSTANCE.getProp("informer.userIdentifier");
        String className = IdentifierClassName != null ? IdentifierClassName.asString("com.interlocsolutions.maximo.notify.security.DefaultUserIdentifier") : "com.interlocsolutions.maximo.notify.security.DefaultUserIdentifier";
        try {
            identifier = (UserIdentifier)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error((Object)"The default users could not be identified.", (Throwable)e);
            throw new NotifyFault("[informer:unauthorizedSession]");
        }
        return identifier.isDefaultUser(userId);
    }

    @NotNull
    private SessionInfo getValidSessionForProfile0(String sessionId, boolean isAnonymous, String profile, UserInfo userInfo) throws NotifyFault {
        SessionInfo session;
        if (profile != null && profile.trim().length() > 0 && (session = this.getValidSession0(sessionId, isAnonymous, userInfo)).isValidForProfile(profile)) {
            return session;
        }
        throw new NotifyFault("[informer:unauthorizedSession]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionResult createSession(@NotNull SessionInfo sessionInfo) throws RemoteException, MXException {
        MXServer mxServer = MXServer.getMXServer();
        NotifySesssionSetRemote sessionSet = (NotifySesssionSetRemote)mxServer.getMboSet("ISSESSION", mxServer.getSystemUserInfo());
        try {
            MboRemote sessionMbo = sessionSet.addSession(sessionInfo);
            SessionResult sessionResult = new SessionResult(sessionInfo.getSessionKey(), sessionMbo.getDate("EXPIRES"));
            return sessionResult;
        }
        finally {
            NotifyUtil.closeAndCleanup(sessionSet);
        }
    }

    private class SessionRenewTask
    implements Runnable {
        private SessionRenewTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: {
                try {
                    long timeoutPeriod = PropUtils.getLongMaxProp("informer.session.timeout", 10L) * 60000L;
                    Date thePresent = MXServer.getMXServer().getDate();
                    Date cutoffDate = new Date(thePresent.getTime() + timeoutPeriod / 2L);
                    Collection<SessionInfo> sessions = SessionManager.this.mSessionCache.popSessionsBeforeThreshold(cutoffDate);
                    if (sessions.size() > 0) {
                        DBManager dbManager = MXServer.getMXServer().getDBManager();
                        ConnectionKey key = dbManager.getSystemConnectionKey();
                        try {
                            Connection c = dbManager.getConnection(key);
                            try (PreparedStatement ps = c.prepareStatement("UPDATE issession SET lastactive = ?, expires = ? WHERE sessionid = ? AND expires < ?");){
                                for (SessionInfo session : sessions) {
                                    Timestamp lastActivity = new Timestamp(session.getLastActive());
                                    Timestamp newExpiry = new Timestamp(lastActivity.getTime() + timeoutPeriod);
                                    if (newExpiry.before(thePresent)) {
                                        logger.warn((Object)String.format("Session '%s' could not be renewed because the write-back cache was not flushed in a timely manner. We are too late by %dms.", session.getSessionKey(), thePresent.getTime() - newExpiry.getTime()));
                                        continue;
                                    }
                                    ps.setTimestamp(1, lastActivity);
                                    ps.setTimestamp(2, newExpiry);
                                    ps.setLong(3, session.getSessionRowId());
                                    ps.setTimestamp(4, newExpiry);
                                    long numUpdated = ps.executeUpdate();
                                    if (logger.isDebugEnabled()) {
                                        if (numUpdated > 0L) {
                                            logger.debug((Object)String.format("Session %1$s was updated. Last Activity: %2$tF %2$tT. New Expiry: %3$tF %3$tT.", session.getSessionKey(), lastActivity, newExpiry));
                                        } else {
                                            logger.debug((Object)String.format("Session %1$s was not updated by this thread. The session either no longer exists, or was already updated to a later expiry than our target of %2$tF %2$tT.", session.getSessionKey(), newExpiry));
                                        }
                                    }
                                    c.commit();
                                }
                                break block14;
                            }
                        }
                        finally {
                            dbManager.freeConnection(key);
                        }
                    }
                    logger.debug((Object)"No sessions identified for renewal.");
                }
                catch (Exception e) {
                    logger.error((Object)"Sessions could not be renewed", (Throwable)e);
                }
            }
        }
    }

    public static class SessionResult {
        public final String sessionKey;
        public final Date expiration;

        SessionResult(String sessionKey, Date expiration) {
            this.sessionKey = sessionKey;
            this.expiration = expiration;
        }
    }
}

