/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.security;

import com.interlocsolutions.maximo.notify.NotifySessionRemote;
import com.interlocsolutions.maximo.notify.NotifySesssionSetRemote;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.util.MXServerFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXException;

class SessionCache {
    private final Object datastructureLock = new Object();
    private Map<String, SessionInfo> sessionsById = new HashMap<String, SessionInfo>();
    private Queue<SessionInfo> sessionsByAge = new PriorityQueue<SessionInfo>(10, new Comparator<SessionInfo>(){

        @Override
        public int compare(SessionInfo o1, SessionInfo o2) {
            long y;
            long x = o1.getTimeout();
            return x < (y = o2.getTimeout()) ? -1 : (x == y ? 0 : 1);
        }
    });

    SessionCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeSession(SessionInfo session) {
        Object object = this.datastructureLock;
        synchronized (object) {
            String sessionId = session.getSessionKey();
            this.sessionsById.put(sessionId, session);
            this.sessionsByAge.remove(session);
            this.sessionsByAge.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(String sessionId) {
        Object object = this.datastructureLock;
        synchronized (object) {
            SessionInfo cachedSession = this.sessionsById.get(sessionId);
            if (cachedSession != null) {
                this.sessionsById.remove(sessionId);
                this.sessionsByAge.remove(cachedSession);
            }
        }
    }

    SessionInfo getValidSessionForId(String sessionId) throws RemoteException, MXException {
        SessionInfo sessionFromDb = this.fetchFromPersistence(sessionId);
        if (sessionFromDb == null || !sessionFromDb.isValid()) {
            this.removeSession(sessionId);
            sessionFromDb = null;
        } else {
            SessionInfo sessionFromCache = this.fetchFromCache(sessionId);
            if (sessionFromCache != null) {
                sessionFromCache.setTimeout(sessionFromDb.getTimeout());
                if (sessionFromDb.getLastActive() > sessionFromCache.getLastActive()) {
                    sessionFromCache.setLastActive(sessionFromDb.getLastActive());
                }
            }
            this.storeSession(sessionFromDb);
        }
        return sessionFromDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionInfo fetchFromCache(String sessionId) throws RemoteException, MXException {
        SessionInfo cachedSession;
        Object object = this.datastructureLock;
        synchronized (object) {
            cachedSession = this.sessionsById.get(sessionId);
        }
        return cachedSession;
    }

    SessionInfo updateLastActive(String sessionId) throws RemoteException, MXException {
        return this.updateLastActive(sessionId, MXServer.getMXServer().getDate().getTime());
    }

    SessionInfo updateLastActive(String sessionId, long timeout) throws RemoteException, MXException {
        SessionInfo sessionInfo = this.fetchFromCache(sessionId);
        if (sessionInfo == null) {
            sessionInfo = this.fetchFromPersistence(sessionId);
        }
        if (sessionInfo != null) {
            sessionInfo.setLastActive(timeout);
            this.storeSession(sessionInfo);
        }
        return sessionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionInfo fetchFromPersistence(String sessionId) throws RemoteException, MXException {
        SessionInfo cachedSession;
        MXServer mxServer = MXServerFactory.getMXServer();
        UserInfo userInfo = mxServer.getSystemUserInfo();
        NotifySesssionSetRemote sessionSet = (NotifySesssionSetRemote)mxServer.getMboSet("ISSESSION", userInfo);
        try {
            SqlFormat sqlf = new SqlFormat("sessionkey = :1");
            sqlf.setObject(1, "ISSESSION", "SESSIONKEY", sessionId);
            sessionSet.setWhere(sqlf.format());
            NotifySessionRemote sessionMbo = (NotifySessionRemote)sessionSet.getMbo(0);
            cachedSession = sessionMbo == null ? null : new SessionInfo(sessionMbo);
        }
        finally {
            NotifyUtil.closeAndCleanup(sessionSet);
        }
        return cachedSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<SessionInfo> popSessionsBeforeThreshold(Date threshold) {
        Object object = this.datastructureLock;
        synchronized (object) {
            ArrayList<SessionInfo> poppedSessions = new ArrayList<SessionInfo>();
            SessionInfo next = this.sessionsByAge.peek();
            long thresholdMillis = threshold.getTime();
            while (next != null && next.getTimeout() < thresholdMillis) {
                poppedSessions.add(next);
                this.sessionsByAge.poll();
                this.sessionsById.remove(next.getSessionKey());
                next = this.sessionsByAge.peek();
            }
            return poppedSessions;
        }
    }
}

