/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.security;

import com.interlocsolutions.maximo.notify.security.Authenticator3;
import com.interlocsolutions.maximo.notify.security.OIDCAuthenticator;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.notify.xml.LoginExtras;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.modules.SerializersModule;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.security.UserInfo;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/interlocsolutions/maximo/notify/security/OIDCAuthenticator;", "Lcom/interlocsolutions/maximo/notify/security/Authenticator3;", "()V", "logger", "Lpsdi/util/logging/MXLogger;", "authenticate", "", "userInfo", "Lpsdi/security/UserInfo;", "password", "", "extras", "Lcom/interlocsolutions/maximo/notify/xml/LoginExtras;", "fetchOIDCUserInfo", "Lkotlinx/serialization/json/JsonObject;", "bearerToken", "fetchOpenIdConfiguration", "getClaimValue", "jwtPayload", "key", "getJWTPayload", "token", "getTokenType", "Lcom/interlocsolutions/maximo/notify/security/OIDCAuthenticator$Companion$TokenType;", "getUserinfoUrl", "Lokhttp3/HttpUrl;", "errorCheck", "Lcom/interlocsolutions/maximo/notify/security/OIDCAuthenticator$ErrorContent;", "Companion", "ErrorContent", "isinformer"})
public final class OIDCAuthenticator
implements Authenticator3 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private MXLogger logger;
    @NotNull
    public static final String OIDC_USER_INFO_COMPARING_CLAIM = "informer.authenticator.oidcuserinfocomparingid";
    @NotNull
    public static final String OIDC_ACCESS_TOKEN_COMPARING_CLAIM = "informer.authenticator.oidcaccesstokencomparingid";
    @NotNull
    public static final String OIDC_UNIQUE_IDENTIFIER = "informer.authenticator.oidcuniqueidentifier";
    @NotNull
    public static final String OIDC_USER_INFO_ENDPOINT_URL = "informer.authenticator.oidcuserinfoendpoint";
    @NotNull
    public static final String OIDC_CONFIGURATION_ENDPOINT_URL = "informer.authenticator.oidcconfigurationendpoint";
    @NotNull
    public static final String OIDC_TOKEN_TYPE = "informer.authenticator.oidctokentype";
    @NotNull
    private static final Json json = JsonKt.Json$default(null, (Function1)Companion.json.1.INSTANCE, (int)1, null);
    @NotNull
    private static final Lazy<OkHttpClient> httpClient$delegate = LazyKt.lazy((Function0)Companion.httpClient.2.INSTANCE);

    @Override
    public boolean authenticate(@NotNull UserInfo userInfo, @Nullable String password, @NotNull LoginExtras extras, @NotNull MXLogger logger2) {
        String msg$iv;
        boolean bl;
        String uniqueClaimValue;
        Object $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32;
        String string;
        Object object;
        CharSequence msg$iv2;
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
        CharSequence charSequence = password;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            boolean bl2;
            boolean it = bl2 = false;
            boolean bl3 = false;
            MXLogger $this$infoLazy_u24default$iv = logger2;
            Object e$iv = null;
            boolean $i$f$infoLazy = false;
            if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                Object $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$1$22;
                try {
                    boolean $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$1$22 = false;
                    $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$1$22 = Result.constructor-impl((Object)("No access token provided to " + Reflection.getOrCreateKotlinClass(OIDCAuthenticator.class).getSimpleName() + " for " + userInfo.getLoginID()));
                }
                catch (Throwable throwable) {
                    $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$1$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string2 = "(Unable to form error msg)";
                String msg$iv3 = (String)(Result.isFailure-impl((Object)$i$a$-infoLazy$default-OIDCAuthenticator$authenticate$1$22) ? string2 : $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$1$22);
                $this$infoLazy_u24default$iv.info((Object)msg$iv3);
            }
            return bl2;
        }
        JsonObject oidcUserInfo = this.fetchOIDCUserInfo(password);
        MXLogger $this$debugLazy_u24default$iv = logger2;
        Object e$iv = null;
        boolean $i$f$debugLazy = false;
        if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
            Object $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$32;
            try {
                boolean $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$32 = false;
                $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$32 = Result.constructor-impl((Object)("OIDC user info has been obtained as: " + oidcUserInfo));
            }
            catch (Throwable $i$f$infoLazy) {
                $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$32 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$f$infoLazy));
            }
            String $i$f$infoLazy = "(Unable to form error msg)";
            String msg$iv4 = (String)(Result.isFailure-impl((Object)$i$a$-debugLazy$default-OIDCAuthenticator$authenticate$32) ? $i$f$infoLazy : $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$32);
            $this$debugLazy_u24default$iv.debug((Object)msg$iv4);
        }
        ErrorContent errorContent = this.errorCheck(oidcUserInfo);
        boolean bl4 = false;
        if (errorContent.getErrorExist()) {
            boolean $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$32;
            boolean it = $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$32 = false;
            boolean bl5 = false;
            MXLogger $this$infoLazy_u24default$iv = logger2;
            Object e$iv2 = null;
            boolean $i$f$infoLazy = false;
            if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                Object $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$3$1$22;
                try {
                    boolean $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$3$1$22 = false;
                    $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$3$1$22 = Result.constructor-impl((Object)("User info validation failed due to: " + errorContent.getErrorMessage()));
                }
                catch (Throwable throwable) {
                    $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$3$1$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string3 = "(Unable to form error msg)";
                String msg$iv5 = (String)(Result.isFailure-impl((Object)$i$a$-infoLazy$default-OIDCAuthenticator$authenticate$3$1$22) ? string3 : $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$3$1$22);
                $this$infoLazy_u24default$iv.info((Object)msg$iv5);
            }
            return $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$32;
        }
        Object object2 = PropUtil.INSTANCE.getProp(OIDC_USER_INFO_COMPARING_CLAIM);
        if (object2 == null || (object2 = ((InformerProp)object2).asString()) == null) {
            object2 = "sub";
        }
        Object uiComparingClaim = object2;
        String it = bl4 = this.getClaimValue(oidcUserInfo, (String)uiComparingClaim);
        boolean bl6 = false;
        CharSequence bl5 = it;
        if (bl5 == null || StringsKt.isBlank((CharSequence)bl5)) {
            boolean it2 = bl5 = false;
            boolean bl7 = false;
            MXLogger $this$infoLazy_u24default$iv = logger2;
            Object e$iv3 = null;
            boolean $i$f$infoLazy = false;
            if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                Object $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$uiComparingClaimValue$1$1$22;
                try {
                    boolean $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$uiComparingClaimValue$1$1$22 = false;
                    $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$uiComparingClaimValue$1$1$22 = Result.constructor-impl((Object)((String)uiComparingClaim + " does not exist in OIDC user info or does not have a value."));
                }
                catch (Throwable throwable) {
                    $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$uiComparingClaimValue$1$1$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string4 = "(Unable to form error msg)";
                String msg$iv6 = (String)(Result.isFailure-impl((Object)$i$a$-infoLazy$default-OIDCAuthenticator$authenticate$uiComparingClaimValue$1$1$22) ? string4 : $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$uiComparingClaimValue$1$1$22);
                $this$infoLazy_u24default$iv.info((Object)msg$iv6);
            }
            return bl5;
        }
        String uiComparingClaimValue = bl4;
        JsonObject accessTokenPayload = this.getJWTPayload(password);
        MXLogger $this$debugLazy_u24default$iv2 = logger2;
        Object e$iv4 = null;
        boolean $i$f$debugLazy2 = false;
        if ($this$debugLazy_u24default$iv2.isDebugEnabled()) {
            Object $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$52;
            try {
                boolean $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$52 = false;
                $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$52 = Result.constructor-impl((Object)("OIDC access token parsed as: " + accessTokenPayload));
            }
            catch (Throwable bl7) {
                $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$52 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl7));
            }
            String bl7 = "(Unable to form error msg)";
            msg$iv2 = (String)(Result.isFailure-impl((Object)$i$a$-debugLazy$default-OIDCAuthenticator$authenticate$52) ? bl7 : $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$52);
            $this$debugLazy_u24default$iv2.debug((Object)msg$iv2);
        }
        if ((object = PropUtil.INSTANCE.getProp(OIDC_ACCESS_TOKEN_COMPARING_CLAIM)) == null || (object = ((InformerProp)object).asString()) == null) {
            object = "xms_st.sub";
        }
        Object atComparingClaim = object;
        String it3 = $i$f$debugLazy2 = this.getClaimValue(accessTokenPayload, (String)atComparingClaim);
        boolean bl82 = false;
        msg$iv2 = it3;
        if (msg$iv2 == null || StringsKt.isBlank((CharSequence)msg$iv2)) {
            boolean it4 = msg$iv2 = false;
            boolean bl9 = false;
            MXLogger $this$infoLazy_u24default$iv = logger2;
            Object e$iv5 = null;
            boolean $i$f$infoLazy = false;
            if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                Object $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$atComparingClaimValue$1$1$22;
                try {
                    boolean $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$atComparingClaimValue$1$1$22 = false;
                    $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$atComparingClaimValue$1$1$22 = Result.constructor-impl((Object)((String)atComparingClaim + " does not exist in OIDC given access token or does not have a value."));
                }
                catch (Throwable throwable) {
                    $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$atComparingClaimValue$1$1$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string5 = "(Unable to form error msg)";
                String msg$iv7 = (String)(Result.isFailure-impl((Object)$i$a$-infoLazy$default-OIDCAuthenticator$authenticate$atComparingClaimValue$1$1$22) ? string5 : $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$atComparingClaimValue$1$1$22);
                $this$infoLazy_u24default$iv.info((Object)msg$iv7);
            }
            return msg$iv2;
        }
        String atComparingClaimValue = $i$f$debugLazy2;
        Object object3 = PropUtil.INSTANCE.getProp(OIDC_UNIQUE_IDENTIFIER);
        if (object3 != null && (object3 = ((InformerProp)object3).asString()) != null) {
            Object uniqueClaim = object3;
            boolean bl10 = false;
            if (WhenMappings.$EnumSwitchMapping$0[this.getTokenType().ordinal()] == 1) {
                String $this$infoLazy_u24default$iv;
                String it5 = $this$infoLazy_u24default$iv = this.getClaimValue(accessTokenPayload, (String)uniqueClaim);
                boolean bl11 = false;
                CharSequence $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$atComparingClaimValue$1$1$22 = it5;
                if ($i$a$-infoLazy$default-OIDCAuthenticator$authenticate$atComparingClaimValue$1$1$22 == null || StringsKt.isBlank((CharSequence)$i$a$-infoLazy$default-OIDCAuthenticator$authenticate$atComparingClaimValue$1$1$22)) {
                    boolean it6 = $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$atComparingClaimValue$1$1$22 = false;
                    boolean bl12 = false;
                    MXLogger $this$infoLazy_u24default$iv2 = logger2;
                    Object e$iv6 = null;
                    boolean $i$f$infoLazy = false;
                    if ($this$infoLazy_u24default$iv2.isInfoEnabled()) {
                        Object $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$1$1$22;
                        try {
                            boolean $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$1$1$22 = false;
                            $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$1$1$22 = Result.constructor-impl((Object)((String)uniqueClaim + " does not exist in OIDC given access token or does not have a value."));
                        }
                        catch (Throwable throwable) {
                            $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$1$1$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        String string6 = "(Unable to form error msg)";
                        String msg$iv8 = (String)(Result.isFailure-impl((Object)$i$a$-infoLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$1$1$22) ? string6 : $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$1$1$22);
                        $this$infoLazy_u24default$iv2.info((Object)msg$iv8);
                    }
                    return $i$a$-infoLazy$default-OIDCAuthenticator$authenticate$atComparingClaimValue$1$1$22;
                }
                string = $this$infoLazy_u24default$iv;
            } else {
                String string7 = extras.getExtra();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"extras.extra");
                JsonObject idTokenPayload = this.getJWTPayload(string7);
                Object $this$debugLazy_u24default$iv3 = logger2;
                Object e$iv7 = null;
                boolean $i$f$debugLazy3 = false;
                if ($this$debugLazy_u24default$iv3.isDebugEnabled()) {
                    try {
                        boolean $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32 = false;
                        $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32 = Result.constructor-impl((Object)("OIDC ID token parsed as: " + idTokenPayload));
                    }
                    catch (Throwable bl12) {
                        $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl12));
                    }
                    String bl12 = "(Unable to form error msg)";
                    String msg$iv9 = (String)(Result.isFailure-impl((Object)$i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32) ? bl12 : $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32);
                    $this$debugLazy_u24default$iv3.debug((Object)msg$iv9);
                }
                Object it7 = $this$debugLazy_u24default$iv3 = this.getClaimValue(idTokenPayload, (String)uniqueClaim);
                boolean bl13 = false;
                $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32 = (CharSequence)it7;
                if ($i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32 == null || StringsKt.isBlank((CharSequence)$i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32)) {
                    boolean it8 = $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32 = false;
                    boolean bl14 = false;
                    MXLogger $this$infoLazy_u24default$iv = logger2;
                    Object e$iv8 = null;
                    boolean $i$f$infoLazy = false;
                    if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                        Object object4;
                        try {
                            boolean bl15 = false;
                            object4 = Result.constructor-impl((Object)((String)uniqueClaim + " does not exist in OIDC given ID token or does not have a value."));
                        }
                        catch (Throwable throwable) {
                            object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        String string8 = "(Unable to form error msg)";
                        String msg$iv10 = (String)(Result.isFailure-impl((Object)object4) ? string8 : object4);
                        $this$infoLazy_u24default$iv.info((Object)msg$iv10);
                    }
                    return $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32;
                }
                string = $this$debugLazy_u24default$iv3;
            }
        } else {
            string = uniqueClaimValue = null;
        }
        if (Intrinsics.areEqual((Object)uiComparingClaimValue, (Object)atComparingClaimValue)) {
            Object object5 = PropUtil.INSTANCE.getProp("informer.ignoreLoginCase");
            boolean ignoreCase = object5 != null && (object5 = ((InformerProp)object5).asBoolean()) != null ? (Boolean)object5 : false;
            CharSequence bl82 = uniqueClaimValue;
            if (bl82 == null || StringsKt.isBlank((CharSequence)bl82)) {
                bl = true;
            } else if (StringsKt.equals(uniqueClaimValue, (String)userInfo.getLoginID(), (boolean)ignoreCase)) {
                bl = true;
            } else {
                boolean it9 = bl82 = false;
                boolean bl16 = false;
                MXLogger $this$infoLazy_u24default$iv = logger2;
                Object e$iv9 = null;
                boolean $i$f$infoLazy = false;
                if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                    Object bl13;
                    try {
                        boolean bl17 = false;
                        bl13 = Result.constructor-impl((Object)"OIDC given token user unique identifier value is not match with provided loginId.");
                    }
                    catch (Throwable $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32) {
                        bl13 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32));
                    }
                    $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32 = "(Unable to form error msg)";
                    String msg$iv11 = (String)(Result.isFailure-impl((Object)bl13) ? $i$a$-debugLazy$default-OIDCAuthenticator$authenticate$uniqueClaimValue$1$32 : bl13);
                    $this$infoLazy_u24default$iv.info((Object)msg$iv11);
                }
                MXLogger $this$debugLazy_u24default$iv4 = logger2;
                e$iv9 = null;
                boolean $i$f$debugLazy4 = false;
                if ($this$debugLazy_u24default$iv4.isDebugEnabled()) {
                    Object bl13;
                    try {
                        boolean bl18 = false;
                        bl13 = Result.constructor-impl((Object)StringsKt.trimIndent((String)("\n                            Given token unique identifier value is: `" + uniqueClaimValue + "`,\n                            LoginId is: `" + userInfo.getLoginID() + "`\n                        ")));
                    }
                    catch (Throwable throwable) {
                        bl13 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    String string9 = "(Unable to form error msg)";
                    msg$iv = (String)(Result.isFailure-impl((Object)bl13) ? string9 : bl13);
                    $this$debugLazy_u24default$iv4.debug((Object)msg$iv);
                }
                bl = bl82;
            }
        } else {
            boolean bl19;
            boolean it10 = bl19 = false;
            boolean bl20 = false;
            MXLogger $this$infoLazy_u24default$iv = logger2;
            Object e$iv10 = null;
            boolean $i$f$infoLazy = false;
            if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                Object object6;
                try {
                    boolean bl21 = false;
                    object6 = Result.constructor-impl((Object)("Azure user info `" + (String)uiComparingClaim + "` value is not match with provided access token `" + (String)atComparingClaim + "` value."));
                }
                catch (Throwable bl21) {
                    object6 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl21));
                }
                String bl21 = "(Unable to form error msg)";
                String msg$iv12 = (String)(Result.isFailure-impl((Object)object6) ? bl21 : object6);
                $this$infoLazy_u24default$iv.info((Object)msg$iv12);
            }
            MXLogger $this$debugLazy_u24default$iv5 = logger2;
            e$iv10 = null;
            boolean $i$f$debugLazy5 = false;
            if ($this$debugLazy_u24default$iv5.isDebugEnabled()) {
                Object object7;
                try {
                    boolean bl22 = false;
                    object7 = Result.constructor-impl((Object)StringsKt.trimIndent((String)("\n                        User info `" + (String)uiComparingClaim + "` value is: `" + uiComparingClaimValue + "`, \n                        Access token `" + (String)atComparingClaim + "` value is: `" + atComparingClaimValue + "`\n                    ")));
                }
                catch (Throwable throwable) {
                    object7 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string10 = "(Unable to form error msg)";
                msg$iv = (String)(Result.isFailure-impl((Object)object7) ? string10 : object7);
                $this$debugLazy_u24default$iv5.debug((Object)msg$iv);
            }
            bl = bl19;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JsonObject fetchOIDCUserInfo(String bearerToken) {
        Request request = new Request.Builder().url(this.getUserinfoUrl()).header("Authorization", "Bearer " + bearerToken).build();
        Closeable closeable = (Closeable)OIDCAuthenticator.Companion.getHttpClient().newCall(request).execute();
        Throwable throwable = null;
        try {
            String string;
            Response response = (Response)closeable;
            boolean bl = false;
            ResponseBody responseBody = response.body();
            String string2 = string = responseBody != null ? responseBody.string() : null;
            if (string == null) {
                throw new IllegalStateException("No user info could was retrieved".toString());
            }
            String responseBody2 = string;
            StringFormat $this$decodeFromString$iv = (StringFormat)json;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JsonObject.class));
            boolean $i$f$cast = false;
            JsonObject jsonObject = (JsonObject)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, responseBody2);
            return jsonObject;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final HttpUrl getUserinfoUrl() {
        Object object;
        block5: {
            Object object2;
            block7: {
                block6: {
                    block4: {
                        object = PropUtil.INSTANCE.getProp(OIDC_USER_INFO_ENDPOINT_URL);
                        if (object == null || (object = ((InformerProp)object).asString()) == null) break block4;
                        Object url = object;
                        boolean bl = false;
                        HttpUrl httpUrl = HttpUrl.parse((String)url);
                        object = httpUrl;
                        if (httpUrl != null) break block5;
                    }
                    OIDCAuthenticator $this$getUserinfoUrl_u24lambda_u2432 = this;
                    boolean bl = false;
                    JsonObject config = $this$getUserinfoUrl_u24lambda_u2432.fetchOpenIdConfiguration();
                    boolean bl2 = false;
                    ErrorContent it = $this$getUserinfoUrl_u24lambda_u2432.errorCheck(config);
                    boolean bl3 = false;
                    if (it.getErrorExist()) {
                        throw new IllegalStateException(it.getErrorMessage().toString());
                    }
                    object2 = (JsonElement)config.get((Object)"userinfo_endpoint");
                    if (object2 == null || (object2 = JsonElementKt.getJsonPrimitive((JsonElement)object2)) == null || (object2 = object2.getContent()) == null) break block6;
                    Object url = object2;
                    boolean bl4 = false;
                    HttpUrl httpUrl = HttpUrl.parse((String)url);
                    object2 = httpUrl;
                    if (httpUrl != null) break block7;
                }
                throw new IllegalStateException("No Userinfo URL found".toString());
            }
            object = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"config[\"userinfo_endpoin\u2026(\"No Userinfo URL found\")");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JsonObject fetchOpenIdConfiguration() {
        Object object = PropUtil.INSTANCE.getProp(OIDC_CONFIGURATION_ENDPOINT_URL);
        if (object == null || (object = ((InformerProp)object).asString()) == null) {
            object = "https://login.microsoftonline.com/common/v2.0";
        }
        Object baseConfigUrl = object;
        String url = StringsKt.removeSuffix((String)baseConfigUrl, (CharSequence)"/") + "/.well-known/openid-configuration";
        boolean bl = false;
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            throw new IllegalStateException("OIDC configuration endpoint is not valid.".toString());
        }
        HttpUrl configUrl = httpUrl;
        Request request = new Request.Builder().url(configUrl).build();
        Closeable closeable = (Closeable)OIDCAuthenticator.Companion.getHttpClient().newCall(request).execute();
        Throwable throwable = null;
        try {
            String string;
            Response response = (Response)closeable;
            boolean bl2 = false;
            ResponseBody responseBody = response.body();
            String string2 = string = responseBody != null ? responseBody.string() : null;
            if (string2 == null) {
                throw new IllegalStateException("No open id config could was retrieved".toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.body()?.string(\u2026fig could was retrieved\")");
            String responseBody2 = string;
            StringFormat $this$decodeFromString$iv = (StringFormat)json;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JsonObject.class));
            boolean $i$f$cast = false;
            JsonObject jsonObject = (JsonObject)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, responseBody2);
            return jsonObject;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final ErrorContent errorCheck(JsonObject $this$errorCheck) {
        if (((Map)$this$errorCheck).containsKey("error")) {
            JsonElement jsonElement;
            JsonElement jsonElement2 = (JsonElement)$this$errorCheck.get((Object)"error");
            if (jsonElement2 == null || (jsonElement2 = JsonElementKt.getJsonObject((JsonElement)jsonElement2)) == null) {
                return new ErrorContent(true, $this$errorCheck.toString());
            }
            JsonElement error = jsonElement2;
            JsonElement jsonElement3 = (JsonElement)error.get((Object)"code");
            return new ErrorContent(true, (jsonElement3 != null && (jsonElement3 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement3)) != null ? jsonElement3.getContent() : null) + ':' + ((jsonElement = (JsonElement)error.get((Object)"message")) != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null));
        }
        if (((Map)$this$errorCheck).containsKey("errorCode")) {
            JsonElement jsonElement;
            JsonElement jsonElement4 = (JsonElement)$this$errorCheck.get((Object)"errorCode");
            return new ErrorContent(true, (jsonElement4 != null && (jsonElement4 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement4)) != null ? jsonElement4.getContent() : null) + ':' + ((jsonElement = (JsonElement)$this$errorCheck.get((Object)"errorSummary")) != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null));
        }
        return new ErrorContent(false, "");
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject getJWTPayload(String token) {
        void $this$decodeFromString$iv;
        String[] stringArray = new String[]{"."};
        String based64Body = (String)StringsKt.split$default((CharSequence)token, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
        boolean bl = false;
        byte[] it = Base64.decodeBase64(based64Body);
        boolean bl2 = false;
        StringFormat stringFormat = (StringFormat)json;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        String string$iv = StringsKt.decodeToString((byte[])it);
        boolean $i$f$decodeFromString = false;
        SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JsonObject.class));
        boolean $i$f$cast = false;
        return (JsonObject)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv);
    }

    private final String getClaimValue(JsonObject jwtPayload, String key) {
        String string;
        String[] stringArray = new String[]{"."};
        List keys = StringsKt.split$default((CharSequence)key, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (keys.size() > 1) {
            JsonObject jsonObject;
            JsonObject jsonObject2 = jwtPayload;
            if (jsonObject2 != null) {
                JsonObject b = jsonObject2;
                boolean bl = false;
                JsonElement jsonElement = (JsonElement)b.get(keys.get(0));
                if (jsonElement != null) {
                    JsonElement value = jsonElement;
                    boolean bl2 = false;
                    if (value instanceof JsonObject) {
                        jsonObject = JsonElementKt.getJsonObject((JsonElement)value);
                    } else {
                        Object var10_15;
                        Object it = var10_15 = null;
                        boolean bl3 = false;
                        MXLogger mXLogger = this.logger;
                        if (mXLogger == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                            mXLogger = null;
                        }
                        MXLogger $this$debugLazy_u24default$iv = mXLogger;
                        Object e$iv = null;
                        boolean $i$f$debugLazy = false;
                        if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
                            Object object;
                            try {
                                boolean bl4 = false;
                                object = Result.constructor-impl((Object)("Expecting a JsonObject but got " + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName()));
                            }
                            catch (Throwable throwable) {
                                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            }
                            String string2 = "(Unable to form error msg)";
                            String msg$iv = (String)(Result.isFailure-impl((Object)object) ? string2 : object);
                            $this$debugLazy_u24default$iv.debug((Object)msg$iv);
                        }
                        jsonObject = var10_15;
                    }
                } else {
                    jsonObject = null;
                }
            } else {
                jsonObject = null;
            }
            JsonObject childPayload = jsonObject;
            List it = CollectionsKt.toMutableList((Collection)keys);
            boolean bl = false;
            it.remove(keys.get(0));
            String childKey = CollectionsKt.joinToString$default((Iterable)it, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            return this.getClaimValue(childPayload, childKey);
        }
        JsonObject jsonObject = jwtPayload;
        if (jsonObject != null) {
            JsonObject it = jsonObject;
            boolean bl = false;
            JsonElement jsonElement = (JsonElement)it.get((Object)key);
            if (jsonElement != null) {
                JsonElement value = jsonElement;
                boolean bl5 = false;
                if (value instanceof JsonPrimitive) {
                    string = JsonElementKt.getJsonPrimitive((JsonElement)value).getContent();
                } else {
                    Object var9_14;
                    Object it2 = var9_14 = null;
                    boolean bl6 = false;
                    MXLogger mXLogger = this.logger;
                    if (mXLogger == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        mXLogger = null;
                    }
                    MXLogger $this$debugLazy_u24default$iv = mXLogger;
                    Object e$iv = null;
                    boolean $i$f$debugLazy = false;
                    if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
                        Object object;
                        try {
                            boolean bl7 = false;
                            object = Result.constructor-impl((Object)("Expecting a primitive value but got " + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName() + '.'));
                        }
                        catch (Throwable throwable) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        String string3 = "(Unable to form error msg)";
                        String msg$iv = (String)(Result.isFailure-impl((Object)object) ? string3 : object);
                        $this$debugLazy_u24default$iv.debug((Object)msg$iv);
                    }
                    string = var9_14;
                }
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    private final Companion.TokenType getTokenType() {
        Object object = PropUtil.INSTANCE.getProp(OIDC_TOKEN_TYPE);
        if (object == null || (object = ((InformerProp)object).asString()) == null) {
            object = "access";
        }
        Object type = object;
        return StringsKt.equals((String)type, (String)"id", (boolean)true) ? Companion.TokenType.ID_TOKEN : Companion.TokenType.ACCESS_TOKEN;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/interlocsolutions/maximo/notify/security/OIDCAuthenticator$ErrorContent;", "", "errorExist", "", "errorMessage", "", "(ZLjava/lang/String;)V", "getErrorExist", "()Z", "getErrorMessage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "isinformer"})
    private static final class ErrorContent {
        private final boolean errorExist;
        @NotNull
        private final String errorMessage;

        public ErrorContent(boolean errorExist, @NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            this.errorExist = errorExist;
            this.errorMessage = errorMessage;
        }

        public final boolean getErrorExist() {
            return this.errorExist;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final boolean component1() {
            return this.errorExist;
        }

        @NotNull
        public final String component2() {
            return this.errorMessage;
        }

        @NotNull
        public final ErrorContent copy(boolean errorExist, @NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            return new ErrorContent(errorExist, errorMessage);
        }

        public static /* synthetic */ ErrorContent copy$default(ErrorContent errorContent, boolean bl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                bl = errorContent.errorExist;
            }
            if ((n & 2) != 0) {
                string = errorContent.errorMessage;
            }
            return errorContent.copy(bl, string);
        }

        @NotNull
        public String toString() {
            return "ErrorContent(errorExist=" + this.errorExist + ", errorMessage=" + this.errorMessage + ')';
        }

        public int hashCode() {
            int n = this.errorExist ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result = n;
            result = result * 31 + this.errorMessage.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ErrorContent)) {
                return false;
            }
            ErrorContent errorContent = (ErrorContent)other;
            if (this.errorExist != errorContent.errorExist) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.errorMessage, (Object)errorContent.errorMessage);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/interlocsolutions/maximo/notify/security/OIDCAuthenticator$Companion;", "", "()V", "OIDC_ACCESS_TOKEN_COMPARING_CLAIM", "", "OIDC_CONFIGURATION_ENDPOINT_URL", "OIDC_TOKEN_TYPE", "OIDC_UNIQUE_IDENTIFIER", "OIDC_USER_INFO_COMPARING_CLAIM", "OIDC_USER_INFO_ENDPOINT_URL", "httpClient", "Lokhttp3/OkHttpClient;", "kotlin.jvm.PlatformType", "getHttpClient", "()Lokhttp3/OkHttpClient;", "httpClient$delegate", "Lkotlin/Lazy;", "json", "Lkotlinx/serialization/json/Json;", "TokenType", "isinformer"})
    public static final class Companion {
        private Companion() {
        }

        private final OkHttpClient getHttpClient() {
            Lazy lazy = httpClient$delegate;
            return (OkHttpClient)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/interlocsolutions/maximo/notify/security/OIDCAuthenticator$Companion$TokenType;", "", "(Ljava/lang/String;I)V", "ACCESS_TOKEN", "ID_TOKEN", "isinformer"})
        private static final class TokenType
        extends Enum<TokenType> {
            public static final /* enum */ TokenType ACCESS_TOKEN = new TokenType();
            public static final /* enum */ TokenType ID_TOKEN = new TokenType();
            private static final /* synthetic */ TokenType[] $VALUES;

            public static TokenType[] values() {
                return (TokenType[])$VALUES.clone();
            }

            public static TokenType valueOf(String value) {
                return Enum.valueOf(TokenType.class, value);
            }

            static {
                $VALUES = tokenTypeArray = new TokenType[]{TokenType.ACCESS_TOKEN, TokenType.ID_TOKEN};
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Companion.TokenType.values().length];
            try {
                nArray[Companion.TokenType.ACCESS_TOKEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

