/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.security;

import com.interlocsolutions.maximo.notify.security.Authenticator2;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.app.signature.SignatureService;
import psdi.security.SecurityService;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXAccessException;
import psdi.util.logging.MXLogger;

public class MaximoAuthenticator
implements Authenticator2 {
    public static final String PROP_REJECT_EXPIRED_PW = "informer.authenticator.default.rejectexpiredpw";

    @Override
    public boolean authenticate(@NotNull UserInfo userInfo, @Nullable String password, @NotNull MXLogger logger2) throws Exception {
        try {
            boolean rejectOnExpiredPass;
            SignatureService sigServ = (SignatureService)MXServer.getMXServer().lookupLocal("SIGNATURE");
            InformerProp prep = PropUtil.INSTANCE.getProp(PROP_REJECT_EXPIRED_PW);
            boolean bl = rejectOnExpiredPass = prep == null || prep.asBoolean(true);
            if (rejectOnExpiredPass && sigServ.hasPasswordExpired(userInfo.getLoginID(), MXServer.getMXServer().getSystemUserInfo())) {
                if (logger2.isInfoEnabled()) {
                    logger2.info((Object)("Authentication of user " + userInfo.getLoginUserName() + " (" + userInfo.getDisplayName() + ") is being rejected by " + this.getClass().getSimpleName() + " because  the user has an expired password"));
                }
                return false;
            }
            if (sigServ.isBlocked(userInfo.getUserName(), userInfo)) {
                if (logger2.isInfoEnabled()) {
                    logger2.info((Object)("Authentication of user " + userInfo.getLoginUserName() + " (" + userInfo.getDisplayName() + ") is being rejected by " + this.getClass().getSimpleName() + " because  the user is \"blocked\" in Maximo"));
                }
                return false;
            }
            SecurityService secServ = (SecurityService)MXServer.getMXServer().lookupLocal("SECURITY");
            if (!secServ.isUser(userInfo, userInfo.getLoginID(), password)) {
                if (logger2.isInfoEnabled()) {
                    logger2.info((Object)("Authentication of user " + userInfo.getLoginUserName() + " (" + userInfo.getDisplayName() + ") is being rejected by " + this.getClass().getSimpleName() + " because  the user/password combo was rejected by Maximo's security service"));
                }
                return false;
            }
            return true;
        }
        catch (MXAccessException e) {
            if (logger2.isInfoEnabled()) {
                logger2.info((Object)("Authentication of user " + userInfo.getLoginUserName() + " (" + userInfo.getDisplayName() + ") is being rejected by " + this.getClass().getSimpleName() + " because  of an exception from Maximo's security service"), (Throwable)e);
            }
            return false;
        }
    }
}

