/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.security;

import com.interlocsolutions.maximo.notify.security.Authenticator;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import psdi.server.MXServer;
import psdi.server.MaxPropCache;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class LDAPAuthenticator
implements Authenticator {
    String msg;
    private static final MXLogger logger = NotifyConstants.INFORMER_LOGGER;
    public static final String LDAP_SERVERS = "informer.security.ldap.servers";
    public static final String LDAP_URL_PROPERTY = "informer.security.ldap.url";
    public static final String LDAP_SEARCH_BASE_PROPERTY = "informer.security.ldap.searchbase";
    public static final String LDAP_LOOKUP_USER_PROPERTY = "informer.security.ldap.lookup.user";
    public static final String LDAP_LOOKUP_PASSWORD_PROPERTY = "informer.security.ldap.lookup.password";
    public static final String LDAP_LOOKUP_SEARCH_PATH_PROPERTY = "informer.security.ldap.search.path";
    public static final String LDAP_LOOKUP_SEARCH_PATTERN_PROPERTY = "informer.security.ldap.search.pattern";
    public static final String LDAP_USER_PATTERN_PROPERTY = "informer.security.ldap.user.pattern";
    public static final String LDAP_CONTEXT_FACTORY_PROPERTY = "informer.security.ldap.context.factory";
    public static final String LDAP_AUTHENTICATION_PROPERTY = "informer.security.ldap.authtype";
    public static final String LDAP_LOOKUP_SCOPE_PROPERTY = "informer.security.ldap.scope";

    @Override
    public boolean authenticate(String userName, String password) throws NotifyFault {
        boolean rc2 = false;
        try {
            String identifier;
            LdapProperties ldapProperties;
            MXServer server = MXServer.getMXServer();
            MaxPropCache maximoProperties = (MaxPropCache)server.getFromMaximoCache("MAXPROP");
            for (int x = 1; x <= this.determineServers(maximoProperties) && !(rc2 = this.authenticate(ldapProperties = new LdapProperties(maximoProperties, identifier = x == 1 ? ".ldap." : ".ldap" + x + "."), server.getAppServerNameandVersion(), userName, password)); ++x) {
            }
        }
        catch (RemoteException e) {
            logger.error((Object)e);
            throw new NotifyFault(e);
        }
        return rc2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean authenticate(LdapProperties properties, String serverName, String userName, String password) {
        this.msg = "";
        Context ctx = null;
        String serverURL = properties.getUrl().getValue();
        String searchBase = properties.getSearchBase().getValue();
        if (searchBase == null || searchBase.trim().length() <= 0) {
            searchBase = "";
        } else if (!searchBase.startsWith("/")) {
            searchBase = "/" + searchBase;
        }
        String providerURL = serverURL + searchBase;
        try {
            String searchPattern;
            String authType;
            if (serverURL == null || serverURL.trim().length() <= 0) {
                Object[] args = new String[]{properties.getUrl().getProperty()};
                throw new NotifyFault((MXException)new MXApplicationException("informer", "missingProperty", args));
            }
            String contextFactory = properties.getContextFactory().getValue();
            if (contextFactory == null || contextFactory.length() <= 0) {
                contextFactory = serverName.toLowerCase().contains("ibm") ? "com.ibm.websphere.naming.WsnInitialContextFactory" : "com.sun.jndi.ldap.LdapCtxFactory";
            }
            if ((authType = properties.getAuthenticationType().getValue()) == null || authType.trim().length() <= 0) {
                authType = "simple";
            }
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", contextFactory);
            env.put("java.naming.provider.url", providerURL);
            env.put("java.naming.security.authentication", authType);
            String userPattern = properties.getUserPattern().getValue();
            if (userPattern != null && userPattern.trim().length() > 0) {
                Object[] args = new Object[]{userName};
                String userDN = MessageFormat.format(userPattern, args);
                env.put("java.naming.security.principal", userDN);
                env.put("java.naming.security.credentials", password);
                ctx = new InitialDirContext(env);
                boolean bl = true;
                return bl;
            }
            String lookupUser = properties.getLookupUser().getValue();
            String lookupPassword = properties.getLookupPassword().getValue();
            if (lookupUser == null || lookupUser.trim().length() <= 0) {
                Object[] args = new String[]{properties.getLookupUser().getProperty()};
                throw new NotifyFault((MXException)new MXApplicationException("informer", "missingProperty", args));
            }
            if (lookupPassword == null || lookupPassword.trim().length() <= 0) {
                Object[] args = new String[]{properties.getLookupPassword().getProperty()};
                throw new NotifyFault((MXException)new MXApplicationException("informer", "missingProperty", args));
            }
            env.put("java.naming.security.principal", lookupUser);
            env.put("java.naming.security.credentials", lookupPassword);
            ctx = new InitialDirContext(env);
            SearchControls sc = new SearchControls();
            int scope = 2;
            String scopeName = properties.getLookupScope().getValue();
            if (scopeName != null && scopeName.trim().length() > 0) {
                if (scopeName.equalsIgnoreCase("OBJECT")) {
                    scope = 0;
                } else if (scopeName.equalsIgnoreCase("ONELEVEL")) {
                    scope = 1;
                }
            }
            sc.setSearchScope(scope);
            sc.setCountLimit(1L);
            String searchPath = properties.getLookupSearchPath().getValue();
            if (searchPath == null || searchPath.trim().length() <= 0) {
                searchPath = "";
            }
            if ((searchPattern = properties.getLookupSearchPattern().getValue()) == null || searchPattern.trim().length() <= 0) {
                Object[] args = new String[]{properties.getLookupSearchPattern().getProperty()};
                throw new NotifyFault((MXException)new MXApplicationException("informer", "missingProperty", args));
            }
            NamingEnumeration<SearchResult> res = ctx.search(searchPath, searchPattern, new Object[]{userName}, sc);
            if (res.hasMoreElements()) {
                SearchResult searchRes = res.next();
                env.put("java.naming.security.principal", searchRes.getNameInNamespace());
                env.put("java.naming.security.credentials", password == null || password.trim().trim().length() <= 0 ? "incorrect_password" : password);
                InitialDirContext bindCtx = null;
                try {
                    bindCtx = new InitialDirContext(env);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (bindCtx != null) {
                        try {
                            bindCtx.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (!logger.isInfoEnabled()) return false;
        }
        catch (NamingException e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("User: %s; Message: %s; Server: %s", userName, e.getMessage(), providerURL));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e);
            }
            boolean bl = false;
            return bl;
        }
        logger.info((Object)("Unable to find user " + userName + " on " + providerURL));
        return false;
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    private int determineServers(MaxPropCache maximoProperties) {
        int servers;
        String ldapServers = maximoProperties.getProperty(LDAP_SERVERS, false);
        if (ldapServers == null) {
            servers = 1;
        } else {
            try {
                servers = Integer.parseInt(ldapServers);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("Invalid value " + ldapServers + " for " + LDAP_SERVERS + ".  Defaulting value to 1."));
                servers = 1;
            }
        }
        if (servers < 1) {
            logger.warn((Object)"Values below 1 for informer.security.ldap.servers are invalid.  Resetting value to 1.");
            servers = 1;
        }
        return servers;
    }

    @Override
    public String getErrorMessage() {
        return this.msg;
    }

    private static class LdapProperties {
        private final PropertyValuePair url;
        private final PropertyValuePair searchBase;
        private final PropertyValuePair lookupUser;
        private final PropertyValuePair lookupPassword;
        private final PropertyValuePair lookupSearchPath;
        private final PropertyValuePair lookupSearchPattern;
        private final PropertyValuePair userPattern;
        private final PropertyValuePair contextFactory;
        private final PropertyValuePair authenticationType;
        private final PropertyValuePair lookupScope;

        public LdapProperties(MaxPropCache properties, String identifier) {
            this.url = new PropertyValuePair(properties, this.generateProperty(LDAPAuthenticator.LDAP_URL_PROPERTY, identifier));
            this.searchBase = new PropertyValuePair(properties, this.generateProperty(LDAPAuthenticator.LDAP_SEARCH_BASE_PROPERTY, identifier));
            this.lookupUser = new PropertyValuePair(properties, this.generateProperty(LDAPAuthenticator.LDAP_LOOKUP_USER_PROPERTY, identifier));
            this.lookupPassword = new PropertyValuePair(properties, this.generateProperty(LDAPAuthenticator.LDAP_LOOKUP_PASSWORD_PROPERTY, identifier));
            this.lookupSearchPath = new PropertyValuePair(properties, this.generateProperty(LDAPAuthenticator.LDAP_LOOKUP_SEARCH_PATH_PROPERTY, identifier));
            this.lookupSearchPattern = new PropertyValuePair(properties, this.generateProperty(LDAPAuthenticator.LDAP_LOOKUP_SEARCH_PATTERN_PROPERTY, identifier));
            this.userPattern = new PropertyValuePair(properties, this.generateProperty(LDAPAuthenticator.LDAP_USER_PATTERN_PROPERTY, identifier));
            this.contextFactory = new PropertyValuePair(properties, this.generateProperty(LDAPAuthenticator.LDAP_CONTEXT_FACTORY_PROPERTY, identifier));
            this.authenticationType = new PropertyValuePair(properties, this.generateProperty(LDAPAuthenticator.LDAP_AUTHENTICATION_PROPERTY, identifier));
            this.lookupScope = new PropertyValuePair(properties, this.generateProperty(LDAPAuthenticator.LDAP_LOOKUP_SCOPE_PROPERTY, identifier));
        }

        public PropertyValuePair getUrl() {
            return this.url;
        }

        public PropertyValuePair getSearchBase() {
            return this.searchBase;
        }

        public PropertyValuePair getLookupUser() {
            return this.lookupUser;
        }

        public PropertyValuePair getLookupPassword() {
            return this.lookupPassword;
        }

        public PropertyValuePair getLookupSearchPath() {
            return this.lookupSearchPath;
        }

        public PropertyValuePair getLookupSearchPattern() {
            return this.lookupSearchPattern;
        }

        public PropertyValuePair getUserPattern() {
            return this.userPattern;
        }

        public PropertyValuePair getContextFactory() {
            return this.contextFactory;
        }

        public PropertyValuePair getAuthenticationType() {
            return this.authenticationType;
        }

        public PropertyValuePair getLookupScope() {
            return this.lookupScope;
        }

        private String generateProperty(String property, String identifier) {
            String rc2 = identifier.contentEquals(".ldap.") ? property : property.replace(".ldap.", identifier);
            return rc2;
        }
    }

    private static class PropertyValuePair {
        private final String property;
        private final String value;

        public PropertyValuePair(MaxPropCache maximoProperties, String property) {
            this.property = property;
            this.value = maximoProperties.getProperty(property);
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }
    }
}

