/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.notification;

import com.interlocsolutions.maximo.notify.NotifyService;
import com.interlocsolutions.maximo.notify.err.MXExceptionUtilsKt;
import com.interlocsolutions.maximo.notify.queue.ProcessorKey;
import com.interlocsolutions.maximo.notify.queue.notification.BulkByThreadProcessor;
import com.interlocsolutions.maximo.notify.queue.notification.JobSpecNotificationEval;
import com.interlocsolutions.maximo.notify.queue.notification.JobSpecUserExpand;
import com.interlocsolutions.maximo.notify.queue.notification.JobSpecUserRefresh;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJob;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobConfig;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobManager;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobRepo;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012J\u0015\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0015\u001a\u00020!\u00a2\u0006\u0002\u0010\"J\u000e\u0010\u001f\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020$J\u0015\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0015\u001a\u00020%\u00a2\u0006\u0002\u0010&J\u001d\u0010'\u001a\u0004\u0018\u00010 2\u0006\u0010\u0015\u001a\u00020%2\u0006\u0010(\u001a\u00020)\u00a2\u0006\u0002\u0010*J\u0016\u0010+\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0014J\u0006\u0010,\u001a\u00020#J\u000e\u0010-\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u0014J\u0006\u0010.\u001a\u00020#J\u0006\u0010/\u001a\u000200J\"\u00101\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\u00102\u001a\u000603j\u0002`4J\u0016\u00105\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u00106\u001a\u00020#2\u0006\u00107\u001a\u00020 2\u0006\u00108\u001a\u000209J\u0006\u0010:\u001a\u00020#J\u0006\u0010;\u001a\u00020#R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\b\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006<"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/notification/NotificationJobManager;", "", "()V", "jobRepo", "Lcom/interlocsolutions/maximo/notify/queue/notification/NotificationJobRepo;", "getJobRepo", "()Lcom/interlocsolutions/maximo/notify/queue/notification/NotificationJobRepo;", "jobRepo$delegate", "Lkotlin/Lazy;", "logger", "Lpsdi/util/logging/MXLogger;", "kotlin.jvm.PlatformType", "notifyService", "Lcom/interlocsolutions/maximo/notify/NotifyService;", "getNotifyService", "()Lcom/interlocsolutions/maximo/notify/NotifyService;", "notifyService$delegate", "activateJob", "", "key", "Lcom/interlocsolutions/maximo/notify/queue/ProcessorKey;", "job", "Lcom/interlocsolutions/maximo/notify/queue/notification/NotificationJob;", "claimJobs", "", "processorKey", "processorType", "Lcom/interlocsolutions/maximo/notify/queue/notification/BulkByThreadProcessor$ProcessorType;", "threadNumber", "", "serializeClaiming", "enqueue", "", "Lcom/interlocsolutions/maximo/notify/queue/notification/JobSpecNotificationEval;", "(Lcom/interlocsolutions/maximo/notify/queue/notification/JobSpecNotificationEval;)Ljava/lang/Long;", "", "Lcom/interlocsolutions/maximo/notify/queue/notification/JobSpecUserExpand;", "Lcom/interlocsolutions/maximo/notify/queue/notification/JobSpecUserRefresh;", "(Lcom/interlocsolutions/maximo/notify/queue/notification/JobSpecUserRefresh;)Ljava/lang/Long;", "enqueueError", "errorMessage", "", "(Lcom/interlocsolutions/maximo/notify/queue/notification/JobSpecUserRefresh;Ljava/lang/String;)Ljava/lang/Long;", "findThreadNumber", "freeJobsActive", "freeJobsForProcessor", "freeJobsInError", "queueCounts", "Lcom/interlocsolutions/maximo/notify/queue/notification/NotificationJobRepo$QueueStateData;", "reportError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "reportJobCompletion", "shutDown", "maxTime", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "startUp", "wakeQueue", "isinformer"})
public final class NotificationJobManager {
    @NotNull
    public static final NotificationJobManager INSTANCE = new NotificationJobManager();
    @NotNull
    private static final Lazy notifyService$delegate = LazyKt.lazy((Function0)notifyService.2.INSTANCE);
    @NotNull
    private static final Lazy jobRepo$delegate = LazyKt.lazy((Function0)jobRepo.2.INSTANCE);
    private static final MXLogger logger = NotifyConstants.INFORMER_NRQP_LOGGER;

    private NotificationJobManager() {
    }

    private final NotifyService getNotifyService() {
        Lazy lazy = notifyService$delegate;
        return (NotifyService)lazy.getValue();
    }

    private final NotificationJobRepo getJobRepo() {
        Lazy lazy = jobRepo$delegate;
        return (NotificationJobRepo)lazy.getValue();
    }

    public final void enqueue(@NotNull JobSpecUserExpand job) throws MXException {
        block5: {
            Intrinsics.checkNotNullParameter((Object)job, (String)"job");
            try {
                Object object;
                boolean matchingJobExists = NotificationJobRepo.findMatch$default(this.getJobRepo(), job.getNotifyId(), NotificationJob.NotificationJobType.USEREXPAND, NotificationJob.JobStatus.AVAILABLE, null, 8, null);
                if (!matchingJobExists) {
                    long l = job.getNotifyId();
                    NotificationJob.NotificationJobType notificationJobType = NotificationJob.NotificationJobType.USEREXPAND;
                    this.getJobRepo().addJob(new NotificationJob(0L, notificationJobType, l, null, null, null, false, null, 249, null));
                    this.getNotifyService().wakeQueue();
                    break block5;
                }
                MXLogger mXLogger = logger;
                Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
                MXLogger $this$debugLazy_u24default$iv = mXLogger;
                Object e$iv = null;
                boolean $i$f$debugLazy = false;
                if (!$this$debugLazy_u24default$iv.isDebugEnabled()) break block5;
                try {
                    boolean bl = false;
                    object = Result.constructor-impl((Object)("Skipping queueing user expansion for Profile with ID " + job.getNotifyId() + " as an inactive expansion record already exists."));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string = "(Unable to form error msg)";
                String msg$iv = (String)(Result.isFailure-impl((Object)object) ? string : object);
                $this$debugLazy_u24default$iv.debug((Object)msg$iv);
            }
            catch (Throwable e) {
                throw MXExceptionUtilsKt.toMXException(e, "Queue Notification Invalidation Eval", null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Long enqueue(@NotNull JobSpecUserRefresh job) throws MXException {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        try {
            Long l;
            boolean equivalentJobFound = this.getJobRepo().findMatch(job.getNotifyId(), NotificationJob.NotificationJobType.USERREFRESH, NotificationJob.JobStatus.AVAILABLE, job.getNotifyUserId());
            if (equivalentJobFound) {
                MXLogger mXLogger = logger;
                Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
                MXLogger $this$debugLazy_u24default$iv = mXLogger;
                Object e$iv = null;
                boolean $i$f$debugLazy = false;
                if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
                    Object object;
                    try {
                        boolean bl = false;
                        object = Result.constructor-impl((Object)("Skipping queueing user refresh for Profile with ID " + job.getNotifyId() + " as an inactive user refresh record already exists."));
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    String string = "(Unable to form error msg)";
                    String msg$iv = (String)(Result.isFailure-impl((Object)object) ? string : object);
                    $this$debugLazy_u24default$iv.debug((Object)msg$iv);
                }
                l = null;
            } else {
                void var3_5;
                long newJobId = this.getJobRepo().addJob(new NotificationJob(0L, NotificationJob.NotificationJobType.USERREFRESH, job.getNotifyId(), null, null, job.getNotifyUserId(), false, null, 217, null));
                this.getNotifyService().wakeQueue();
                l = (long)var3_5;
            }
            return l;
        }
        catch (Throwable e) {
            throw MXExceptionUtilsKt.toMXException(e, "Queue Notification User Eval", null);
        }
    }

    @Nullable
    public final Long enqueueError(@NotNull JobSpecUserRefresh job, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        return this.getJobRepo().addJob(new NotificationJob(0L, NotificationJob.NotificationJobType.USERREFRESH, job.getNotifyId(), null, null, job.getNotifyUserId(), true, errorMessage, 25, null));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Long enqueue(@NotNull JobSpecNotificationEval job) throws MXException {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        try {
            Long l;
            boolean equivalentJobFound = this.getJobRepo().findMatch(job.getNotifyId(), NotificationJob.NotificationJobType.RECORD, NotificationJob.JobStatus.AVAILABLE, job.getRecordId());
            if (equivalentJobFound) {
                MXLogger mXLogger = logger;
                Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
                MXLogger $this$debugLazy_u24default$iv = mXLogger;
                Object e$iv = null;
                boolean $i$f$debugLazy = false;
                if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
                    Object object;
                    try {
                        boolean bl = false;
                        object = Result.constructor-impl((Object)("Skipping queueing Notification evaluation for Profile with ID " + job.getNotifyId() + " and record ID " + job.getRecordId() + " as an equivalent job is already in the queue and inactive."));
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    String string = "(Unable to form error msg)";
                    String msg$iv = (String)(Result.isFailure-impl((Object)object) ? string : object);
                    $this$debugLazy_u24default$iv.debug((Object)msg$iv);
                }
                l = null;
            } else {
                void var3_5;
                long l2 = job.getNotifyId();
                NotificationJob.NotificationJobType notificationJobType = NotificationJob.NotificationJobType.RECORD;
                long l3 = job.getRecordId();
                long jobId = this.getJobRepo().addJob(new NotificationJob(0L, notificationJobType, l2, null, null, l3, false, null, 217, null));
                this.getNotifyService().wakeQueue();
                l = (long)var3_5;
            }
            return l;
        }
        catch (Throwable e) {
            throw MXExceptionUtilsKt.toMXException(e, "Queue Notification Record Eval", null);
        }
    }

    @NotNull
    public final NotificationJobRepo.QueueStateData queueCounts() {
        return this.getJobRepo().queueCounts();
    }

    public final void freeJobsForProcessor(@NotNull ProcessorKey processorKey) {
        Intrinsics.checkNotNullParameter((Object)processorKey, (String)"processorKey");
        this.getJobRepo().freeJobsFor(processorKey);
    }

    @NotNull
    public final List<NotificationJob> claimJobs(@NotNull ProcessorKey processorKey, @NotNull BulkByThreadProcessor.ProcessorType processorType, int threadNumber, boolean serializeClaiming) throws SQLException {
        List<NotificationJob> list;
        List<NotificationJob> list2;
        int n;
        NotificationJob.NotificationJobType notificationJobType;
        Intrinsics.checkNotNullParameter((Object)processorKey, (String)"processorKey");
        Intrinsics.checkNotNullParameter((Object)((Object)processorType), (String)"processorType");
        switch (WhenMappings.$EnumSwitchMapping$0[processorType.ordinal()]) {
            case 1: {
                notificationJobType = NotificationJob.NotificationJobType.USEREXPAND;
                break;
            }
            case 2: {
                notificationJobType = NotificationJob.NotificationJobType.USERREFRESH;
                break;
            }
            case 3: {
                notificationJobType = NotificationJob.NotificationJobType.RECORD;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        NotificationJob.NotificationJobType jobType = notificationJobType;
        switch (WhenMappings.$EnumSwitchMapping$0[processorType.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 10;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int limit = n;
        boolean bl = serializeClaiming;
        if (!bl) {
            NotificationJobRepo notificationJobRepo = this.getJobRepo();
            MXLogger mXLogger = logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            list2 = notificationJobRepo.claimJobs(processorKey, jobType, limit, mXLogger);
        } else if (bl) {
            NotificationJobRepo notificationJobRepo = this.getJobRepo();
            MXLogger mXLogger = logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            list2 = notificationJobRepo.claimJobs(processorKey, jobType, limit, threadNumber, mXLogger);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List<NotificationJob> notificationJobs = list = list2;
        boolean bl2 = false;
        MXLogger mXLogger = logger;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
        MXLogger $this$debugLazy_u24default$iv = mXLogger;
        Object e$iv = null;
        boolean $i$f$debugLazy = false;
        if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
            Object object;
            try {
                boolean bl3 = false;
                object = Result.constructor-impl((Object)(notificationJobs.size() + " job(s) claimed for " + processorKey.getHost() + ", " + processorKey.getMxName() + ", " + processorKey.getThreadName() + '.'));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            String string = "(Unable to form error msg)";
            String msg$iv = (String)(Result.isFailure-impl((Object)object) ? string : object);
            $this$debugLazy_u24default$iv.debug((Object)msg$iv);
        }
        return list;
    }

    public final void reportError(@NotNull ProcessorKey processorKey, @NotNull NotificationJob job, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)processorKey, (String)"processorKey");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        NotificationJobRepo notificationJobRepo = this.getJobRepo();
        String string = e.getMessage();
        if (string == null) {
            string = e.getClass().getName();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message ?: e.javaClass.name");
        notificationJobRepo.reportError(job, string);
    }

    public final boolean activateJob(@NotNull ProcessorKey key, @NotNull NotificationJob job) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        return this.getJobRepo().activateJob(key, job);
    }

    public final void reportJobCompletion(@NotNull ProcessorKey key, @NotNull NotificationJob job) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        this.getJobRepo().deleteJob(job);
    }

    public final void freeJobsInError() throws MXException {
        Object object;
        Object object2 = this;
        try {
            NotificationJobManager $this$freeJobsInError_u24lambda_u245 = object2;
            boolean bl = false;
            $this$freeJobsInError_u24lambda_u245.getJobRepo().freeJobsInError();
            $this$freeJobsInError_u24lambda_u245.getNotifyService().wakeQueue();
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = object = throwable;
            boolean bl = false;
            throw MXExceptionUtilsKt.toMXException((Throwable)e, "\"Free Failed Notification Jobs\"", null);
        }
    }

    public final void freeJobsActive() throws MXException {
        Object object;
        Object object2 = this;
        try {
            NotificationJobManager $this$freeJobsActive_u24lambda_u247 = object2;
            boolean bl = false;
            $this$freeJobsActive_u24lambda_u247.getJobRepo().freeJobsActive();
            $this$freeJobsActive_u24lambda_u247.getNotifyService().wakeQueue();
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = object = throwable;
            boolean bl = false;
            throw MXExceptionUtilsKt.toMXException((Throwable)e, "\"Free Active Notification Jobs\"", null);
        }
    }

    public final void startUp() {
        NotificationJobConfig.INSTANCE.getNotificationJobQueueProcessor().startup();
    }

    public final void wakeQueue() throws RemoteException {
        NotificationJobConfig.INSTANCE.getNotificationJobQueueProcessor().process();
    }

    public final void shutDown(long maxTime, @NotNull TimeUnit timeUnit) throws MXException, RemoteException {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        NotificationJobConfig.INSTANCE.getNotificationJobQueueProcessor().shutdown();
    }

    public final int findThreadNumber(@NotNull BulkByThreadProcessor.ProcessorType processorType, @NotNull ProcessorKey processorKey) {
        Intrinsics.checkNotNullParameter((Object)((Object)processorType), (String)"processorType");
        Intrinsics.checkNotNullParameter((Object)processorKey, (String)"processorKey");
        return this.getJobRepo().findThreadNumber(processorType, processorKey);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BulkByThreadProcessor.ProcessorType.values().length];
            try {
                nArray[BulkByThreadProcessor.ProcessorType.USEREXPAND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BulkByThreadProcessor.ProcessorType.USERREFRESH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BulkByThreadProcessor.ProcessorType.NOTIFICATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

