/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.db;

import com.interlocsolutions.maximo.notify.queue.DatabaseFunctionsKt;
import com.interlocsolutions.maximo.notify.queue.LockType;
import com.interlocsolutions.maximo.notify.queue.db.BulkByJvmCatalogJobReaderSql;
import java.sql.Connection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/db/SqlServerReaderSql;", "Lcom/interlocsolutions/maximo/notify/queue/db/BulkByJvmCatalogJobReaderSql;", "()V", "lock", "", "connection", "Ljava/sql/Connection;", "lockName", "", "selectionSql", "batchSize", "", "orderBy", "unlock", "isinformer"})
public final class SqlServerReaderSql
extends BulkByJvmCatalogJobReaderSql {
    @Override
    @NotNull
    public String selectionSql(int batchSize, @NotNull String orderBy) {
        Intrinsics.checkNotNullParameter((Object)orderBy, (String)"orderBy");
        return StringsKt.trimIndent((String)("\n            SELECT TOP(" + batchSize + ") * \n            FROM iscatalogjobqueue WITH (rowlock, xlock) \n            WHERE jobstatus = 0\n            " + orderBy + "\n        "));
    }

    @Override
    public void lock(@NotNull Connection connection, @NotNull String lockName) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)lockName, (String)"lockName");
        DatabaseFunctionsKt.sqlServerLock(connection, lockName, LockType.EXCLUSIVE);
    }

    @Override
    public void unlock(@NotNull Connection connection, @NotNull String lockName) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)lockName, (String)"lockName");
        DatabaseFunctionsKt.sqlServerUnlock(connection, lockName);
    }
}

