/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.db;

import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobEval;
import com.interlocsolutions.maximo.notify.queue.catalog.JobReconcile;
import com.interlocsolutions.maximo.notify.queue.catalog.JobRelationshipEval;
import com.interlocsolutions.maximo.notify.queue.db.JobDispatcherDBNoExpand;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class JobDispatcherDBReducing
extends JobDispatcherDBNoExpand {
    protected static final MXLogger LOGGER = NotifyConstants.INFORMER_CRQP_LOGGER;

    @Override
    public void doEvals(@NotNull EvalContext evalContext, @NotNull Collection<JobEval.JobSpecEval> jobs, @NotNull MboRemote mbo) throws RemoteException, MXException {
        boolean doItNow;
        if (evalContext.hasAny(EnumSet.of(EvalFlags.DEFERRED, EvalFlags.SCHEDULED))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided not to defer evaluation of %d %s jobs this is already part of a background process.", jobs.size(), JobEval.JobSpecEval.class.getSimpleName()));
            }
            doItNow = true;
        } else if (evalContext.hasAny(EnumSet.of(EvalFlags.USER_WAITING, EvalFlags.USER_WAITING_ASYNC))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided to defer evaluation of %d %s jobs to preserve user responsiveness.", jobs.size(), JobEval.JobSpecEval.class.getSimpleName()));
            }
            doItNow = false;
        } else if (jobs.size() >= 10) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Declined to evaluation %d %s jobs inline because there are too many to evaluate at once.", jobs.size(), JobEval.JobSpecEval.class.getSimpleName()));
            }
            doItNow = false;
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided to evaluate %d %s jobs immediately because we have no indication that a user is waiting, and the number of evaluations to conduct is reasonable.", jobs.size(), JobEval.JobSpecEval.class.getSimpleName()));
            }
            doItNow = true;
        }
        if (doItNow) {
            for (JobEval.JobSpecEval job : jobs) {
                JobConfig.getJobFactory().instantiateJobEval(evalContext, job).invoke(mbo);
            }
        } else {
            super.doEvals(evalContext, jobs, mbo);
        }
    }

    @Override
    public void doEvals(@NotNull EvalContext evalContext, @NotNull Collection<JobEval.JobSpecEval> jobs) throws RemoteException, MXException {
        boolean doItNow;
        if (evalContext.hasAny(EnumSet.of(EvalFlags.DEFERRED, EvalFlags.SCHEDULED))) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)String.format("Decided not to defer evaluation of %d %s jobs this is already part of a background process.", jobs.size(), JobEval.JobSpecEval.class.getSimpleName()));
            }
            doItNow = true;
        } else if (evalContext.hasAny(EnumSet.of(EvalFlags.USER_WAITING, EvalFlags.USER_WAITING_ASYNC))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided to defer evaluation of %d %s jobs to preserve user responsiveness.", jobs.size(), JobEval.JobSpecEval.class.getSimpleName()));
            }
            doItNow = false;
        } else if (jobs.size() >= 10) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Declined to evaluation %d %s jobs inline because there are too many to evaluate at once.", jobs.size(), JobEval.JobSpecEval.class.getSimpleName()));
            }
            doItNow = false;
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided evaluate of %d %s jobs because we have no indication that a user is waiting, and the number of evaluations to conduct is reasonable.", jobs.size(), JobEval.JobSpecEval.class.getSimpleName()));
            }
            doItNow = true;
        }
        if (doItNow) {
            for (JobEval.JobSpecEval job : jobs) {
                JobConfig.getJobFactory().instantiateJobEval(evalContext, job).invoke();
            }
        } else {
            super.doEvals(evalContext, jobs);
        }
    }

    @Override
    public void doRelationEvals(@NotNull EvalContext evalContext, @NotNull Collection<JobRelationshipEval.JobSpecRelationshipEval> jobs, @NotNull MboRemote mbo) throws RemoteException, MXException {
        boolean doItNow;
        if (evalContext.hasAny(EnumSet.of(EvalFlags.USER_WAITING, EvalFlags.USER_WAITING_ASYNC))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided to defer evaluation of %d %s jobs to preserve user responsiveness.", jobs.size(), JobRelationshipEval.JobSpecRelationshipEval.class.getSimpleName()));
            }
            doItNow = false;
        } else if (evalContext.hasAny(EnumSet.of(EvalFlags.DEFERRED, EvalFlags.SCHEDULED))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided to evaluate %d %s jobs immediately, because this is request part of a deferred or scheduled process, so blocking resources for completion is actually the most appropriate action.", jobs.size(), JobRelationshipEval.JobSpecRelationshipEval.class.getSimpleName()));
            }
            doItNow = true;
        } else if (jobs.size() >= 10) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided to defer evaluation of %d %s jobs because there are too many to evaluate at once.", jobs.size(), JobRelationshipEval.JobSpecRelationshipEval.class.getSimpleName()));
            }
            doItNow = false;
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided to evaluate %d %s jobs immediately because we have no indication that a user is waiting, and the number of evaluations to conduct is reasonable.", jobs.size(), JobRelationshipEval.JobSpecRelationshipEval.class.getSimpleName()));
            }
            doItNow = true;
        }
        if (doItNow) {
            for (JobRelationshipEval.JobSpecRelationshipEval job : jobs) {
                JobConfig.getJobFactory().instantiateJobRelationEval(evalContext, job).invoke(mbo);
            }
        } else {
            super.doRelationEvals(evalContext, jobs, mbo);
        }
    }

    @Override
    public void doReconciliations(@NotNull EvalContext evalContext, @NotNull Collection<JobReconcile.JobSpecReconcile> jobs) throws RemoteException, MXException {
        boolean doItNow;
        if (evalContext.hasAny(EnumSet.of(EvalFlags.USER_WAITING, EvalFlags.USER_WAITING_ASYNC))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided to defer evaluation of %d %s jobs to preserve user responsiveness.", jobs.size(), JobRelationshipEval.JobSpecRelationshipEval.class.getSimpleName()));
            }
            doItNow = false;
        } else if (evalContext.hasAny(EnumSet.of(EvalFlags.DEFERRED, EvalFlags.SCHEDULED))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided to evaluate %d %s jobs immeidately, because this is request part of a deferred or scheduled process, so blocking resources for completion is actually the most appropriate action.", jobs.size(), JobRelationshipEval.JobSpecRelationshipEval.class.getSimpleName()));
            }
            doItNow = true;
        } else if (jobs.size() > 1) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided to defer evaluation of %d %s jobs because there are too many to evaluate at once.", jobs.size(), JobRelationshipEval.JobSpecRelationshipEval.class.getSimpleName()));
            }
            doItNow = false;
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided to evaluate %d %s jobs immediately because we have no indication that a user is waiting, and the number of evaluations to conduct is reasonable.", jobs.size(), JobRelationshipEval.JobSpecRelationshipEval.class.getSimpleName()));
            }
            doItNow = true;
        }
        if (doItNow) {
            for (JobReconcile.JobSpecReconcile job : jobs) {
                JobConfig.getJobFactory().instantiateJobReconcile(evalContext, job).invoke();
            }
        } else {
            super.doReconciliations(evalContext, jobs);
        }
    }
}

