/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.db;

import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobEval;
import com.interlocsolutions.maximo.notify.queue.db.JobDispatcherDBImpl;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class JobDispatcherDBNoExpand
extends JobDispatcherDBImpl {
    private static final MXLogger LOGGER = NotifyConstants.INFORMER_CRQP_LOGGER;

    @Override
    public void doEvals(@NotNull EvalContext evalContext, @NotNull Collection<JobEval.JobSpecEval> jobs, @NotNull MboRemote mbo) throws RemoteException, MXException {
        if (evalContext.hasAny(EnumSet.of(EvalFlags.RECONCILIATION_FULL, EvalFlags.RECONCILIATION_PARTIAL, EvalFlags.RELATIONSHIP_EVAL))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided not to defer evaluation of %d %s jobs because these are part of an expansion task (reconciliation or relationship evaluation), and we are trying to keep the number of records in the DB low. Choosing to sacrifice the potential processing and midstream recovery in favor of the simplicity of a continuous operation.", jobs.size(), JobEval.JobSpecEval.class.getSimpleName()));
            }
            for (JobEval.JobSpecEval job : jobs) {
                JobConfig.getJobFactory().instantiateJobEval(evalContext, job).invoke();
            }
        } else {
            super.doEvals(evalContext, jobs, mbo);
        }
    }

    @Override
    public void doEvals(@NotNull EvalContext evalContext, @NotNull Collection<JobEval.JobSpecEval> jobs) throws RemoteException, MXException {
        if (evalContext.hasAny(EnumSet.of(EvalFlags.RECONCILIATION_FULL, EvalFlags.RECONCILIATION_PARTIAL, EvalFlags.RELATIONSHIP_EVAL))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decided not to defer evaluation of %d %s jobs because these are part of an expansion task (reconciliation or relationship evaluation), and we are trying to keep the number of records in the DB low. Choosing to sacrifice the potential processing and midstream recovery in favor of the simplicity of a continuous operation.", jobs.size(), JobEval.JobSpecEval.class.getSimpleName()));
            }
            for (JobEval.JobSpecEval job : jobs) {
                JobConfig.getJobFactory().instantiateJobEval(evalContext, job).invoke();
            }
        } else {
            super.doEvals(evalContext, jobs);
        }
    }
}

