/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.db;

import com.interlocsolutions.maximo.notify.queue.AbstractQueueProcessor;
import com.interlocsolutions.maximo.notify.queue.catalog.JobQueueProcessor;
import com.interlocsolutions.maximo.notify.queue.db.BulkByThreadProcessor;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.InformerThreadGroup;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0017\u001a\u00020\u000f2\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001aH\u0002J\b\u0010#\u001a\u00020!H\u0014J\b\u0010$\u001a\u00020!H\u0014J\b\u0010%\u001a\u00020\u001cH\u0014R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/interlocsolutions/maximo/notify/queue/db/BulkByThreadCatalogJobQueueProcessor;", "Lcom/interlocsolutions/maximo/notify/queue/AbstractQueueProcessor;", "Lcom/interlocsolutions/maximo/notify/queue/catalog/JobQueueProcessor;", "()V", "catalogPool", "Lcom/interlocsolutions/maximo/notify/queue/db/BulkByThreadCatalogJobQueueProcessor$CatalogPoolConfig;", "getCatalogPool", "()Lcom/interlocsolutions/maximo/notify/queue/db/BulkByThreadCatalogJobQueueProcessor$CatalogPoolConfig;", "catalogQueueProcessors", "Ljava/util/ArrayList;", "Lcom/interlocsolutions/maximo/notify/queue/db/BulkByThreadProcessor;", "Lkotlin/collections/ArrayList;", "defaultCatalogConfig", "getDefaultCatalogConfig", "legacyCatalogQueueAggregate", "", "legacyCatalogQueueDoNotRun", "legacyCatalogQueuePool", "legacyHfCatalogQueueAggregate", "myThreadGroup", "Lcom/interlocsolutions/maximo/notify/util/InformerThreadGroup;", "nextThreadNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "determineNewCatalogQProp", "propAccessor", "Lkotlin/Function1;", "Lcom/interlocsolutions/maximo/notify/util/InformerProp;", "determineShutdown", "", "findLegacyCatalogConfig", "getNextThreadNumber", "", "logDeprecationWarning", "", "it", "performProcess", "performShutdown", "performStartup", "CJQPThreadGroup", "CatalogPoolConfig", "isinformer"})
public final class BulkByThreadCatalogJobQueueProcessor
extends AbstractQueueProcessor
implements JobQueueProcessor {
    @NotNull
    private final String legacyCatalogQueueDoNotRun;
    @NotNull
    private final String legacyCatalogQueuePool;
    @NotNull
    private final String legacyCatalogQueueAggregate;
    @NotNull
    private final String legacyHfCatalogQueueAggregate;
    @NotNull
    private final CatalogPoolConfig defaultCatalogConfig;
    @NotNull
    private final ArrayList<BulkByThreadProcessor> catalogQueueProcessors;
    @NotNull
    private final InformerThreadGroup myThreadGroup;
    @NotNull
    private final AtomicInteger nextThreadNumber;

    public BulkByThreadCatalogJobQueueProcessor() {
        MXLogger mXLogger = NotifyConstants.INFORMER_CRQP_LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"INFORMER_CRQP_LOGGER");
        super(mXLogger);
        this.legacyCatalogQueueDoNotRun = "informer.catalog.queue.donotrun";
        this.legacyCatalogQueuePool = "informer.catalog.queue.pool";
        this.legacyCatalogQueueAggregate = "informer.catalog.queue.aggprocs";
        this.legacyHfCatalogQueueAggregate = "informer.hf.catalog.queue.aggprocs";
        this.defaultCatalogConfig = new CatalogPoolConfig(1, 1);
        this.catalogQueueProcessors = new ArrayList();
        this.myThreadGroup = new CJQPThreadGroup();
        this.nextThreadNumber = new AtomicInteger(0);
    }

    @NotNull
    public final CatalogPoolConfig getDefaultCatalogConfig() {
        return this.defaultCatalogConfig;
    }

    private final int getNextThreadNumber() {
        return this.nextThreadNumber.getAndAdd(1);
    }

    @Override
    protected boolean performStartup() {
        BulkByThreadProcessor crqp;
        int i;
        CatalogPoolConfig catalogPoolConfig = this.getCatalogPool();
        int catalogAggregatePoolSize = catalogPoolConfig.component1();
        int catalogRecordPoolSize = catalogPoolConfig.component2();
        for (i = 0; i < catalogAggregatePoolSize; ++i) {
            crqp = new BulkByThreadProcessor(this.myThreadGroup, "Informer-CatalogQueueProcessor-Aggregate-" + this.getNextThreadNumber(), 1);
            this.catalogQueueProcessors.add(crqp);
            crqp.start();
        }
        for (i = 0; i < catalogRecordPoolSize; ++i) {
            crqp = new BulkByThreadProcessor(this.myThreadGroup, "Informer-CatalogQueueProcessor-Record-" + this.getNextThreadNumber(), 0);
            this.catalogQueueProcessors.add(crqp);
            crqp.start();
        }
        return true;
    }

    @Override
    protected void performShutdown() {
        this.catalogQueueProcessors.clear();
        this.myThreadGroup.awaitShutdown(10L, TimeUnit.SECONDS);
    }

    @Override
    protected void performProcess() {
        for (BulkByThreadProcessor crqp : this.catalogQueueProcessors) {
            crqp.wake();
        }
    }

    @Override
    protected boolean determineShutdown() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.catalogQueueProcessors;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    BulkByThreadProcessor it = (BulkByThreadProcessor)element$iv;
                    boolean bl2 = false;
                    if (!it.isAlive()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CatalogPoolConfig getCatalogPool() {
        Object object;
        InformerProp informerProp;
        InformerProp informerProp2 = this.findLegacyCatalogConfig();
        if (informerProp2 != null) {
            InformerProp it = informerProp2;
            boolean bl = false;
            this.logDeprecationWarning(it);
            informerProp = new InformerProp("informer.queue.pool.catalog", this.determineNewCatalogQProp((Function1<? super String, InformerProp>)((Function1)new Function1<String, InformerProp>((Object)PropUtil.INSTANCE){

                @Nullable
                public final InformerProp invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((PropUtil)this.receiver).getProp(p0);
                }
            })));
        } else {
            informerProp = PropUtil.INSTANCE.getProp("informer.queue.pool.catalog");
        }
        InformerProp poolProp2 = informerProp;
        try {
            Object object2;
            block18: {
                block17: {
                    CatalogPoolConfig catalogPoolConfig;
                    void $this$mapNotNullTo$iv$iv;
                    object2 = poolProp2;
                    if (object2 == null || (object2 = ((InformerProp)object2).asList()) == null) break block17;
                    Iterable $this$mapNotNull$iv = (Iterable)object2;
                    boolean $i$f$mapNotNull = false;
                    Iterable bl = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Integer it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        InformerProp it = (InformerProp)element$iv$iv;
                        boolean bl3 = false;
                        if (it.asInt() == null) continue;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List args = (List)destination$iv$iv;
                    boolean bl5 = false;
                    block1 : switch (args.size()) {
                        case 0: {
                            this.getLogger().warn((Object)("informer.queue.pool.catalog=" + poolProp2 + " is blank. Defaults will be used."));
                            catalogPoolConfig = this.defaultCatalogConfig;
                            break;
                        }
                        case 1: {
                            int singleValue = ((Number)args.get(0)).intValue();
                            switch (singleValue) {
                                case 0: {
                                    catalogPoolConfig = new CatalogPoolConfig(0, 0);
                                    break block1;
                                }
                                case 1: {
                                    this.getLogger().warn((Object)StringsKt.trimIndent((String)("\n                                        informer.queue.pool.catalog=" + poolProp2 + " is specified as a single number,\n                                        but less than the required minimum of 2. Defaults will be used.\n                                        ")));
                                    catalogPoolConfig = this.defaultCatalogConfig;
                                    break block1;
                                }
                            }
                            catalogPoolConfig = new CatalogPoolConfig(1, singleValue - 1);
                            break;
                        }
                        case 2: {
                            catalogPoolConfig = new CatalogPoolConfig(((Number)args.get(0)).intValue(), ((Number)args.get(1)).intValue());
                            break;
                        }
                        default: {
                            this.getLogger().warn((Object)StringsKt.trimIndent((String)("\n                                informer.queue.pool.catalog=" + poolProp2 + " has too many arguments. Defaults will be used.\n                                ")));
                            catalogPoolConfig = this.defaultCatalogConfig;
                        }
                    }
                    object2 = catalogPoolConfig;
                    if (catalogPoolConfig != null) break block18;
                }
                object2 = this.defaultCatalogConfig;
            }
            object = object2;
        }
        catch (Exception e) {
            this.getLogger().error((Object)("Unable to parse queue pool size from informer.queue.pool.catalog=" + poolProp2 + ".Pool sizes will be set to default values.\nCause: " + e));
            object = this.defaultCatalogConfig;
        }
        return object;
    }

    private final InformerProp findLegacyCatalogConfig() {
        InformerProp informerProp = PropUtil.INSTANCE.getProp("informer.queue.donotrun");
        if (informerProp == null && (informerProp = PropUtil.INSTANCE.getProp("informer.queue.pool")) == null && (informerProp = PropUtil.INSTANCE.getProp(this.legacyCatalogQueueDoNotRun)) == null && (informerProp = PropUtil.INSTANCE.getProp(this.legacyCatalogQueuePool)) == null && (informerProp = PropUtil.INSTANCE.getProp(this.legacyCatalogQueueAggregate)) == null) {
            informerProp = PropUtil.INSTANCE.getProp(this.legacyHfCatalogQueueAggregate);
        }
        return informerProp;
    }

    private final void logDeprecationWarning(InformerProp it) {
        this.getLogger().warn((Object)StringsKt.trimIndent((String)("\n                **** **** **** ****\n                **** **** **** ****\n                Use of JVM or System Property '" + it.getPropName() + "' is deprecated, and will be removed in a later version.\n                Please use the 'informer.queue.pool.catalog' Maximo System Properties to control your \n                queues, globally and/or using Instance properties.\n                **** **** **** ****\n                **** **** **** ****\n                ")));
    }

    private final String determineNewCatalogQProp(Function1<? super String, InformerProp> propAccessor) {
        String string;
        int n;
        InformerProp informerProp = (InformerProp)propAccessor.invoke((Object)"informer.queue.donotrun");
        if (informerProp != null ? Intrinsics.areEqual((Object)informerProp.asBoolean(), (Object)true) : false) {
            n = 0;
        } else {
            InformerProp informerProp2 = (InformerProp)propAccessor.invoke((Object)this.legacyCatalogQueueDoNotRun);
            if (informerProp2 != null ? Intrinsics.areEqual((Object)informerProp2.asBoolean(), (Object)true) : false) {
                n = 0;
            } else {
                Object object = (InformerProp)propAccessor.invoke((Object)this.legacyCatalogQueuePool);
                if (object != null && (object = ((InformerProp)object).asInt()) != null) {
                    n = (Integer)object;
                } else {
                    InformerProp informerProp3 = (InformerProp)propAccessor.invoke((Object)"informer.queue.pool");
                    Integer n2 = informerProp3 != null ? informerProp3.asInt() : null;
                    n = n2 != null ? n2 : 2;
                }
            }
        }
        int totalPoolSize = n;
        if (totalPoolSize <= 0) {
            string = "0,0";
        } else if (totalPoolSize == 1) {
            string = "1,1";
        } else {
            int n3;
            Object object = (InformerProp)propAccessor.invoke((Object)this.legacyCatalogQueueAggregate);
            if (object != null && (object = ((InformerProp)object).asInt()) != null) {
                n3 = (Integer)object;
            } else {
                InformerProp informerProp4 = (InformerProp)propAccessor.invoke((Object)this.legacyHfCatalogQueueAggregate);
                Integer n4 = informerProp4 != null ? informerProp4.asInt() : null;
                n3 = n4 != null ? n4 : 1;
            }
            int aggPoolSize = n3;
            string = aggPoolSize <= 0 ? "0," + totalPoolSize : (aggPoolSize >= totalPoolSize - 1 ? Math.min(aggPoolSize, totalPoolSize - 1) + ",1" : "" + aggPoolSize + ',' + (totalPoolSize - aggPoolSize));
        }
        return string;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/db/BulkByThreadCatalogJobQueueProcessor$CatalogPoolConfig;", "", "numAggregate", "", "numRecord", "(II)V", "getNumAggregate", "()I", "getNumRecord", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "isinformer"})
    public static final class CatalogPoolConfig {
        private final int numAggregate;
        private final int numRecord;

        public CatalogPoolConfig(int numAggregate, int numRecord) {
            this.numAggregate = numAggregate;
            this.numRecord = numRecord;
        }

        public final int getNumAggregate() {
            return this.numAggregate;
        }

        public final int getNumRecord() {
            return this.numRecord;
        }

        public final int component1() {
            return this.numAggregate;
        }

        public final int component2() {
            return this.numRecord;
        }

        @NotNull
        public final CatalogPoolConfig copy(int numAggregate, int numRecord) {
            return new CatalogPoolConfig(numAggregate, numRecord);
        }

        public static /* synthetic */ CatalogPoolConfig copy$default(CatalogPoolConfig catalogPoolConfig, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = catalogPoolConfig.numAggregate;
            }
            if ((n3 & 2) != 0) {
                n2 = catalogPoolConfig.numRecord;
            }
            return catalogPoolConfig.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "CatalogPoolConfig(numAggregate=" + this.numAggregate + ", numRecord=" + this.numRecord + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.numAggregate);
            result = result * 31 + Integer.hashCode(this.numRecord);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CatalogPoolConfig)) {
                return false;
            }
            CatalogPoolConfig catalogPoolConfig = (CatalogPoolConfig)other;
            if (this.numAggregate != catalogPoolConfig.numAggregate) {
                return false;
            }
            return this.numRecord == catalogPoolConfig.numRecord;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/db/BulkByThreadCatalogJobQueueProcessor$CJQPThreadGroup;", "Lcom/interlocsolutions/maximo/notify/util/InformerThreadGroup;", "()V", "isinformer"})
    private static final class CJQPThreadGroup
    extends InformerThreadGroup {
        public CJQPThreadGroup() {
            super(InformerThreadGroup.getInformerThreadGroup());
        }
    }
}

