/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.db;

import com.interlocsolutions.maximo.notify.queue.AbstractBulkByJvmReaderThread;
import com.interlocsolutions.maximo.notify.queue.AbstractBulkByJvmWriterThread;
import com.interlocsolutions.maximo.notify.queue.BulkByJvmReaderSql;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogJobRepo;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogQueueJob;
import com.interlocsolutions.maximo.notify.queue.db.BulkByJvmCatalogReaderSqlKt;
import com.interlocsolutions.maximo.notify.queue.db.BulkByJvmProcessor;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.JDBCExtensionsKt;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\u0006\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\fH\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0014\u00a8\u0006\u001f"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/db/BulkByJvmReaderThread;", "Lcom/interlocsolutions/maximo/notify/queue/AbstractBulkByJvmReaderThread;", "Lcom/interlocsolutions/maximo/notify/queue/catalog/CatalogQueueJob;", "threadName", "", "readerQueue", "Ljava/util/concurrent/BlockingQueue;", "Ljava/lang/Runnable;", "writerQueue", "Lcom/interlocsolutions/maximo/notify/queue/AbstractBulkByJvmWriterThread$Payload;", "(Ljava/lang/String;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/BlockingQueue;)V", "claimRecord", "", "statement", "Ljava/sql/PreparedStatement;", "job", "resultSet", "Ljava/sql/ResultSet;", "cleanUpJobs", "getBatchSize", "", "getOrdering", "Lcom/interlocsolutions/maximo/notify/queue/BulkByJvmReaderSql$OrderBy;", "getProcessorCategory", "getReaderSql", "Lcom/interlocsolutions/maximo/notify/queue/BulkByJvmReaderSql;", "serverType", "Lcom/interlocsolutions/maximo/notify/util/db/DbServerType;", "newRunnable", "latch", "Ljava/util/concurrent/CountDownLatch;", "isinformer"})
public final class BulkByJvmReaderThread
extends AbstractBulkByJvmReaderThread<CatalogQueueJob> {
    public BulkByJvmReaderThread(@Nullable String threadName, @NotNull BlockingQueue<Runnable> readerQueue, @NotNull BlockingQueue<AbstractBulkByJvmWriterThread.Payload<CatalogQueueJob>> writerQueue) {
        Intrinsics.checkNotNullParameter(readerQueue, (String)"readerQueue");
        Intrinsics.checkNotNullParameter(writerQueue, (String)"writerQueue");
        MXLogger mXLogger = NotifyConstants.INFORMER_CRQP_LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"INFORMER_CRQP_LOGGER");
        super(threadName, readerQueue, writerQueue, "Catalog Queue Reader", "CATALOG.Q", mXLogger);
    }

    @Override
    protected void cleanUpJobs() {
        CatalogJobRepo.INSTANCE.freeJobsFor(this.getProcessorKey());
    }

    @Override
    protected int getBatchSize() {
        Object object = PropUtil.INSTANCE.getProp("informer.max.QueueBatchSize");
        return RangesKt.coerceAtLeast((int)(object != null && (object = ((InformerProp)object).asInt()) != null ? ((Integer)object).intValue() : this.getDefaultBatchSize()), (int)1);
    }

    @Override
    @NotNull
    protected BulkByJvmReaderSql getReaderSql(@NotNull DbServerType serverType) {
        Intrinsics.checkNotNullParameter((Object)serverType, (String)"serverType");
        return BulkByJvmCatalogReaderSqlKt.newBulkByJvmReaderSql(serverType);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    protected BulkByJvmReaderSql.OrderBy getOrdering() {
        block8: {
            block7: {
                v0 = PropUtil.INSTANCE.getProp("informer.catalog.queue.ordering");
                if (v0 == null || (v0 = v0.asString()) == null) {
                    v0 = "priority";
                }
                var2_2 = ordering = v0;
                switch (var2_2.hashCode()) {
                    case 3142860: {
                        if (var2_2.equals("fifo")) break;
                        ** break;
                    }
                    case 3387192: {
                        if (!var2_2.equals("none")) {
                            ** break;
                        }
                        break block7;
                    }
                    case -1165461084: {
                        if (!var2_2.equals("priority")) ** break;
                        v1 = BulkByJvmReaderSql.OrderBy.PRIORITY;
                        break block8;
                    }
                }
                v1 = BulkByJvmReaderSql.OrderBy.FIFO;
                break block8;
            }
            v1 = BulkByJvmReaderSql.OrderBy.NONE;
            break block8;
lbl22:
            // 4 sources

            it = var3_3 = BulkByJvmReaderSql.OrderBy.NONE;
            $i$a$-also-BulkByJvmReaderThread$getOrdering$1 = false;
            this.logger.error((Object)("Property 'informer.catalog.queue.ordering' value '" + (String)ordering + "' is not recognized. Ordering will not be enforced."));
            v1 = var3_3;
        }
        return v1;
    }

    @Override
    @NotNull
    protected CatalogQueueJob claimRecord(@NotNull ResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        return new CatalogQueueJob(resultSet.getLong("iscatalogjobqueueid"), resultSet.getInt("jobtype"), resultSet.getInt("errorcount"), resultSet.getLong("catalogid"), resultSet.getLong("revision"), JDBCExtensionsKt.getNullableLong((ResultSet)resultSet, (String)"parent"), JDBCExtensionsKt.getNullableLong((ResultSet)resultSet, (String)"recordid"), resultSet.getString("langcode"), resultSet.getString("whereclause"));
    }

    @Override
    @NotNull
    public String getProcessorCategory() {
        return "CATALOG.Q";
    }

    @Override
    protected void claimRecord(@NotNull PreparedStatement statement, @NotNull CatalogQueueJob job) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        statement.setInt(1, 2);
        statement.setString(2, this.getProcessorKey().getHost());
        statement.setString(3, this.getProcessorKey().getMxName());
        statement.setString(4, this.getProcessorKey().getThreadName());
        statement.setLong(5, job.getJobId());
    }

    @Override
    @NotNull
    protected Runnable newRunnable(@NotNull CatalogQueueJob job, @NotNull CountDownLatch latch) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)latch, (String)"latch");
        return new BulkByJvmProcessor(job, this.getWriterQueue(), latch);
    }
}

