/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.catalog;

import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.util.MboInterface;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.security.UserInfo;
import psdi.server.MXServer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B+\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0006J\u0006\u0010\u001b\u001a\u00020\u0000J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u0012J\u0016\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012J\u0014\u0010\u001f\u001a\u00020 2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u000e\u0010!\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0006J\u0016\u0010#\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/catalog/EvalContext;", "", "userInfo", "Lpsdi/security/UserInfo;", "flags", "Ljava/util/EnumSet;", "Lcom/interlocsolutions/maximo/notify/queue/catalog/EvalFlags;", "props", "Ljava/util/Properties;", "(Lpsdi/security/UserInfo;Ljava/util/EnumSet;Ljava/util/Properties;)V", "getFlags", "()Ljava/util/EnumSet;", "mbos", "Lcom/interlocsolutions/maximo/notify/util/MboInterface;", "getMbos", "()Lcom/interlocsolutions/maximo/notify/util/MboInterface;", "propKeys", "", "", "getPropKeys", "()Ljava/util/Set;", "getProps", "()Ljava/util/Properties;", "getUserInfo", "()Lpsdi/security/UserInfo;", "clearFlag", "flag", "duplicate", "getProp", "propName", "defaultValue", "hasAny", "", "hasFlag", "setFlag", "setProp", "value", "isinformer"})
public final class EvalContext {
    @NotNull
    private final UserInfo userInfo;
    @NotNull
    private final EnumSet<EvalFlags> flags;
    @NotNull
    private final Properties props;
    @NotNull
    private final MboInterface mbos;

    @JvmOverloads
    public EvalContext(@NotNull UserInfo userInfo, @NotNull EnumSet<EvalFlags> flags, @NotNull Properties props) {
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        this.userInfo = userInfo;
        this.flags = flags;
        this.props = props;
        this.mbos = MboInterface.Companion.obtain(this.userInfo);
    }

    public /* synthetic */ EvalContext(UserInfo userInfo, EnumSet enumSet, Properties properties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            UserInfo userInfo2 = MXServer.getMXServer().getSystemUserInfo();
            Intrinsics.checkNotNullExpressionValue((Object)userInfo2, (String)"getMXServer().systemUserInfo");
            userInfo = userInfo2;
        }
        if ((n & 2) != 0) {
            EnumSet<EvalFlags> enumSet2 = EnumSet.noneOf(EvalFlags.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(EvalFlags::class.java)");
            enumSet = enumSet2;
        }
        if ((n & 4) != 0) {
            properties = new Properties();
        }
        this(userInfo, enumSet, properties);
    }

    @NotNull
    public final UserInfo getUserInfo() {
        return this.userInfo;
    }

    @NotNull
    public final EnumSet<EvalFlags> getFlags() {
        return this.flags;
    }

    @NotNull
    public final Properties getProps() {
        return this.props;
    }

    @NotNull
    public final MboInterface getMbos() {
        return this.mbos;
    }

    @NotNull
    public final EvalContext setFlag(@NotNull EvalFlags flag) {
        Intrinsics.checkNotNullParameter((Object)((Object)flag), (String)"flag");
        this.flags.add(flag);
        return this;
    }

    @NotNull
    public final EvalContext clearFlag(@NotNull EvalFlags flag) {
        Intrinsics.checkNotNullParameter((Object)((Object)flag), (String)"flag");
        this.flags.remove((Object)flag);
        return this;
    }

    public final boolean hasFlag(@NotNull EvalFlags flag) {
        Intrinsics.checkNotNullParameter((Object)((Object)flag), (String)"flag");
        return this.flags.contains((Object)flag);
    }

    public final boolean hasAny(@NotNull EnumSet<EvalFlags> flags) {
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        boolean result = false;
        for (EvalFlags flag : flags) {
            if (!this.flags.contains((Object)flag)) continue;
            result = true;
            break;
        }
        return result;
    }

    @NotNull
    public final EvalContext setProp(@NotNull String propName, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)propName, (String)"propName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.props.setProperty(propName, value);
        return this;
    }

    @NotNull
    public final String getProp(@NotNull String propName, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)propName, (String)"propName");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String string = this.props.getProperty(propName, defaultValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"props.getProperty(propName, defaultValue)");
        return string;
    }

    @Nullable
    public final String getProp(@NotNull String propName) {
        Intrinsics.checkNotNullParameter((Object)propName, (String)"propName");
        return this.props.getProperty(propName);
    }

    @NotNull
    public final Set<String> getPropKeys() {
        Set<String> set = this.props.stringPropertyNames();
        Intrinsics.checkNotNullExpressionValue(set, (String)"props.stringPropertyNames()");
        return set;
    }

    @NotNull
    public final EvalContext duplicate() {
        EnumSet<EvalFlags> enumSet = EnumSet.copyOf(this.flags);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"copyOf(this.flags)");
        return new EvalContext(this.userInfo, enumSet, new Properties(this.props));
    }

    @JvmOverloads
    public EvalContext(@NotNull UserInfo userInfo, @NotNull EnumSet<EvalFlags> flags) {
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        this(userInfo, flags, null, 4, null);
    }

    @JvmOverloads
    public EvalContext(@NotNull UserInfo userInfo) {
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        this(userInfo, null, null, 6, null);
    }

    @JvmOverloads
    public EvalContext() {
        this(null, null, null, 7, null);
    }
}

