/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.catalog;

import com.interlocsolutions.maximo.notify.queue.catalog.CatalogPartitioner;
import com.interlocsolutions.maximo.notify.util.MboUtilKt;
import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.util.MXException;

public class CatalogPartitioners {
    private static final CatalogPartitioner PARTITIONER_NONE = new CatalogPartitioner(){

        @Override
        public String determineCatalogPartition(@NotNull MboRemote mbo) {
            return null;
        }

        @Override
        public boolean validForObject(@NotNull String objectName) {
            return true;
        }
    };

    public static CatalogPartitioner defaultPartitioner() {
        return PARTITIONER_NONE;
    }

    public static CatalogPartitioner forAttribute(@NotNull String attributeName) {
        return new PartitionByAttr(attributeName);
    }

    private static class PartitionByAttr
    implements CatalogPartitioner {
        private final String attributeName;

        public PartitionByAttr(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public String determineCatalogPartition(@NotNull MboRemote mbo) throws RemoteException, MXException {
            return mbo.getString(this.attributeName);
        }

        @Override
        public boolean validForObject(@NotNull String objectName) throws RemoteException, MXException {
            return MboUtilKt.getNaryMboValueInfo(objectName, this.attributeName) != null;
        }
    }
}

