/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue.catalog;

import com.interlocsolutions.maximo.notify.Catalog;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogDeletionEvaluatorCronTask;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobDispatcher;
import com.interlocsolutions.maximo.notify.queue.catalog.JobEval;
import com.interlocsolutions.maximo.notify.queue.db.JobFactory;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.ImmutableLongSet;
import com.interlocsolutions.maximo.notify.util.JDBCExtensionsKt;
import com.interlocsolutions.maximo.notify.util.MboUtilKt;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.TimeReporter;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionAccessor;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MaximoDD;
import psdi.mbo.MboSetInfo;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.server.SimpleCronTask;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/catalog/CatalogDeletionEvaluatorCronTask;", "Lpsdi/server/SimpleCronTask;", "()V", "logger", "Lpsdi/util/logging/MXLogger;", "kotlin.jvm.PlatformType", "cronAction", "", "isinformer"})
public final class CatalogDeletionEvaluatorCronTask
extends SimpleCronTask {
    private final MXLogger logger = this.getCronTaskLogger();

    public void cronAction() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.javaClass.simpleName");
        TimeReporter tracker = new TimeReporter(string);
        List catInfoList2 = (List)tracker.measured("CatalogInfo", "InformerCache", cronAction.catInfoList.1.INSTANCE);
        if (!CollectionsKt.any((Iterable)catInfoList2)) {
            MXLogger mXLogger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            MXLogger $this$debugLazy_u24default$iv = mXLogger;
            Object e$iv = null;
            boolean $i$f$debugLazy = false;
            if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
                Object object;
                try {
                    boolean bl = false;
                    object = Result.constructor-impl((Object)("There is not any catalog with " + (Object)((Object)Catalog.Strategy.MONITORING) + " strategy."));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string2 = "(Unable to form error msg)";
                String msg$iv = (String)(Result.isFailure-impl((Object)object) ? string2 : object);
                $this$debugLazy_u24default$iv.debug((Object)msg$iv);
            }
            return;
        }
        DbConnectionAccessor maximoConnection = DbConnectionManager.getInstance().getMaximoConnection();
        MaximoDD maximoDD = MXServer.getMXServer().getMaximoDD();
        Collection<String> supportedLanguages = NotifyUtil.getLangCodes();
        JobDispatcher jobDispatcher = JobConfig.getInstance().getJobDispatcherInstance();
        Intrinsics.checkNotNullExpressionValue((Object)jobDispatcher, (String)"getInstance().jobDispatcherInstance");
        JobDispatcher jobDispatcher2 = jobDispatcher;
        JobFactory jobFactory = JobConfig.getInstance().getJobFactoryInstance();
        Intrinsics.checkNotNullExpressionValue((Object)jobFactory, (String)"getInstance().jobFactoryInstance");
        JobFactory jobFactory2 = jobFactory;
        UserInfo userInfo = this.getRunasUserInfo();
        Intrinsics.checkNotNullExpressionValue((Object)userInfo, (String)"runasUserInfo");
        EvalContext evalContext = new EvalContext(userInfo, null, null, 6, null).setFlag(EvalFlags.SCHEDULED);
        for (CachedCatalog catInfo : catInfoList2) {
            String catalogLabel = catInfo.notifyNum + ':' + catInfo.catalogName;
            ImmutableLongSet missingRecordIds2 = (ImmutableLongSet)tracker.measured(catalogLabel, "Identify Deleted", (Function0)new Function0<ImmutableLongSet>(maximoDD, catInfo, maximoConnection){
                final /* synthetic */ MaximoDD $maximoDD;
                final /* synthetic */ CachedCatalog $catInfo;
                final /* synthetic */ DbConnectionAccessor $maximoConnection;
                {
                    this.$maximoDD = $maximoDD;
                    this.$catInfo = $catInfo;
                    this.$maximoConnection = $maximoConnection;
                    super(0);
                }

                @NotNull
                public final ImmutableLongSet invoke() {
                    MboSetInfo mboSetInfo = this.$maximoDD.getMboSetInfo(this.$catInfo.objectName);
                    return (ImmutableLongSet)this.$maximoConnection.useConn((Function1)new Function1<Connection, ImmutableLongSet>(mboSetInfo, this.$catInfo){
                        final /* synthetic */ MboSetInfo $mboSetInfo;
                        final /* synthetic */ CachedCatalog $catInfo;
                        {
                            this.$mboSetInfo = $mboSetInfo;
                            this.$catInfo = $catInfo;
                            super(1);
                        }

                        @NotNull
                        public final ImmutableLongSet invoke(@NotNull Connection conn) {
                            Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                            StringBuilder stringBuilder = new StringBuilder().append("\n                            SELECT DISTINCT recordid\n                            FROM iscatalogdata\n                            WHERE catalogid = ? AND revision = ? AND langcode = ? AND inscope = 1\n                            AND recordid NOT IN (\n                                SELECT ");
                            MboSetInfo mboSetInfo = this.$mboSetInfo;
                            Intrinsics.checkNotNullExpressionValue((Object)mboSetInfo, (String)"mboSetInfo");
                            String string = StringsKt.trimIndent((String)stringBuilder.append(MboUtilKt.getUniqueColumnName(mboSetInfo)).append("\n                                FROM ").append(this.$mboSetInfo.getEntityName()).append("\n                            )\n                            ").toString());
                            Object[] objectArray = new Object[3];
                            objectArray[0] = this.$catInfo.catalogId;
                            objectArray[1] = this.$catInfo.catalogRevision;
                            Intrinsics.checkNotNullExpressionValue((Object)MXServer.getMXServer().getBaseLang(), (String)"getMXServer().baseLang");
                            return JDBCExtensionsKt.collectUniqueLongs((Connection)conn, (String)string, (Object[])objectArray);
                        }
                    });
                }
            });
            if (missingRecordIds2.isEmpty()) continue;
            tracker.measured(catalogLabel, catInfo.dispatch ? "Request Removal" : "Remove Deleted", (Function0)new Function0<Unit>(missingRecordIds2, supportedLanguages, catInfo, this, jobDispatcher2, evalContext, jobFactory2){
                final /* synthetic */ ImmutableLongSet $missingRecordIds;
                final /* synthetic */ Collection<String> $supportedLanguages;
                final /* synthetic */ CachedCatalog $catInfo;
                final /* synthetic */ CatalogDeletionEvaluatorCronTask this$0;
                final /* synthetic */ JobDispatcher $jobDispatcher;
                final /* synthetic */ EvalContext $evalContext;
                final /* synthetic */ JobFactory $jobFactory;
                {
                    this.$missingRecordIds = $missingRecordIds;
                    this.$supportedLanguages = $supportedLanguages;
                    this.$catInfo = $catInfo;
                    this.this$0 = $receiver;
                    this.$jobDispatcher = $jobDispatcher;
                    this.$evalContext = $evalContext;
                    this.$jobFactory = $jobFactory;
                    super(0);
                }

                public final void invoke() {
                    Object $this$infoLazy_u24default$iv;
                    Object e$iv;
                    ImmutableLongSet immutableLongSet;
                    Object object;
                    List jobSpecs = new ArrayList<E>();
                    for (Long recordId : this.$missingRecordIds) {
                        for (String langCode : this.$supportedLanguages) {
                            Collection collection = jobSpecs;
                            long l = this.$catInfo.catalogId;
                            long l2 = this.$catInfo.catalogRevision;
                            Intrinsics.checkNotNullExpressionValue((Object)recordId, (String)"recordId");
                            collection.add(new JobEval.JobSpecEval(l, l2, (long)recordId, langCode));
                        }
                    }
                    if (this.$catInfo.dispatch) {
                        String msg$iv;
                        Object object2;
                        MXLogger mXLogger = CatalogDeletionEvaluatorCronTask.access$getLogger$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
                        Iterator iterator = mXLogger;
                        object = this.this$0;
                        immutableLongSet = this.$missingRecordIds;
                        e$iv = null;
                        boolean $i$f$infoLazy = false;
                        if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                            try {
                                boolean bl = false;
                                object2 = Result.constructor-impl((Object)(object.getClass().getName() + " found " + immutableLongSet.size() + " records deleted from the MBO table. Processing will be dispatched."));
                            }
                            catch (Throwable bl) {
                                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                            }
                            String bl = "(Unable to form error msg)";
                            msg$iv = (String)(Result.isFailure-impl((Object)object2) ? bl : object2);
                            $this$infoLazy_u24default$iv.info((Object)msg$iv);
                        }
                        this.$jobDispatcher.doEvals(this.$evalContext.duplicate(), jobSpecs);
                        MXLogger mXLogger2 = CatalogDeletionEvaluatorCronTask.access$getLogger$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)mXLogger2, (String)"logger");
                        $this$infoLazy_u24default$iv = mXLogger2;
                        object = this.this$0;
                        immutableLongSet = this.$missingRecordIds;
                        e$iv = null;
                        $i$f$infoLazy = false;
                        if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                            try {
                                boolean bl = false;
                                object2 = Result.constructor-impl((Object)(object.getClass().getName() + " dispatched " + immutableLongSet.size() + " records deleted from the MBO table. Processing complete."));
                            }
                            catch (Throwable bl) {
                                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                            }
                            String bl = "(Unable to form error msg)";
                            msg$iv = (String)(Result.isFailure-impl((Object)object2) ? bl : object2);
                            $this$infoLazy_u24default$iv.info((Object)msg$iv);
                        }
                    } else {
                        String msg$iv;
                        Object object3;
                        MXLogger mXLogger = CatalogDeletionEvaluatorCronTask.access$getLogger$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
                        $this$infoLazy_u24default$iv = mXLogger;
                        object = this.this$0;
                        immutableLongSet = this.$missingRecordIds;
                        e$iv = null;
                        boolean $i$f$infoLazy = false;
                        if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                            try {
                                boolean bl = false;
                                object3 = Result.constructor-impl((Object)(object.getClass().getName() + " found " + immutableLongSet.size() + " records deleted from the MBO table. Processing begins."));
                            }
                            catch (Throwable bl) {
                                object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                            }
                            String bl = "(Unable to form error msg)";
                            msg$iv = (String)(Result.isFailure-impl((Object)object3) ? bl : object3);
                            $this$infoLazy_u24default$iv.info((Object)msg$iv);
                        }
                        for (JobEval.JobSpecEval jobSpec : jobSpecs) {
                            this.$jobFactory.instantiateJobEval(this.$evalContext.duplicate(), jobSpec).invoke();
                        }
                        MXLogger mXLogger3 = CatalogDeletionEvaluatorCronTask.access$getLogger$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)mXLogger3, (String)"logger");
                        $this$infoLazy_u24default$iv = mXLogger3;
                        object = this.this$0;
                        immutableLongSet = this.$missingRecordIds;
                        e$iv = null;
                        $i$f$infoLazy = false;
                        if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                            try {
                                boolean bl = false;
                                object3 = Result.constructor-impl((Object)(object.getClass().getName() + " processed " + immutableLongSet.size() + " records deleted from the MBO table. Processing complete."));
                            }
                            catch (Throwable throwable) {
                                object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            }
                            String string = "(Unable to form error msg)";
                            msg$iv = (String)(Result.isFailure-impl((Object)object3) ? string : object3);
                            $this$infoLazy_u24default$iv.info((Object)msg$iv);
                        }
                    }
                }
            });
        }
        String report = TimeReporter.report$default(tracker, null, null, 3, null);
        MXLogger mXLogger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
        MXLogger $this$infoLazy_u24default$iv = mXLogger;
        Object e$iv = null;
        boolean $i$f$infoLazy = false;
        if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
            Object object;
            try {
                boolean bl = false;
                object = Result.constructor-impl((Object)report);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            String string3 = "(Unable to form error msg)";
            String msg$iv = (String)(Result.isFailure-impl((Object)object) ? string3 : object);
            $this$infoLazy_u24default$iv.info((Object)msg$iv);
        }
    }

    public static final /* synthetic */ MXLogger access$getLogger$p(CatalogDeletionEvaluatorCronTask $this) {
        return $this.logger;
    }
}

