/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.queue;

import com.interlocsolutions.maximo.notify.queue.QueueProcessor;
import com.interlocsolutions.maximo.notify.util.InformerThreadGroup;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\bH$J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H$J\b\u0010\u0012\u001a\u00020\u0011H$J\b\u0010\u0013\u001a\u00020\bH$J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J&\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001cH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/AbstractQueueProcessor;", "Lcom/interlocsolutions/maximo/notify/queue/QueueProcessor;", "logger", "Lpsdi/util/logging/MXLogger;", "(Lpsdi/util/logging/MXLogger;)V", "getLogger", "()Lpsdi/util/logging/MXLogger;", "started", "", "getStarted", "()Z", "setStarted", "(Z)V", "determineShutdown", "isShutdown", "isStarted", "performProcess", "", "performShutdown", "performStartup", "process", "shutdown", "startup", "waitForThread", "operation", "", "name", "isActive", "Lkotlin/Function0;", "InformerThreadFactory", "isinformer"})
public abstract class AbstractQueueProcessor
implements QueueProcessor {
    @NotNull
    private final MXLogger logger;
    private boolean started;

    public AbstractQueueProcessor(@NotNull MXLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
    }

    @NotNull
    protected final MXLogger getLogger() {
        return this.logger;
    }

    protected final boolean getStarted() {
        return this.started;
    }

    protected final void setStarted(boolean bl) {
        this.started = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        AbstractQueueProcessor abstractQueueProcessor = this;
        synchronized (abstractQueueProcessor) {
            boolean bl = false;
            if (!this.started) {
                this.logger.info((Object)("Starting up queue processor " + this.getClass().getSimpleName() + '.'));
                if (this.performStartup()) {
                    this.started = true;
                    this.logger.info((Object)("Started up queue processor " + this.getClass().getSimpleName() + '.'));
                } else {
                    this.logger.info((Object)("Failed to start queue processor " + this.getClass().getSimpleName() + '.'));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStarted() {
        AbstractQueueProcessor abstractQueueProcessor = this;
        synchronized (abstractQueueProcessor) {
            boolean bl = false;
            boolean bl2 = this.started;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        AbstractQueueProcessor abstractQueueProcessor = this;
        synchronized (abstractQueueProcessor) {
            boolean bl = false;
            boolean bl2 = !this.started || this.determineShutdown();
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        AbstractQueueProcessor abstractQueueProcessor = this;
        synchronized (abstractQueueProcessor) {
            boolean bl = false;
            if (this.isStarted()) {
                this.logger.info((Object)("Shutting down queue processor " + this.getClass().getSimpleName() + '.'));
                this.performShutdown();
                this.started = false;
                this.logger.info((Object)("Shut down queue processor " + this.getClass().getSimpleName() + '.'));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void process() {
        if (this.isStarted()) {
            this.performProcess();
        }
    }

    protected abstract boolean performStartup();

    protected abstract void performShutdown();

    protected abstract void performProcess();

    protected abstract boolean determineShutdown();

    protected final void waitForThread(@NotNull String operation, @NotNull String name, @NotNull Function0<Boolean> isActive) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(isActive, (String)"isActive");
        long startTime = System.currentTimeMillis();
        while (((Boolean)isActive.invoke()).booleanValue()) {
            Thread.yield();
            if (System.currentTimeMillis() - startTime <= 300000L) continue;
            this.logger.warn((Object)("Unable to " + operation + ' ' + name + " of " + this.getClass().getSimpleName() + " queue processor within 300000 milliseconds."));
            break;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/interlocsolutions/maximo/notify/queue/AbstractQueueProcessor$InformerThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "threadPrefix", "", "(Ljava/lang/String;)V", "nextThreadNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "newThread", "Ljava/lang/Thread;", "runnable", "Ljava/lang/Runnable;", "isinformer"})
    protected static final class InformerThreadFactory
    implements ThreadFactory {
        @NotNull
        private final String threadPrefix;
        @NotNull
        private final AtomicInteger nextThreadNumber;

        public InformerThreadFactory(@NotNull String threadPrefix) {
            Intrinsics.checkNotNullParameter((Object)threadPrefix, (String)"threadPrefix");
            this.threadPrefix = threadPrefix;
            this.nextThreadNumber = new AtomicInteger(0);
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable runnable) {
            Thread thread;
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            Thread $this$newThread_u24lambda_u240 = thread = new Thread(InformerThreadGroup.getInformerThreadGroup(), runnable, this.threadPrefix + '-' + this.nextThreadNumber.getAndIncrement());
            boolean bl = false;
            $this$newThread_u24lambda_u240.setDaemon(true);
            $this$newThread_u24lambda_u240.setPriority(1);
            return thread;
        }
    }
}

