/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.push;

import com.interlocsolutions.maximo.notify.PushDevice;
import com.interlocsolutions.maximo.notify.PushReg;
import com.interlocsolutions.maximo.notify.push.PushProvider;
import com.interlocsolutions.maximo.notify.push.PushQueueJob;
import com.interlocsolutions.maximo.notify.push.PushQueueManager;
import com.interlocsolutions.maximo.notify.push.PushRegistry;
import com.interlocsolutions.maximo.notify.util.InformerTracking;
import com.interlocsolutions.maximo.notify.util.MboExtensionsKt;
import com.interlocsolutions.maximo.notify.util.MboSetRemoteClosableWrapper;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JA\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/interlocsolutions/maximo/notify/push/PushJobQueueEvaluator;", "", "logger", "Lpsdi/util/logging/MXLogger;", "(Lpsdi/util/logging/MXLogger;)V", "doFullCatalogPush", "", "userInfo", "Lpsdi/security/UserInfo;", "notifynum", "", "catalogName", "partitionName", "langCode", "trackingId", "", "(Lpsdi/security/UserInfo;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;)V", "evaluate", "job", "Lcom/interlocsolutions/maximo/notify/push/PushQueueJob;", "isinformer"})
public final class PushJobQueueEvaluator {
    @NotNull
    private final MXLogger logger;

    public PushJobQueueEvaluator(@NotNull MXLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
    }

    public final void evaluate(@NotNull PushQueueJob job) {
        boolean deviceFound;
        Long l;
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Long l2 = job.getTrackingId();
        if (l2 != null) {
            Long l3 = l2;
            long it = ((Number)l3).longValue();
            boolean bl = false;
            l = it > 0L ? l3 : null;
        } else {
            l = null;
        }
        Long trackingId = l;
        UserInfo sysUserInfo = MXServer.getMXServer().getSystemUserInfo();
        boolean bl = deviceFound = job.getPushDeviceId() != null && MboUtil.visitSingleMbo(sysUserInfo, "ISPUSHDEVICE", job.getPushDeviceId(), arg_0 -> PushJobQueueEvaluator.evaluate$lambda$13(job, sysUserInfo, trackingId, arg_0));
        if (!deviceFound) {
            if (job.getType() == PushQueueManager.PushType.CATALOG) {
                Intrinsics.checkNotNullExpressionValue((Object)sysUserInfo, (String)"sysUserInfo");
                String string = job.getProfileName();
                Intrinsics.checkNotNull((Object)string);
                String string2 = job.getCatalogName();
                Intrinsics.checkNotNull((Object)string2);
                String string3 = job.getPartitionName();
                String string4 = job.getLangCode();
                Intrinsics.checkNotNull((Object)string4);
                this.doFullCatalogPush(sysUserInfo, string, string2, string3, string4, trackingId);
            } else {
                this.logger.warn((Object)("Unable to push message to device id  " + job.getPushDeviceId() + ", device not found."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void doFullCatalogPush(UserInfo userInfo, String notifynum, String catalogName, String partitionName, String langCode, Long trackingId) {
        MboSetRemote $this$use$iv = MboExtensionsKt.getNewMboSet$default("ISPUSHREG", null, userInfo, true, 2, null);
        boolean $i$f$use = false;
        Closeable closeable = new MboSetRemoteClosableWrapper($this$use$iv);
        Throwable throwable = null;
        try {
            void $this$doFullCatalogPush_u24lambda_u2416_u24lambda_u2414;
            SqlFormat sqlFormat;
            MboSetRemoteClosableWrapper it$iv = (MboSetRemoteClosableWrapper)closeable;
            boolean bl = false;
            MboSetRemote pushRegSet = $this$use$iv;
            boolean bl2 = false;
            SqlFormat sqlFormat2 = sqlFormat = new SqlFormat("NOTIFYID IN (SELECT NOTIFYID FROM ISNOTIFY WHERE NOTIFYNUM = :1)");
            MboSetRemote mboSetRemote = pushRegSet;
            boolean bl3 = false;
            $this$doFullCatalogPush_u24lambda_u2416_u24lambda_u2414.setObject(1, "ISNOTIFY", "NOTIFYNUM", notifynum);
            mboSetRemote.setWhere(sqlFormat.format());
            pushRegSet.reset();
            MboSetRemote $this$forEach$iv = pushRegSet;
            boolean $i$f$forEach = false;
            Sequence<MboRemote> $this$forEach$iv$iv = MboExtensionsKt.asSequence($this$forEach$iv);
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                MboRemote pushReg2 = (MboRemote)element$iv$iv;
                boolean bl4 = false;
                int deviceCount = pushReg2.getMboSet("DEVICE").count();
                if (deviceCount <= 0) continue;
                Intrinsics.checkNotNull((Object)pushReg2, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.PushReg");
                PushProvider pushProvide = PushRegistry.INSTANCE.getPushProvider((PushReg)pushReg2);
                pushProvide.pushCatalog(notifynum, catalogName, partitionName, langCode, trackingId);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void evaluate$lambda$13$lambda$2(Long $trackingId, PushDevice $pushDevice, PushQueueJob $job, MboRemote triggerMbo) {
        Intrinsics.checkNotNullParameter((Object)$pushDevice, (String)"$pushDevice");
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        Intrinsics.checkNotNullParameter((Object)triggerMbo, (String)"triggerMbo");
        Long l = $trackingId;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            InformerTracking.pushSent(it);
        }
        $pushDevice.sendNotificationPush(triggerMbo, $job.getProfileName(), $trackingId);
    }

    private static final void evaluate$lambda$13(PushQueueJob $job, UserInfo $sysUserInfo, Long $trackingId, MboRemote mboRemote) {
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        Intrinsics.checkNotNullParameter((Object)mboRemote, (String)"mboRemote");
        PushDevice pushDevice = (PushDevice)mboRemote;
        switch (WhenMappings.$EnumSwitchMapping$0[$job.getType().ordinal()]) {
            case 1: {
                if ($job.getTriggerObjectName() != null) {
                    String string = $job.getTriggerObjectName();
                    Long l = $job.getTriggerObjectId();
                    Intrinsics.checkNotNull((Object)l);
                    MboUtil.visitSingleMbo($sysUserInfo, string, l, arg_0 -> PushJobQueueEvaluator.evaluate$lambda$13$lambda$2($trackingId, pushDevice, $job, arg_0));
                    break;
                }
                Long l = $trackingId;
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl = false;
                    InformerTracking.pushSent(it);
                }
                pushDevice.sendNotificationPush(null, $job.getProfileName(), $trackingId);
                break;
            }
            case 2: {
                Long l = $trackingId;
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl = false;
                    InformerTracking.pushSent(it);
                }
                String string = $job.getProfileName();
                Intrinsics.checkNotNull((Object)string);
                String string2 = $job.getCatalogName();
                Intrinsics.checkNotNull((Object)string2);
                String string3 = $job.getLangCode();
                Intrinsics.checkNotNull((Object)string3);
                pushDevice.sendCatalogPush(string, string2, string3, $job.getPartitionName(), $trackingId);
                break;
            }
            case 3: {
                Long l = $trackingId;
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl = false;
                    InformerTracking.pushSent(it);
                }
                pushDevice.pushBlockRequest($trackingId);
                break;
            }
            case 4: {
                Long l = $trackingId;
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl = false;
                    InformerTracking.pushSent(it);
                }
                pushDevice.pushInstrumentRequest($trackingId);
                break;
            }
            case 5: {
                Long l = $trackingId;
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl = false;
                    InformerTracking.pushSent(it);
                }
                pushDevice.pushLogRequest($trackingId);
                break;
            }
            case 6: {
                Long l = $trackingId;
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl = false;
                    InformerTracking.pushSent(it);
                }
                pushDevice.pushLogLevelRequest($trackingId);
                break;
            }
            case 7: {
                Long l = $trackingId;
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl = false;
                    InformerTracking.pushSent(it);
                }
                pushDevice.pushScreenShotRequest($trackingId);
                break;
            }
            case 8: {
                Long l = $trackingId;
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl = false;
                    InformerTracking.pushSent(it);
                }
                pushDevice.pushTestMessage($trackingId);
                break;
            }
            case 9: {
                Long l = $trackingId;
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl = false;
                    InformerTracking.pushSent(it);
                }
                pushDevice.pushWipeRequest($trackingId);
                break;
            }
            case 10: {
                Long l = $trackingId;
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl = false;
                    InformerTracking.pushSent(it);
                }
                pushDevice.pushErrorResolved($trackingId);
                break;
            }
            case 11: {
                String string = $job.getCatalogName();
                Intrinsics.checkNotNull((Object)string);
                pushDevice.pushTopicRegistration(string, $job.getPartitionName());
                break;
            }
            case 12: {
                String string = $job.getCatalogName();
                Intrinsics.checkNotNull((Object)string);
                pushDevice.pushTopicUnregistration(string, $job.getPartitionName());
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PushQueueManager.PushType.values().length];
            try {
                nArray[PushQueueManager.PushType.NOTIFICATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushQueueManager.PushType.CATALOG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushQueueManager.PushType.BLOCK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushQueueManager.PushType.INSTRUMENTATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushQueueManager.PushType.LOG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushQueueManager.PushType.LOG_LEVEL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushQueueManager.PushType.SCREENSHOT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushQueueManager.PushType.TEST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushQueueManager.PushType.WIPE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushQueueManager.PushType.ERROR_RESOLVED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushQueueManager.PushType.TOPIC_REG.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushQueueManager.PushType.TOPIC_UNREG.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

