/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.push;

import com.interlocsolutions.maximo.notify.push.BulkByJvmPushReaderSql;
import com.interlocsolutions.maximo.notify.queue.DatabaseFunctionsKt;
import java.sql.Connection;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/interlocsolutions/maximo/notify/push/DB2ReaderSql;", "Lcom/interlocsolutions/maximo/notify/push/BulkByJvmPushReaderSql;", "()V", "handleException", "", "exception", "Ljava/sql/SQLException;", "lock", "", "connection", "Ljava/sql/Connection;", "lockName", "", "selectionSql", "batchSize", "", "orderBy", "unlock", "isinformer"})
public final class DB2ReaderSql
extends BulkByJvmPushReaderSql {
    @Override
    @NotNull
    public String selectionSql(int batchSize, @NotNull String orderBy) {
        Intrinsics.checkNotNullParameter((Object)orderBy, (String)"orderBy");
        return StringsKt.trimIndent((String)("\n            SELECT *\n            FROM ispushqueue\n            WHERE inerror = 0 and active = 0\n            " + orderBy + "\n            FETCH FIRST " + batchSize + " ROWS ONLY\n            FOR UPDATE\n        "));
    }

    @Override
    public void lock(@NotNull Connection connection, @NotNull String lockName) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)lockName, (String)"lockName");
        DatabaseFunctionsKt.db2EnableNoWait(connection);
    }

    @Override
    public void unlock(@NotNull Connection connection, @NotNull String lockName) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)lockName, (String)"lockName");
        DatabaseFunctionsKt.db2DisableNoWait(connection);
    }

    @Override
    public boolean handleException(@NotNull SQLException exception) throws SQLException {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception.getErrorCode() == -911) {
            Thread.sleep(1000L);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }
}

