/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.push;

import com.interlocsolutions.maximo.notify.push.PushJobQueueEvaluator;
import com.interlocsolutions.maximo.notify.push.PushQueueJob;
import com.interlocsolutions.maximo.notify.push.PushQueueRepo;
import com.interlocsolutions.maximo.notify.queue.ProcessorKey;
import com.interlocsolutions.maximo.notify.queue.ProcessorKeyKt;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.InformerThreadIndefinite;
import com.interlocsolutions.maximo.notify.util.InformerTracking;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.ProcessorMonitorable;
import com.interlocsolutions.maximo.notify.util.ProcessorState;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.util.RuntimeInfo;
import java.rmi.RemoteException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0014J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0014J\b\u0010\u001a\u001a\u00020\u0012H\u0014J\b\u0010\u001b\u001a\u00020\u0012H\u0014R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/interlocsolutions/maximo/notify/push/BulkByThreadProcessor;", "Lcom/interlocsolutions/maximo/notify/util/InformerThreadIndefinite;", "Lcom/interlocsolutions/maximo/notify/util/ProcessorMonitorable;", "threadGroup", "Ljava/lang/ThreadGroup;", "pushQueueRepo", "Lcom/interlocsolutions/maximo/notify/push/PushQueueRepo;", "uniqueId", "", "(Ljava/lang/ThreadGroup;Lcom/interlocsolutions/maximo/notify/push/PushQueueRepo;I)V", "<set-?>", "Lcom/interlocsolutions/maximo/notify/util/ProcessorState;", "currentState", "getCurrentState", "()Lcom/interlocsolutions/maximo/notify/util/ProcessorState;", "getPushQueueRepo", "()Lcom/interlocsolutions/maximo/notify/push/PushQueueRepo;", "cleanUpTask", "", "getProcessorCategory", "", "getProcessorState", "getProcessorType", "initTask", "logAdditionalInformation", "onAdminModePause", "onIntervalPause", "runRecurringInformerTask", "isinformer"})
public final class BulkByThreadProcessor
extends InformerThreadIndefinite
implements ProcessorMonitorable {
    @NotNull
    private final PushQueueRepo pushQueueRepo;
    @NotNull
    private ProcessorState currentState;

    public BulkByThreadProcessor(@NotNull ThreadGroup threadGroup, @NotNull PushQueueRepo pushQueueRepo, int uniqueId) {
        Intrinsics.checkNotNullParameter((Object)threadGroup, (String)"threadGroup");
        Intrinsics.checkNotNullParameter((Object)pushQueueRepo, (String)"pushQueueRepo");
        super(threadGroup, "Informer-PushQueueProcessor-" + uniqueId, 10000L, false, true, NotifyConstants.INFORMER_LOGGER);
        this.pushQueueRepo = pushQueueRepo;
        this.currentState = ProcessorState.STARTING;
    }

    @NotNull
    public final PushQueueRepo getPushQueueRepo() {
        return this.pushQueueRepo;
    }

    @NotNull
    public final ProcessorState getCurrentState() {
        return this.currentState;
    }

    @Override
    protected void initTask() throws RemoteException, MXException, InformerThreadIndefinite.InformerTaskException {
        this.currentState = ProcessorState.INITIALIZING;
    }

    @Override
    protected void onIntervalPause() {
        super.onIntervalPause();
        this.currentState = ProcessorState.WAITING;
    }

    @Override
    protected void onAdminModePause() {
        super.onAdminModePause();
        this.currentState = ProcessorState.ADMINMODE;
    }

    @Override
    protected void cleanUpTask() {
    }

    @Override
    protected void runRecurringInformerTask() throws RemoteException, MXException, InformerThreadIndefinite.InformerTaskException {
        this.currentState = ProcessorState.RUNNING;
        RuntimeInfo runtimeInfo = RuntimeInfo.getRuntimeInfo();
        Intrinsics.checkNotNullExpressionValue((Object)runtimeInfo, (String)"runtimeInfo");
        ProcessorKey processorKey = ProcessorKeyKt.asProcessorKey(runtimeInfo);
        Object object = PropUtil.INSTANCE.getProp("informer.queue.maxerror");
        int maxErrorCount = object != null && (object = ((InformerProp)object).asInt()) != null ? (Integer)object : 5;
        Iterable $this$forEach$iv = this.pushQueueRepo.claimJobs(processorKey);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PushQueueJob job = (PushQueueJob)element$iv;
            boolean bl = false;
            try {
                PushJobQueueEvaluator pushJobQueueEvaluator;
                MXLogger mXLogger = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
                PushJobQueueEvaluator $this$runRecurringInformerTask_u24lambda_u241_u24lambda_u240 = pushJobQueueEvaluator = new PushJobQueueEvaluator(mXLogger);
                boolean bl2 = false;
                $this$runRecurringInformerTask_u24lambda_u241_u24lambda_u240.evaluate(job);
                this.pushQueueRepo.reportSuccess(job);
            }
            catch (Throwable t) {
                this.logger.warn((Object)("Unable to push message to device id  " + job.getPushDeviceId() + ": " + t.getMessage()), t);
                String string = t.getMessage();
                if (string == null) {
                    string = t.getClass().getSimpleName();
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"t.message ?: t.javaClass.simpleName");
                this.pushQueueRepo.reportError(job, string);
            }
            if (job.getErrorCount() != 0 && job.getErrorCount() != maxErrorCount) continue;
            InformerTracking.pushStop(job.getQueueId());
        }
    }

    @Override
    @NotNull
    public ProcessorState getProcessorState() {
        return this.currentState;
    }

    @Override
    @NotNull
    public String getProcessorCategory() {
        return "PUSH.Q";
    }

    @Override
    @NotNull
    public String getProcessorType() {
        return "Push";
    }

    @Override
    public void logAdditionalInformation() {
    }
}

