/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.push;

import com.interlocsolutions.maximo.notify.push.BulkByJvmProcessor;
import com.interlocsolutions.maximo.notify.push.BulkByJvmPushReaderSqlKt;
import com.interlocsolutions.maximo.notify.push.PushQueueJob;
import com.interlocsolutions.maximo.notify.push.PushQueueManager;
import com.interlocsolutions.maximo.notify.push.PushQueueRepo;
import com.interlocsolutions.maximo.notify.queue.AbstractBulkByJvmReaderThread;
import com.interlocsolutions.maximo.notify.queue.AbstractBulkByJvmWriterThread;
import com.interlocsolutions.maximo.notify.queue.BulkByJvmReaderSql;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.JDBCExtensionsKt;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\u0006\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\fH\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0014\u00a8\u0006\u001f"}, d2={"Lcom/interlocsolutions/maximo/notify/push/BulkByJvmReaderThread;", "Lcom/interlocsolutions/maximo/notify/queue/AbstractBulkByJvmReaderThread;", "Lcom/interlocsolutions/maximo/notify/push/PushQueueJob;", "threadName", "", "readerQueue", "Ljava/util/concurrent/BlockingQueue;", "Ljava/lang/Runnable;", "writerQueue", "Lcom/interlocsolutions/maximo/notify/queue/AbstractBulkByJvmWriterThread$Payload;", "(Ljava/lang/String;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/BlockingQueue;)V", "claimRecord", "", "statement", "Ljava/sql/PreparedStatement;", "job", "resultSet", "Ljava/sql/ResultSet;", "cleanUpJobs", "getBatchSize", "", "getOrdering", "Lcom/interlocsolutions/maximo/notify/queue/BulkByJvmReaderSql$OrderBy;", "getProcessorCategory", "getReaderSql", "Lcom/interlocsolutions/maximo/notify/queue/BulkByJvmReaderSql;", "serverType", "Lcom/interlocsolutions/maximo/notify/util/db/DbServerType;", "newRunnable", "latch", "Ljava/util/concurrent/CountDownLatch;", "isinformer"})
public final class BulkByJvmReaderThread
extends AbstractBulkByJvmReaderThread<PushQueueJob> {
    public BulkByJvmReaderThread(@Nullable String threadName, @NotNull BlockingQueue<Runnable> readerQueue, @NotNull BlockingQueue<AbstractBulkByJvmWriterThread.Payload<PushQueueJob>> writerQueue) {
        Intrinsics.checkNotNullParameter(readerQueue, (String)"readerQueue");
        Intrinsics.checkNotNullParameter(writerQueue, (String)"writerQueue");
        MXLogger mXLogger = NotifyConstants.INFORMER_PUSH_LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"INFORMER_PUSH_LOGGER");
        super(threadName, readerQueue, writerQueue, "Push Queue Reader", "PUSH.Q", mXLogger);
    }

    @Override
    protected void cleanUpJobs() {
        PushQueueRepo.INSTANCE.freeActiveJobsFor(this.getProcessorKey());
    }

    @Override
    protected int getBatchSize() {
        Object object = PropUtil.INSTANCE.getProp("informer.push.queue.BatchSize");
        return RangesKt.coerceAtLeast((int)(object != null && (object = ((InformerProp)object).asInt()) != null ? ((Integer)object).intValue() : this.getDefaultBatchSize()), (int)1);
    }

    @Override
    @NotNull
    protected BulkByJvmReaderSql getReaderSql(@NotNull DbServerType serverType) {
        Intrinsics.checkNotNullParameter((Object)serverType, (String)"serverType");
        return BulkByJvmPushReaderSqlKt.newBulkByJvmReaderSql(serverType);
    }

    @Override
    @NotNull
    protected BulkByJvmReaderSql.OrderBy getOrdering() {
        return BulkByJvmReaderSql.OrderBy.FIFO;
    }

    @Override
    @NotNull
    protected PushQueueJob claimRecord(@NotNull ResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        long l = resultSet.getLong("pushqueueid");
        Long l2 = JDBCExtensionsKt.getNullableLong((ResultSet)resultSet, (String)"pushdeviceid");
        String string = resultSet.getString("notifynum");
        String string2 = resultSet.getString("catalog");
        String string3 = resultSet.getString("partitionname");
        String string4 = resultSet.getString("langcode");
        String string5 = resultSet.getString("pushtype");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"resultSet.getString(\"pushtype\")");
        PushQueueManager.PushType pushType = PushQueueManager.PushType.valueOf(string5);
        int n = resultSet.getInt("errorcount");
        Long l3 = JDBCExtensionsKt.getNullableLong((ResultSet)resultSet, (String)"trackingId");
        String string6 = resultSet.getString("triggerobject");
        Long l4 = JDBCExtensionsKt.getNullableLong((ResultSet)resultSet, (String)"triggerobjectid");
        return new PushQueueJob(l, pushType, l2, string, string2, string3, string4, n, string6, l4, l3);
    }

    @Override
    @NotNull
    public String getProcessorCategory() {
        return "PUSH.Q";
    }

    @Override
    protected void claimRecord(@NotNull PreparedStatement statement, @NotNull PushQueueJob job) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        statement.setString(1, this.getProcessorKey().getHost());
        statement.setString(2, this.getProcessorKey().getMxName());
        statement.setString(3, this.getProcessorKey().getThreadName());
        statement.setLong(4, job.getQueueId());
    }

    @Override
    @NotNull
    protected Runnable newRunnable(@NotNull PushQueueJob job, @NotNull CountDownLatch latch) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)latch, (String)"latch");
        return new BulkByJvmProcessor(job, this.getWriterQueue(), latch);
    }
}

