/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.push;

import com.interlocsolutions.maximo.notify.err.ErrorHandlerAccessor;
import com.interlocsolutions.maximo.notify.push.BulkByJvmReaderThread;
import com.interlocsolutions.maximo.notify.push.BulkByJvmWriterThread;
import com.interlocsolutions.maximo.notify.push.PushJobQueueProcessor;
import com.interlocsolutions.maximo.notify.push.PushQueueJob;
import com.interlocsolutions.maximo.notify.queue.AbstractBulkByJvmWriterThread;
import com.interlocsolutions.maximo.notify.queue.AbstractQueueProcessor;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0013H\u0014J\b\u0010\u0015\u001a\u00020\u0011H\u0014J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/interlocsolutions/maximo/notify/push/BulkByJvmPushJobQueueProcessor;", "Lcom/interlocsolutions/maximo/notify/queue/AbstractQueueProcessor;", "Lcom/interlocsolutions/maximo/notify/push/PushJobQueueProcessor;", "()V", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "readerQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Ljava/lang/Runnable;", "readerThread", "Lcom/interlocsolutions/maximo/notify/push/BulkByJvmReaderThread;", "writerQueue", "Lcom/interlocsolutions/maximo/notify/queue/AbstractBulkByJvmWriterThread$Payload;", "Lcom/interlocsolutions/maximo/notify/push/PushQueueJob;", "writerThread", "Lcom/interlocsolutions/maximo/notify/push/BulkByJvmWriterThread;", "determineShutdown", "", "performProcess", "", "performShutdown", "performStartup", "startQueues", "queues", "", "isinformer"})
public final class BulkByJvmPushJobQueueProcessor
extends AbstractQueueProcessor
implements PushJobQueueProcessor {
    private ThreadPoolExecutor executor;
    private LinkedBlockingQueue<Runnable> readerQueue;
    private LinkedBlockingQueue<AbstractBulkByJvmWriterThread.Payload<PushQueueJob>> writerQueue;
    private BulkByJvmReaderThread readerThread;
    private BulkByJvmWriterThread writerThread;

    public BulkByJvmPushJobQueueProcessor() {
        MXLogger mXLogger = NotifyConstants.INFORMER_PUSH_LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"INFORMER_PUSH_LOGGER");
        super(mXLogger);
    }

    @Override
    protected boolean performStartup() {
        boolean bl;
        Integer queues;
        InformerProp queueProp;
        InformerProp informerProp = queueProp = PropUtil.INSTANCE.getProp("informer.queue.pool.push");
        Integer n = queues = informerProp != null ? informerProp.asInt() : null;
        if (queues == null) {
            this.getLogger().warn((Object)("Queue size of " + queueProp + " is invalid.  Queue will not start."));
            bl = false;
        } else if (queues <= 0) {
            this.getLogger().warn((Object)("Queue size of " + queueProp + " is too small.  Queue will not start."));
            bl = false;
        } else if (queues > 1) {
            this.getLogger().warn((Object)("Queue size of " + queueProp + " is too large.  Queue will start with a queue size of 1."));
            this.startQueues(1);
            bl = true;
        } else {
            this.startQueues(queues);
            bl = true;
        }
        return bl;
    }

    @Override
    protected void performShutdown() {
        BulkByJvmReaderThread bulkByJvmReaderThread = this.readerThread;
        if (bulkByJvmReaderThread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"readerThread");
            bulkByJvmReaderThread = null;
        }
        bulkByJvmReaderThread.requestShutdown();
        this.waitForThread("shutdown", "readerThread", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ BulkByJvmPushJobQueueProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                BulkByJvmReaderThread bulkByJvmReaderThread = BulkByJvmPushJobQueueProcessor.access$getReaderThread$p(this.this$0);
                if (bulkByJvmReaderThread == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"readerThread");
                    bulkByJvmReaderThread = null;
                }
                return bulkByJvmReaderThread.isAlive();
            }
        }));
        ThreadPoolExecutor threadPoolExecutor = this.executor;
        if (threadPoolExecutor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
            threadPoolExecutor = null;
        }
        threadPoolExecutor.shutdownNow();
        this.waitForThread("shutdown", "Thread Pool Shutdown", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ BulkByJvmPushJobQueueProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                ThreadPoolExecutor threadPoolExecutor = BulkByJvmPushJobQueueProcessor.access$getExecutor$p(this.this$0);
                if (threadPoolExecutor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                    threadPoolExecutor = null;
                }
                return !threadPoolExecutor.isShutdown();
            }
        }));
        this.waitForThread("shutdown", "Thread Pool Termination", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ BulkByJvmPushJobQueueProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                ThreadPoolExecutor threadPoolExecutor = BulkByJvmPushJobQueueProcessor.access$getExecutor$p(this.this$0);
                if (threadPoolExecutor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                    threadPoolExecutor = null;
                }
                return !threadPoolExecutor.isTerminated();
            }
        }));
        BulkByJvmWriterThread bulkByJvmWriterThread = this.writerThread;
        if (bulkByJvmWriterThread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writerThread");
            bulkByJvmWriterThread = null;
        }
        bulkByJvmWriterThread.requestShutdown();
        this.waitForThread("shutdown", "writerThread", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ BulkByJvmPushJobQueueProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                BulkByJvmWriterThread bulkByJvmWriterThread = BulkByJvmPushJobQueueProcessor.access$getWriterThread$p(this.this$0);
                if (bulkByJvmWriterThread == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"writerThread");
                    bulkByJvmWriterThread = null;
                }
                return bulkByJvmWriterThread.isAlive();
            }
        }));
    }

    @Override
    protected void performProcess() {
        BulkByJvmReaderThread bulkByJvmReaderThread = this.readerThread;
        if (bulkByJvmReaderThread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"readerThread");
            bulkByJvmReaderThread = null;
        }
        bulkByJvmReaderThread.wake();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean determineShutdown() {
        BulkByJvmReaderThread bulkByJvmReaderThread = this.readerThread;
        if (bulkByJvmReaderThread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"readerThread");
            bulkByJvmReaderThread = null;
        }
        if (bulkByJvmReaderThread.isAlive()) return false;
        BulkByJvmWriterThread bulkByJvmWriterThread = this.writerThread;
        if (bulkByJvmWriterThread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writerThread");
            bulkByJvmWriterThread = null;
        }
        if (bulkByJvmWriterThread.isAlive()) return false;
        ThreadPoolExecutor threadPoolExecutor = this.executor;
        if (threadPoolExecutor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
            threadPoolExecutor = null;
        }
        if (!threadPoolExecutor.isShutdown()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void startQueues(int queues) {
        void $this$startQueues_u24lambda_u242;
        Object $this$startQueues_u24lambda_u241;
        Object $this$startQueues_u24lambda_u240;
        this.readerQueue = new LinkedBlockingQueue(queues);
        this.writerQueue = new LinkedBlockingQueue(queues * 2);
        LinkedBlockingQueue<AbstractBulkByJvmWriterThread.Payload<PushQueueJob>> linkedBlockingQueue = this.writerQueue;
        if (linkedBlockingQueue == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writerQueue");
            linkedBlockingQueue = null;
        }
        Object object = new BulkByJvmWriterThread("Informer-PushQueueProcessor-Writer", (BlockingQueue<AbstractBulkByJvmWriterThread.Payload<PushQueueJob>>)linkedBlockingQueue, new ErrorHandlerAccessor(NotifyConstants.INFORMER_PUSH_LOGGER, "informer.push.errorhandler"));
        BulkByJvmWriterThread bulkByJvmWriterThread = object;
        BulkByJvmPushJobQueueProcessor bulkByJvmPushJobQueueProcessor = this;
        boolean bl = false;
        ((Thread)$this$startQueues_u24lambda_u240).start();
        bulkByJvmPushJobQueueProcessor.writerThread = object;
        this.waitForThread("startup", "writerThread", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ BulkByJvmPushJobQueueProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                BulkByJvmWriterThread bulkByJvmWriterThread = BulkByJvmPushJobQueueProcessor.access$getWriterThread$p(this.this$0);
                if (bulkByJvmWriterThread == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"writerThread");
                    bulkByJvmWriterThread = null;
                }
                return !bulkByJvmWriterThread.isAlive();
            }
        }));
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = this.readerQueue;
        if (linkedBlockingQueue2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"readerQueue");
            linkedBlockingQueue2 = null;
        }
        $this$startQueues_u24lambda_u240 = object = new ThreadPoolExecutor(queues, queues, 1L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)linkedBlockingQueue2, new AbstractQueueProcessor.InformerThreadFactory("Informer-PushQueueProcessor"));
        bulkByJvmPushJobQueueProcessor = this;
        boolean bl2 = false;
        ((ThreadPoolExecutor)$this$startQueues_u24lambda_u241).prestartAllCoreThreads();
        bulkByJvmPushJobQueueProcessor.executor = object;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue3 = this.readerQueue;
        if (linkedBlockingQueue3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"readerQueue");
            linkedBlockingQueue3 = null;
        }
        BlockingQueue blockingQueue = linkedBlockingQueue3;
        LinkedBlockingQueue<AbstractBulkByJvmWriterThread.Payload<PushQueueJob>> linkedBlockingQueue4 = this.writerQueue;
        if (linkedBlockingQueue4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writerQueue");
            linkedBlockingQueue4 = null;
        }
        $this$startQueues_u24lambda_u241 = object = new BulkByJvmReaderThread("Informer-PushQueueProcessor-Reader", blockingQueue, (BlockingQueue<AbstractBulkByJvmWriterThread.Payload<PushQueueJob>>)linkedBlockingQueue4);
        bulkByJvmPushJobQueueProcessor = this;
        boolean bl3 = false;
        $this$startQueues_u24lambda_u242.start();
        bulkByJvmPushJobQueueProcessor.readerThread = object;
        this.waitForThread("startup", "readerThread", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ BulkByJvmPushJobQueueProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                BulkByJvmReaderThread bulkByJvmReaderThread = BulkByJvmPushJobQueueProcessor.access$getReaderThread$p(this.this$0);
                if (bulkByJvmReaderThread == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"readerThread");
                    bulkByJvmReaderThread = null;
                }
                return !bulkByJvmReaderThread.isAlive();
            }
        }));
    }

    public static final /* synthetic */ BulkByJvmReaderThread access$getReaderThread$p(BulkByJvmPushJobQueueProcessor $this) {
        return $this.readerThread;
    }

    public static final /* synthetic */ ThreadPoolExecutor access$getExecutor$p(BulkByJvmPushJobQueueProcessor $this) {
        return $this.executor;
    }

    public static final /* synthetic */ BulkByJvmWriterThread access$getWriterThread$p(BulkByJvmPushJobQueueProcessor $this) {
        return $this.writerThread;
    }
}

