/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.err;

import com.interlocsolutions.maximo.notify.err.ErrorHandler;
import com.interlocsolutions.maximo.notify.err.LoggingErrorHandler;
import com.interlocsolutions.maximo.notify.err.SuppressingErrorHandler;
import com.interlocsolutions.maximo.notify.util.InformerClassUtils;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import java.rmi.RemoteException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class ErrorHandlerAccessor {
    private String mErrorHandlerClass;
    private ErrorHandler mErrorHandler;
    private MXLogger mxLogger;
    private String mClassProperty;

    public ErrorHandlerAccessor(MXLogger mxLogger, String classProperty) {
        this.mClassProperty = classProperty;
        this.mxLogger = mxLogger;
    }

    public ErrorHandler getErrorHandler() {
        String errorHandler = PropUtils.getMaxProp(this.mClassProperty, null);
        if (errorHandler == null) {
            if (this.mErrorHandlerClass != null) {
                this.mErrorHandler = null;
            }
            this.mErrorHandlerClass = null;
        } else if (!errorHandler.equals(this.mErrorHandlerClass)) {
            this.mErrorHandlerClass = errorHandler;
            this.mErrorHandler = null;
        }
        if (this.mErrorHandler == null) {
            if (this.mErrorHandlerClass != null) {
                try {
                    this.mErrorHandler = (ErrorHandler)InformerClassUtils.loadClass(this.mErrorHandlerClass).newInstance();
                }
                catch (InstantiationException e) {
                    this.mxLogger.warn((Object)"Failed to resolve intended ErrorHandler", (Throwable)e);
                    this.mErrorHandlerClass = null;
                    this.mErrorHandler = null;
                }
                catch (IllegalAccessException e) {
                    this.mxLogger.warn((Object)"Failed to resolve intended ErrorHandler", (Throwable)e);
                    this.mErrorHandlerClass = null;
                    this.mErrorHandler = null;
                }
                catch (ClassNotFoundException e) {
                    this.mxLogger.warn((Object)"Failed to resolve intended ErrorHandler", (Throwable)e);
                    this.mErrorHandlerClass = null;
                    this.mErrorHandler = null;
                }
                catch (RemoteException e) {
                    this.mxLogger.warn((Object)"Failed to resolve intended ErrorHandler", (Throwable)e);
                    this.mErrorHandlerClass = null;
                    this.mErrorHandler = null;
                }
                catch (MXException e) {
                    this.mxLogger.warn((Object)"Failed to resolve intended ErrorHandler", (Throwable)e);
                    this.mErrorHandlerClass = null;
                    this.mErrorHandler = null;
                }
            }
            if (this.mErrorHandler == null) {
                boolean logError = PropUtils.getBooleanMaxProp("informer.queue.logError", false);
                this.mErrorHandler = logError ? new LoggingErrorHandler(this.mxLogger) : new SuppressingErrorHandler(this.mxLogger);
            }
        }
        return this.mErrorHandler;
    }
}

