/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.commands;

import com.interlocsolutions.maximo.notify.commands.BasicCommand;
import com.interlocsolutions.maximo.notify.util.MaximoVersion;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import java.rmi.RemoteException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.MXRowUpdateException;
import psdi.util.logging.MXLogger;

public abstract class SimplifiedCommand
extends BasicCommand {
    public static final MXLogger LOGGER = NotifyConstants.INFORMER_LOGGER;
    private UserInfo systemUserInfo;
    private UserInfo userInfo;
    private Deque<MboSetRemote> trackedMboSets;
    private int maxRetryCount = 3;
    private int sleepTimeMsBetweenAttempts = 1000;

    @Override
    public final String execute() throws NotifyFault {
        boolean success = false;
        int executionCount = 0;
        int maxRetryCount = this.getMaxRetryCount();
        String result = null;
        while (!success) {
            try {
                result = this.execute(this.getUserInfo());
                success = true;
            }
            catch (MXRowUpdateException e) {
                if (++executionCount == maxRetryCount) {
                    throw new NotifyFault((MXException)((Object)e));
                }
                try {
                    Thread.sleep(this.getSleepTimeMsBetweenAttempts());
                }
                catch (InterruptedException e1) {
                    LOGGER.error((Object)"Interrupted while pausing between modification attempts", (Throwable)e1);
                    throw new NotifyFault(e1);
                }
            }
            catch (NotifyFault e) {
                throw e;
            }
            catch (RemoteException e) {
                throw new NotifyFault(e);
            }
            catch (MXException e) {
                throw new NotifyFault(e);
            }
            catch (RuntimeException e) {
                throw new NotifyFault(e);
            }
            finally {
                MboSetRemote someSet;
                if (this.trackedMboSets == null) continue;
                while ((someSet = this.trackedMboSets.pollLast()) != null) {
                    try {
                        someSet.cleanup();
                        someSet.clear();
                    }
                    catch (MXException e) {
                        LOGGER.error((Object)"Failed to release managed MboSet", (Throwable)e);
                    }
                    catch (RemoteException e) {
                        LOGGER.error((Object)"Failed to release managed MboSet", (Throwable)e);
                    }
                    catch (RuntimeException e) {
                        LOGGER.error((Object)"Failed to release managed MboSet", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    @Nullable
    protected abstract String execute(@NotNull UserInfo var1) throws NotifyFault, MXException, RemoteException;

    @NotNull
    protected UserInfo getSystemUserInfo() throws RemoteException, MXException {
        if (this.systemUserInfo == null) {
            this.systemUserInfo = MXServer.getMXServer().getSystemUserInfo();
        }
        return this.systemUserInfo;
    }

    @NotNull
    protected UserInfo getUserInfo() throws RemoteException, MXException {
        if (this.userInfo == null) {
            this.userInfo = MXServer.getMXServer().getUserInfo(this.session.getUserId());
            this.userInfo.setLocalSession(true);
        }
        return this.userInfo;
    }

    protected MaximoVersion getMaximoVersion() {
        return MaximoVersion.Companion.getSystemVersion();
    }

    @NotNull
    protected MboSetRemote getNewReadWriteMboSet(@NotNull String mboName) throws RemoteException, MXException {
        return this.getNewReadWriteMboSet(this.getUserInfo(), mboName);
    }

    @NotNull
    protected MboSetRemote getNewSystemReadWriteMboSet(@NotNull String mboName) throws RemoteException, MXException {
        return this.getNewReadWriteMboSet(this.getSystemUserInfo(), mboName);
    }

    @NotNull
    private MboSetRemote getNewReadWriteMboSet(@NotNull UserInfo userInfo, @NotNull String mboName) throws RemoteException, MXException {
        MboSetRemote newSet = MXServer.getMXServer().getMboSet(mboName, userInfo);
        if (this.trackedMboSets == null) {
            this.trackedMboSets = new ArrayDeque<MboSetRemote>();
        }
        this.trackedMboSets.add(newSet);
        return newSet;
    }

    @NotNull
    protected MboSetRemote getNewReadOnlyMboSet(@NotNull String mboName, boolean forSingleIteration) throws RemoteException, MXException {
        return this.getNewReadOnlyMboSet(this.getUserInfo(), mboName, forSingleIteration);
    }

    @NotNull
    protected MboSetRemote getNewSystemReadOnlyMboSet(@NotNull String mboName, boolean forSingleIteration) throws RemoteException, MXException {
        return this.getNewReadOnlyMboSet(this.getSystemUserInfo(), mboName, forSingleIteration);
    }

    @NotNull
    private MboSetRemote getNewReadOnlyMboSet(@NotNull UserInfo userInfo, @NotNull String mboName, boolean forSingleIteration) throws RemoteException, MXException {
        MboSetRemote newSet = this.getNewReadWriteMboSet(userInfo, mboName);
        newSet.setFlag(7L, true);
        if (forSingleIteration) {
            newSet.setFlag(39L, true);
        }
        return newSet;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public long getSleepTimeMsBetweenAttempts() {
        return this.sleepTimeMsBetweenAttempts;
    }

    public void setSleepTimeMsBetweenAttempts(int sleepTimeMsBetweenAttempts) {
        this.sleepTimeMsBetweenAttempts = sleepTimeMsBetweenAttempts;
    }

    protected ArrayList<String> getAuthorizedApps(String baseApp) throws RemoteException, MXException {
        MboSetRemote appAuthSet = this.getNewSystemReadOnlyMboSet("APPLICATIONAUTH", false);
        SqlFormat authSqlf = new SqlFormat("(app IN   (SELECT app from maxapps WHERE app = :1 OR originalapp = :1) AND groupname IN   (SELECT DISTINCT groupname from groupuser WHERE userid = :2) AND (optionname = 'READ' OR optionname = 'INSERT' OR optionname = 'SAVE')) OR (app IN   (SELECT intobjectname FROM MAXINTOBJDETAIL WHERE objectname IN      (SELECT maintbname FROM maxapps WHERE app = :1 OR originalapp = :1)      AND parentobjid IS null) AND groupname IN   (SELECT DISTINCT groupname from groupuser WHERE userid = :2) AND (optionname = 'READ' OR optionname = 'INSERT' OR optionname = 'SAVE'))");
        authSqlf.setObject(1, "MAXAPPS", "APP", baseApp);
        authSqlf.setObject(2, "MAXUSER", "USERID", this.userInfo.getUserName());
        appAuthSet.setWhere(authSqlf.format());
        ArrayList<String> result = new ArrayList<String>();
        MboRemote appAuth = appAuthSet.moveFirst();
        while (appAuth != null) {
            String app = appAuth.getString("APP");
            if (!result.contains(app)) {
                result.add(app);
            }
            appAuth = appAuthSet.moveNext();
        }
        return result;
    }
}

