/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.commands;

import com.interlocsolutions.maximo.notify.UserNotification;
import com.interlocsolutions.maximo.notify.commands.SimplifiedCommand;
import com.interlocsolutions.maximo.notify.commands.ValueComparator;
import com.interlocsolutions.maximo.notify.commands.ValueDO;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.security.UserInfo;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

@XmlRootElement(name="command", namespace="http://www.interlocsolutions.com/maximo/notify")
@XmlType(propOrder={"name", "values", "notificationId"}, namespace="http://www.interlocsolutions.com/maximo/notify")
public class SetValuesCommand
extends SimplifiedCommand {
    private static final String NAME = "SETVALUES";
    private List<ValueDO> values = new LinkedList<ValueDO>();
    private long notificationId = -1L;
    private UserNotification mbo = null;

    @Override
    @Nullable
    protected String execute(@NotNull UserInfo userInfo) throws NotifyFault {
        MboSetRemote mboSet = null;
        try {
            if (this.values.size() > 0 && this.mbo != null) {
                long id = this.mbo.getLong("RECORDID");
                String objectName = this.mbo.getString("OBJECTNAME");
                String userId = this.mbo.getString("USERID");
                if (objectName == null) {
                    throw new MXApplicationException("informer", "statusChangeMissingObject");
                }
                if (userId == null) {
                    throw new MXApplicationException("informer", "statusChangeMissingUser");
                }
                mboSet = this.getNewReadWriteMboSet(objectName);
                MboRemote obj = mboSet.getMboForUniqueId(id);
                if (obj == null) {
                    throw new MXApplicationException("informer", "statusChangeMissingMbo");
                }
                Collections.sort(this.values, new ValueComparator());
                for (ValueDO val : this.values) {
                    long flag = val.getMboFlag();
                    if (flag > 0L) {
                        switch (val.getType()) {
                            case STRING: {
                                obj.setValue(val.getAttribute(), val.getValue(), flag);
                            }
                            case DATETIME: {
                                obj.setValue(val.getAttribute(), val.getAsDate(), flag);
                                break;
                            }
                            case DECIMAL: {
                                obj.setValue(val.getAttribute(), val.getAsDecimal(), flag);
                                break;
                            }
                            case NUMBER: {
                                obj.setValue(val.getAttribute(), val.getAsNumber(), flag);
                                break;
                            }
                            case BOOLEAN: {
                                obj.setValue(val.getAttribute(), val.getAsBoolean(), flag);
                            }
                        }
                        continue;
                    }
                    switch (val.getType()) {
                        case STRING: {
                            obj.setValue(val.getAttribute(), val.getValue());
                        }
                        case DATETIME: {
                            obj.setValue(val.getAttribute(), val.getAsDate());
                            break;
                        }
                        case DECIMAL: {
                            obj.setValue(val.getAttribute(), val.getAsDecimal());
                            break;
                        }
                        case NUMBER: {
                            obj.setValue(val.getAttribute(), val.getAsNumber());
                            break;
                        }
                        case BOOLEAN: {
                            obj.setValue(val.getAttribute(), val.getAsBoolean());
                        }
                    }
                }
            }
            String id = null;
            return id;
        }
        catch (MXException e) {
            throw new NotifyFault(e);
        }
        catch (RemoteException e) {
            throw new NotifyFault(e);
        }
        finally {
            if (mboSet != null) {
                try {
                    mboSet.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    @XmlElement(name="name", namespace="http://www.interlocsolutions.com/maximo/notify", required=true)
    public String getName() {
        return NAME;
    }

    private void setName(String name) {
    }

    @Override
    public String getSchemaPath() {
        return "/resources/schemas/notify.xsd";
    }

    @Override
    public void setNotifyMbo(UserNotification mbo) throws MXException, RemoteException {
        this.mbo = mbo;
        this.notificationId = mbo.getUniqueIDValue();
    }

    @XmlElement(name="notifcationid", namespace="http://www.interlocsolutions.com/maximo/notify")
    public long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(long notificationId) {
        this.notificationId = notificationId;
    }

    @XmlElementWrapper(name="values", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="value", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<ValueDO> getValues() {
        return this.values;
    }

    public void setValues(List<ValueDO> values) {
        this.values = values;
    }

    public void addValue(ValueDO value) {
        if (this.values == null) {
            this.values = new LinkedList<ValueDO>();
        }
        this.values.add(value);
    }

    public void setSession(SessionInfo session) {
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }
}

