/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.commands;

import com.interlocsolutions.maximo.notify.commands.Command;
import com.interlocsolutions.maximo.notify.commands.NotifyCommandsConfig;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.InformerThread;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.MXRowUpdateException;
import psdi.util.logging.MXLogger;

public class CommandRegistrar
extends InformerThread {
    private static final MXLogger logger = NotifyConstants.INFORMER_LOGGER;

    public CommandRegistrar() {
        super("Informer-CommandRegistrar", NotifyConstants.INFORMER_LOGGER);
    }

    public static void populateObject(Object o) {
        try {
            Field[] fields;
            for (Field f : fields = o.getClass().getDeclaredFields()) {
                Object co;
                AbstractList list;
                Class typeClass;
                ParameterizedType gType;
                if (f.getType() == String.class) {
                    f.setAccessible(true);
                    if (!Modifier.isFinal(f.getModifiers())) {
                        f.set(o, "String");
                    }
                }
                if (ArrayList.class.isAssignableFrom(f.getType())) {
                    gType = (ParameterizedType)f.getGenericType();
                    typeClass = (Class)gType.getActualTypeArguments()[0];
                    list = new ArrayList();
                    co = null;
                    if (typeClass == String.class) {
                        co = "String";
                    } else if (typeClass == Integer.class) {
                        co = new Integer(1);
                    } else if (typeClass == Long.class) {
                        co = new Long(1L);
                    } else if (typeClass == Boolean.class) {
                        co = new Boolean(true);
                    } else if (typeClass == Short.class) {
                        co = new Short(Short.MIN_VALUE);
                    } else if (typeClass == Character.class) {
                        co = new Character('a');
                    } else {
                        co = typeClass.newInstance();
                        CommandRegistrar.populateObject(co);
                        ((ArrayList)list).add(co);
                    }
                    ((ArrayList)list).add(co);
                    f.setAccessible(true);
                    f.set(o, list);
                }
                if (!LinkedList.class.isAssignableFrom(f.getType())) continue;
                gType = (ParameterizedType)f.getGenericType();
                typeClass = (Class)gType.getActualTypeArguments()[0];
                list = new LinkedList();
                co = null;
                if (typeClass == String.class) {
                    co = "String";
                } else if (typeClass == Integer.class) {
                    co = new Integer(1);
                } else if (typeClass == Long.class) {
                    co = new Long(1L);
                } else if (typeClass == Boolean.class) {
                    co = new Boolean(true);
                } else if (typeClass == Short.class) {
                    co = new Short(Short.MIN_VALUE);
                } else if (typeClass == Character.class) {
                    co = new Character('a');
                } else {
                    co = typeClass.newInstance();
                    CommandRegistrar.populateObject(co);
                    ((LinkedList)list).add(co);
                }
                ((LinkedList)list).add(co);
                f.setAccessible(true);
                f.set(o, list);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected void runInformerTask() {
        try {
            this.scanClasspath();
        }
        catch (Exception e) {
            logger.error((Object)"Error encountered when scanning the classpath for built-in Commands.", (Throwable)e);
        }
    }

    public void scanClasspath() throws MXException, IOException {
        Enumeration<URL> commandConfigs = CommandRegistrar.class.getClassLoader().getResources("META-INF/informer-commands.xml");
        while (commandConfigs != null && commandConfigs.hasMoreElements()) {
            NotifyCommandsConfig commandManifest;
            URL url = commandConfigs.nextElement();
            try {
                commandManifest = (NotifyCommandsConfig)InformerObjectSerializer.getInstance().deserialize(url.openStream());
            }
            catch (Throwable e) {
                logger.error((Object)"informer-commands.xml could not be interpreted as a Command manifest", e);
                continue;
            }
            this.registerCommands(this.getClass().getClassLoader(), commandManifest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCommands(ClassLoader classLoader, NotifyCommandsConfig ncc) throws MXException {
        try {
            UserInfo userInfo = MXServer.getMXServer().getSystemUserInfo();
            MboSetRemote commands = MXServer.getMXServer().getMboSet("ISNOTIFYCOMMAND", userInfo);
            try {
                for (String className : ncc.getCommands()) {
                    String commandVersion;
                    String commandName;
                    try {
                        Command instance = (Command)classLoader.loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        commandName = instance.getName();
                        if (commandName == null || commandName.isEmpty()) {
                            throw new IllegalArgumentException("No Command name specified for Class " + className);
                        }
                        commandVersion = instance.getVersion();
                    }
                    catch (Throwable e) {
                        logger.warn((Object)("Command Class " + className + " was not registered successfully"), e);
                        continue;
                    }
                    SqlFormat sqlf = new SqlFormat("name = :1");
                    sqlf.setObject(1, "ISNOTIFYCOMMAND", "NAME", commandName);
                    commands.setWhere(sqlf.format());
                    commands.reset();
                    try {
                        MboRemote c = commands.isEmpty() ? commands.add() : commands.getMbo(0);
                        c.setValue("NAME", commandName);
                        c.setValue("CLASSNAME", className);
                        c.setValue("ACTIVE", true);
                        c.setValue("VERSION", commandVersion);
                        commands.save();
                    }
                    catch (MXRowUpdateException e) {
                        logger.debug((Object)("Update of Command " + commandName + " failed due to " + ((Object)((Object)e)).getClass().getSimpleName()));
                    }
                    commands.cleanup();
                    commands.clear();
                }
            }
            finally {
                NotifyUtil.closeAndCleanup(commands);
            }
        }
        catch (RemoteException e) {
            throw new MXApplicationException("system", "remoteexception", (Throwable)e);
        }
    }
}

