/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.commands;

import com.interlocsolutions.maximo.notify.UserNotification;
import com.interlocsolutions.maximo.notify.commands.BasicCommand;
import com.interlocsolutions.maximo.notify.commands.CommandUtilities;
import com.interlocsolutions.maximo.notify.commands.StatusDO;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.util.MXServerFactory;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.StatefulMboRemote;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

@XmlRootElement(name="command", namespace="http://www.interlocsolutions.com/maximo/notify")
public class ChangeStatusCommand
extends BasicCommand {
    private static final String NAME = "CHANGESTATUS";
    private String status = null;
    private String memo = null;
    private long notificationId = -1L;
    private UserNotification mbo = null;
    private List<StatusDO> availableStatuses = new LinkedList<StatusDO>();

    @Override
    public String execute() throws NotifyFault {
        MboSetRemote mboSet = null;
        try {
            if (this.mbo != null) {
                long id = this.mbo.getLong("RECORDID");
                String objectName = this.mbo.getString("OBJECTNAME");
                String userId = this.mbo.getString("USERID");
                if (objectName == null) {
                    throw new MXApplicationException("informer", "statusChangeMissingObject");
                }
                if (userId == null) {
                    throw new MXApplicationException("informer", "statusChangeMissingUser");
                }
                mboSet = MXServerFactory.getMXServer().getMboSet(objectName, NotifyUtil.getLocalUserInfo(userId));
                MboRemote obj = mboSet.getMboForUniqueId(id);
                if (obj != null && obj instanceof StatefulMboRemote) {
                    ((StatefulMboRemote)obj).changeStatus(this.status, MXServer.getMXServer().getDate(), this.memo);
                    mboSet.save();
                } else {
                    throw new MXApplicationException("informer", "statusChangeMissingMbo");
                }
            }
            String id = null;
            return id;
        }
        catch (NotifyFault e) {
            throw e;
        }
        catch (MXException e) {
            throw new NotifyFault(e);
        }
        catch (RemoteException e) {
            throw new NotifyFault(e);
        }
        finally {
            CommandUtilities.close(mboSet);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void setName(String name) {
    }

    @XmlElement(name="changeToStatus", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getChangeToStatus() {
        return this.status;
    }

    public void setChangeToStatus(String status) {
        this.status = status;
    }

    @XmlElement(name="memo", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @XmlElement(name="notificationid", namespace="http://www.interlocsolutions.com/maximo/notify")
    public long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(long notificationId) {
        this.notificationId = notificationId;
    }

    @Override
    public void setNotifyMbo(UserNotification mbo) throws MXException, RemoteException {
        this.mbo = mbo;
        this.notificationId = mbo.getUniqueIDValue();
        this.setAvailableStatuses();
    }

    public void setAvailableStatuses(List<StatusDO> availableStatuses) {
        this.availableStatuses = availableStatuses;
    }

    @XmlElementWrapper(name="statuses", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="status", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<StatusDO> getAvailableStatuses() {
        return this.availableStatuses;
    }

    @Override
    public String getSchemaPath() {
        return "/resources/schemas/changestatus.xsd";
    }

    private void setAvailableStatuses() throws RemoteException, MXException {
        if (this.mbo != null && this.notificationId != -1L) {
            this.availableStatuses = new LinkedList<StatusDO>();
            MboRemote obj = this.mbo.getMainObject();
            if (obj != null && obj instanceof StatefulMboRemote) {
                MboSetRemote statusList = ((StatefulMboRemote)obj).getValidStatusList();
                MboRemote status = null;
                int i = 0;
                while ((status = statusList.getMbo(i++)) != null) {
                    this.availableStatuses.add(new StatusDO(status.getString("VALUE"), status.getString("DESCRIPTION")));
                }
            }
        }
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }
}

