/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.classloader;

import com.interlocsolutions.maximo.notify.classloader.InformerClassesService;
import com.interlocsolutions.maximo.notify.classloader.InformerJarsTransactable;
import com.interlocsolutions.maximo.notify.commands.Command;
import com.interlocsolutions.maximo.notify.commands.CommandRegistrar;
import com.interlocsolutions.maximo.notify.commands.NotifyCommandsConfig;
import com.interlocsolutions.maximo.notify.util.InformerClassUtils;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.MboExtensionsKt;
import com.interlocsolutions.maximo.notify.util.MboSetRemoteClosableWrapper;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.io.Closeable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboSetRemote;
import psdi.server.MXServer;
import psdi.txn.MXTransaction;
import psdi.txn.Transactable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0012\u0010\r\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u000e\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u000f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0010\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0011\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0012\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/interlocsolutions/maximo/notify/classloader/InformerJarsTransactable;", "Lpsdi/txn/Transactable;", "()V", "commitTransaction", "", "p0", "Lpsdi/txn/MXTransaction;", "deleteOldCommands", "classLoader", "Ljava/lang/ClassLoader;", "manifests", "", "Ljava/net/URL;", "fireEventsAfterDB", "fireEventsAfterDBCommit", "fireEventsBeforeDB", "rollbackTransaction", "saveTransaction", "undoTransaction", "validateTransaction", "", "isinformer"})
public final class InformerJarsTransactable
implements Transactable {
    public void saveTransaction(@Nullable MXTransaction p0) {
    }

    public void commitTransaction(@Nullable MXTransaction p0) {
    }

    public void rollbackTransaction(@Nullable MXTransaction p0) {
    }

    public void undoTransaction(@Nullable MXTransaction p0) {
    }

    public boolean validateTransaction(@Nullable MXTransaction p0) {
        return true;
    }

    public void fireEventsBeforeDB(@Nullable MXTransaction p0) {
    }

    public void fireEventsAfterDB(@Nullable MXTransaction p0) {
    }

    public void fireEventsAfterDBCommit(@Nullable MXTransaction p0) {
        CommandRegistrar commandRegistrar;
        InformerClassesService infClassSvc = InformerClassUtils.getInformerClassesServiceOrFail();
        infClassSvc.reloadClasses();
        ClassLoader classLoader = infClassSvc.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"infClassSvc.classLoader");
        ClassLoader classLoader2 = classLoader;
        Enumeration<URL> enumeration = classLoader2.getResources("META-INF/informer-commands.xml");
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"classLoader.getResources\u2026F/informer-commands.xml\")");
        ArrayList<URL> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
        List manifests = CollectionsKt.asReversed((List)arrayList);
        this.deleteOldCommands(classLoader2, manifests);
        CommandRegistrar $this$fireEventsAfterDBCommit_u24lambda_u241 = commandRegistrar = new CommandRegistrar();
        boolean bl = false;
        Iterable $this$forEach$iv = manifests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            URL manifest = (URL)element$iv;
            boolean bl2 = false;
            Object object = InformerObjectSerializer.getInstance().deserialize(manifest.openStream());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.commands.NotifyCommandsConfig");
            NotifyCommandsConfig ncc = (NotifyCommandsConfig)object;
            $this$fireEventsAfterDBCommit_u24lambda_u241.registerCommands(classLoader2, ncc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteOldCommands(ClassLoader classLoader, List<URL> manifests) {
        MboSetRemote mboSetRemote = MXServer.getMXServer().getMboSet("ISNOTIFYCOMMAND", MXServer.getMXServer().getSystemUserInfo());
        Intrinsics.checkNotNullExpressionValue((Object)mboSetRemote, (String)"getMXServer()\n          \u2026XServer().systemUserInfo)");
        Set existingCommands2 = SequencesKt.toSet((Sequence)SequencesKt.map(MboExtensionsKt.asSequence(mboSetRemote), (Function1)deleteOldCommands.existingCommands.1.INSTANCE));
        Set commandsProcessed = new LinkedHashSet();
        Iterable $this$forEach$iv = manifests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            URL manifest = (URL)element$iv;
            boolean bl = false;
            Object object = InformerObjectSerializer.getInstance().deserialize(manifest.openStream());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.commands.NotifyCommandsConfig");
            NotifyCommandsConfig ncc = (NotifyCommandsConfig)object;
            List<String> list = ncc.getCommands();
            Intrinsics.checkNotNullExpressionValue(list, (String)"ncc.commands");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String className = (String)element$iv2;
                boolean bl2 = false;
                try {
                    Object obj = classLoader.loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.commands.Command");
                    Command instance = (Command)obj;
                    if (instance.getName() == null) continue;
                    String string = instance.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"instance.name");
                    if (!(((CharSequence)string).length() > 0)) continue;
                    String string2 = instance.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"instance.name");
                    commandsProcessed.add(string2);
                }
                catch (ClassNotFoundException e) {
                    NotifyConstants.INFORMER_CLASSES_LOGGER.warn((Object)("Invalid class " + className + " found in " + manifest.toURI() + '.'));
                }
            }
        }
        Set commandsToDelete = SetsKt.minus((Set)existingCommands2, (Iterable)commandsProcessed);
        if (!((Collection)commandsToDelete).isEmpty()) {
            MboSetRemote $this$use$iv = MXServer.getMXServer().getMboSet("ISNOTIFYCOMMAND", MXServer.getMXServer().getSystemUserInfo());
            boolean $i$f$use = false;
            Closeable closeable = new MboSetRemoteClosableWrapper($this$use$iv);
            Throwable throwable = null;
            try {
                MboSetRemoteClosableWrapper it$iv = (MboSetRemoteClosableWrapper)closeable;
                boolean bl = false;
                MboSetRemote msr = $this$use$iv;
                boolean bl3 = false;
                msr.setWhere("name in (" + CollectionsKt.joinToString$default((Iterable)commandsToDelete, (CharSequence)"', '", (CharSequence)"'", (CharSequence)"'", (int)0, null, (Function1)deleteOldCommands.2.1.INSTANCE, (int)24, null) + ')');
                msr.deleteAll();
                msr.save();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }
}

