/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.classloader;

import com.interlocsolutions.maximo.notify.StartupMonitor;
import com.interlocsolutions.maximo.notify.classloader.InformerClassLoaderManager;
import com.interlocsolutions.maximo.notify.classloader.InformerClassesUpdateListener;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import psdi.mbo.MaximoCache;
import psdi.server.AppService;
import psdi.server.AppServiceRemote;
import psdi.server.MXServer;
import psdi.server.event.EventListener;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class InformerClassesService
extends AppService
implements AppServiceRemote {
    public static final String SERVICE_CLASSES_NAME = "NOTIFYCLASSES";
    private static final MXLogger LOGGER = NotifyConstants.INFORMER_CLASSES_LOGGER;

    public InformerClassesService(MXServer mxServer) throws RemoteException {
        super(mxServer);
    }

    public void init() {
        super.init();
        try {
            this.initializeClassLoaderManager();
            LOGGER.info((Object)String.format("Initialization of Service %s completed successfully", this.getName()));
        }
        catch (MXException e) {
            LOGGER.fatal((Object)String.format("Initialization of Service %s did not complete successfully", this.getName()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void initializeClassLoaderManager() throws MXException {
        InformerClassLoaderManager classCache = new InformerClassLoaderManager();
        this.getMXServer().addToMaximoCache(classCache.getName(), (MaximoCache)classCache);
        classCache.init();
        MXServer.getEventTopicTree().register("maximo.isnotifyjars.*", (EventListener)new InformerClassesUpdateListener());
        StartupMonitor.getInstance().notifyClassloaderInitialized();
    }

    public ClassLoader getClassLoader() throws RemoteException, MXException {
        return ((InformerClassLoaderManager)this.mxServer.getFromMaximoCache(SERVICE_CLASSES_NAME)).getLoader();
    }

    public void reloadClasses() throws MXException, RemoteException {
        this.mxServer.reloadMaximoCache(SERVICE_CLASSES_NAME, true);
    }

    public String getName() {
        return SERVICE_CLASSES_NAME;
    }
}

