/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.classloader;

import com.interlocsolutions.maximo.notify.err.InformerConfException;
import com.interlocsolutions.maximo.notify.util.InformerClassUtils;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.util.MXException;

public abstract class ChangeableClassAccessor<T> {
    public static final Object CLASS_LOADER_LOCK = new Object();
    public static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    @NotNull
    protected final String humanReadableClassType;
    @Nullable
    private T currentInstance;
    @Nullable
    private String currentClassName;
    @Nullable
    private String latestVersion;
    private Future<T> swapOutFuture;
    private boolean invalidated;

    public ChangeableClassAccessor(@NotNull String humanReadableClassType) {
        this.humanReadableClassType = humanReadableClassType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public T getInstance() throws MXException, RemoteException {
        Object object = CLASS_LOADER_LOCK;
        synchronized (object) {
            String newVersion;
            Class newClassInstance;
            boolean swapoutUnderway;
            if (this.swapOutFuture == null) {
                this.swapOutFuture = null;
                swapoutUnderway = false;
            } else if (this.swapOutFuture.isDone()) {
                this.swapOutFuture = null;
                swapoutUnderway = false;
            } else {
                swapoutUnderway = true;
            }
            String className = this.getClassName();
            try {
                newClassInstance = InformerClassUtils.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new InformerConfException(String.format("The configured %s class %s could not be loaded", this.humanReadableClassType, className), e);
            }
            boolean newInstanceNeeded = !this.permitCaching() ? true : (this.currentInstance == null ? true : (swapoutUnderway ? false : (this.invalidated ? true : (!className.equals(this.currentClassName) ? true : ((newVersion = InformerClassUtils.getClassVersionStr(newClassInstance)) == null && this.latestVersion == null ? false : (newVersion == null || this.latestVersion == null ? true : !this.latestVersion.equals(newVersion)))))));
            if (newInstanceNeeded) {
                if (this.currentInstance != null && this.permitEventualRollover()) {
                    this.swapOutFuture = EXECUTOR_SERVICE.submit(new Callable<T>(){

                        @Override
                        public T call() throws Exception {
                            return ChangeableClassAccessor.this.swapOut(newClassInstance);
                        }
                    });
                } else {
                    this.swapOut(newClassInstance);
                }
                this.invalidated = false;
            }
            return this.currentInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T swapOut(Class<? extends T> newClassInstance) throws MXException, RemoteException {
        T newInstance;
        T oldInstance;
        Object object = CLASS_LOADER_LOCK;
        synchronized (object) {
            oldInstance = this.currentInstance;
        }
        if (oldInstance != null) {
            try {
                this.decommission(oldInstance);
                this.clearReferences();
            }
            catch (RuntimeException e) {
                throw new InformerConfException(String.format("The existing %s could not be decommissioned", this.humanReadableClassType), e);
            }
        }
        try {
            newInstance = newClassInstance.newInstance();
        }
        catch (InstantiationException e) {
            throw new InformerConfException(String.format("The configured %s could not be instantiated", this.humanReadableClassType), e);
        }
        catch (IllegalAccessException e) {
            throw new InformerConfException(String.format("The configured %s could not be instantiated", this.humanReadableClassType), e);
        }
        catch (RuntimeException e) {
            throw new InformerConfException(String.format("The configured %s could not be instantiated", this.humanReadableClassType), e);
        }
        try {
            this.commission(newInstance);
        }
        catch (MXException e) {
            this.clearReferences();
            throw e;
        }
        catch (RemoteException e) {
            this.clearReferences();
            throw e;
        }
        catch (RuntimeException e) {
            this.clearReferences();
            throw new InformerConfException(String.format("The new %s could not be commissioned", this.humanReadableClassType), e);
        }
        Object object2 = CLASS_LOADER_LOCK;
        synchronized (object2) {
            this.currentClassName = newInstance.getClass().getName();
            this.currentInstance = newInstance;
            this.latestVersion = InformerClassUtils.getClassVersionStr(newInstance.getClass());
        }
        return oldInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = CLASS_LOADER_LOCK;
        synchronized (object) {
            this.invalidated = true;
        }
    }

    @NotNull
    protected abstract String getClassName();

    protected abstract void commission(@NotNull T var1) throws MXException, RemoteException;

    protected abstract void decommission(@NotNull T var1) throws MXException, RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearReferences() {
        Object object = CLASS_LOADER_LOCK;
        synchronized (object) {
            this.currentInstance = null;
            this.currentClassName = null;
            this.latestVersion = null;
        }
    }

    protected abstract boolean permitEventualRollover();

    protected abstract boolean permitCaching();
}

