/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.NotifyUserRemote;
import com.interlocsolutions.maximo.notify.NotifyUserSet;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.util.MboSetIterator;
import java.rmi.RemoteException;
import psdi.app.signature.MaxUserRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.server.event.EventListener;
import psdi.server.event.EventMessage;
import psdi.util.MXException;

public class SecurityUserChangeListener
implements EventListener {
    public void eventAction(EventMessage event) throws MXException {
    }

    public boolean eventValidate(EventMessage event) throws MXException {
        return true;
    }

    public void postCommitEventAction(EventMessage event) throws MXException {
        if (event.getEventName().endsWith("maxuser.update") && event.getEventObject() instanceof MaxUserRemote) {
            try {
                MaxUserRemote maxUser = (MaxUserRemote)event.getEventObject();
                this.clearSessions(maxUser);
                this.refreshUser(maxUser);
            }
            catch (RemoteException e) {
                NotifyConstants.INFORMER_LOGGER.error((Object)e);
            }
        }
    }

    public void preSaveEventAction(EventMessage event) throws MXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSessions(MaxUserRemote maxUser) throws MXException, RemoteException {
        if (maxUser.isModified("PASSWORD") || maxUser.isModified("STATUS") && !SecurityUserChangeListener.verifyUserStatus(maxUser)) {
            MboSetRemote sessionSet = null;
            try {
                SqlFormat sqlf = new SqlFormat("userid = :1");
                sqlf.setObject(1, "ISSESSION", "USERID", maxUser.getString("USERID"));
                sessionSet = MXServer.getMXServer().getMboSet("ISSESSION", MXServer.getMXServer().getSystemUserInfo());
                sessionSet.setWhere(sqlf.format());
                sessionSet.deleteAll();
                sessionSet.save();
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(sessionSet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(sessionSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshUser(MaxUserRemote maxUser) throws MXException, RemoteException {
        if (maxUser.isModified("STATUS")) {
            MboSetRemote notifyUsers = null;
            try {
                SqlFormat sf = new SqlFormat("userid = :1");
                sf.setObject(1, "ISNOTIFYUSER", "USERID", maxUser.getString("USERID"));
                notifyUsers = MXServer.getMXServer().getMboSet("ISNOTIFYUSER", MXServer.getMXServer().getSystemUserInfo());
                notifyUsers.setWhere(sf.format());
                for (NotifyUserRemote user : new MboSetIterator(notifyUsers)) {
                    user.setValue("DISABLED", !"ACTIVE".contentEquals(maxUser.getInternalStatus()), 1L);
                    if (user.isModified("DISABLED") && !user.getBoolean("DISABLED") && !NotifyUserSet.Companion.checkLicenseForUserCount(notifyUsers, 0)) {
                        user.setValue("DISABLED", true);
                    }
                    if (user.getBoolean("DISABLED") || !"ACTIVE".contentEquals(maxUser.getInternalStatus())) continue;
                    user.markForRefresh();
                }
                notifyUsers.save();
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(notifyUsers);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(notifyUsers);
        }
    }

    public static boolean verifyUserStatus(MaxUserRemote maxUser) throws RemoteException, MXException {
        return "ACTIVE".contentEquals(maxUser.getInternalStatus());
    }
}

