/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.NotifyUserRemote;
import com.interlocsolutions.maximo.notify.NotifyUserSet;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.util.MboSetIterator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.server.event.EventListener;
import psdi.server.event.EventMessage;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class SecurityChangeListener
implements EventListener {
    public void eventAction(EventMessage em) {
    }

    public boolean eventValidate(EventMessage em) throws MXException {
        MboRemote obj = (MboRemote)em.getEventObject();
        String eventName = em.getEventName() == null ? "" : em.getEventName().trim().toLowerCase();
        try {
            return obj.isBasedOn("MAXUSER") && eventName.endsWith(".delete") || obj.isBasedOn("GROUPUSER") || obj.isBasedOn("APPLICATIONAUTH") || obj.isBasedOn("ISNOTIFYASSOCAPP");
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new MXApplicationException("system", "remoteexception", (Throwable)e);
        }
    }

    public void postCommitEventAction(EventMessage em) throws MXException {
        MboRemote obj = (MboRemote)em.getEventObject();
        String eventName = em.getEventName() == null ? "" : em.getEventName().trim().toLowerCase();
        try {
            if (obj.isBasedOn("MAXUSER") && eventName.endsWith(".delete")) {
                this.handleMaxUser(obj);
            } else if (obj.isBasedOn("GROUPUSER")) {
                this.handleGroupUser(obj);
            } else if (obj.isBasedOn("APPLICATIONAUTH")) {
                this.handleApplicationAuth(obj);
            } else if (obj.isBasedOn("ISNOTIFYASSOCAPP")) {
                this.handleNotifyAssocApp(obj);
            }
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new MXApplicationException("system", "remoteexception", (Throwable)e);
        }
    }

    private void processNotifyUserSet(MboSetRemote notifyUserSet) throws MXException, RemoteException {
        MboRemote user = notifyUserSet.moveFirst();
        while (user != null) {
            List<String> apps2 = SecurityChangeListener.getApplicationsForProfile(user.getMboSet("NOTIFY").getMbo(0));
            user.setValue("DISABLED", !SecurityChangeListener.hasSufficientAccess(user.getString("USERID"), apps2), 1L);
            if (user.isModified("DISABLED") && !user.getBoolean("DISABLED") && !NotifyUserSet.Companion.checkLicenseForUserCount(notifyUserSet, 0)) {
                user.setValue("DISABLED", true);
            }
            this.refreshUser((NotifyUserRemote)user);
            user = notifyUserSet.moveNext();
        }
    }

    public void preSaveEventAction(EventMessage em) {
    }

    private void refreshUser(NotifyUserRemote notifyUser) throws RemoteException, MXException {
        if (notifyUser.isModified("DISABLED") && !notifyUser.getBoolean("DISABLED")) {
            notifyUser.markForRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMaxUser(MboRemote obj) throws RemoteException, MXException {
        MboSetRemote notifyUserSet = MXServer.getMXServer().getMboSet("ISNOTIFYUSER", MXServer.getMXServer().getSystemUserInfo());
        try {
            SqlFormat sqlf = new SqlFormat("userid = :1");
            sqlf.setObject(1, "ISNOTIFYUSER", "USERID", obj.getString("USERID"));
            notifyUserSet.setWhere(sqlf.format());
            notifyUserSet.deleteAll();
            notifyUserSet.save();
        }
        finally {
            NotifyUtil.closeAndCleanup(notifyUserSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGroupUser(MboRemote obj) throws RemoteException, MXException {
        MboSetRemote notifyUserSet = MXServer.getMXServer().getMboSet("ISNOTIFYUSER", MXServer.getMXServer().getSystemUserInfo());
        try {
            SqlFormat sqlf = new SqlFormat("userid = :1");
            sqlf.setObject(1, "GROUPUSER", "USERID", obj.getString("USERID"));
            notifyUserSet.setWhere(sqlf.format());
            this.processNotifyUserSet(notifyUserSet);
            notifyUserSet.save();
        }
        finally {
            NotifyUtil.closeAndCleanup(notifyUserSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleApplicationAuth(MboRemote obj) throws RemoteException, MXException {
        MboSetRemote notifyUserSet = MXServer.getMXServer().getMboSet("ISNOTIFYUSER", MXServer.getMXServer().getSystemUserInfo());
        try {
            SqlFormat sqlf = new SqlFormat("userid IN (SELECT userid FROM groupuser WHERE groupname = :1 )");
            sqlf.setObject(1, "GROUPUSER", "GROUPNAME", obj.getString("GROUPNAME"));
            notifyUserSet.setWhere(sqlf.format());
            this.processNotifyUserSet(notifyUserSet);
            notifyUserSet.save();
        }
        finally {
            NotifyUtil.closeAndCleanup(notifyUserSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotifyAssocApp(MboRemote obj) throws RemoteException, MXException {
        MboSetRemote notifyUserSet = MXServer.getMXServer().getMboSet("ISNOTIFYUSER", MXServer.getMXServer().getSystemUserInfo());
        try {
            SqlFormat sqlf = new SqlFormat("notifyid = :1");
            sqlf.setLong(1, obj.getLong("NOTIFYID"));
            notifyUserSet.setWhere(sqlf.format());
            this.processNotifyUserSet(notifyUserSet);
            notifyUserSet.save();
        }
        finally {
            NotifyUtil.closeAndCleanup(notifyUserSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasSufficientAccess(String userId, List<String> apps2) throws MXException, RemoteException {
        StringBuilder sb = new StringBuilder(":2");
        for (int x = 1; x < apps2.size(); ++x) {
            sb.append(", :").append(x + 2);
        }
        UserInfo sysUser = MXServer.getMXServer().getSystemUserInfo();
        MboSetRemote appAccessSet = MXServer.getMXServer().getMboSet("APPLICATIONAUTH", sysUser);
        try {
            SqlFormat authSqlf = new SqlFormat("(app IN   (SELECT app from maxapps WHERE app in (" + sb + ") OR originalapp in (" + sb + ")) AND groupname IN   (SELECT DISTINCT groupname from groupuser WHERE userid = :1) AND (optionname = 'READ' OR optionname = 'INSERT' OR optionname = 'SAVE')) OR (app IN   (SELECT intobjectname FROM MAXINTOBJDETAIL WHERE objectname IN      (SELECT maintbname FROM maxapps WHERE app in (" + sb + ") OR originalapp in (" + sb + "))      AND parentobjid IS null) AND groupname IN   (SELECT DISTINCT groupname from groupuser WHERE userid = :1) AND (optionname = 'READ' OR optionname = 'INSERT' OR optionname = 'SAVE'))");
            authSqlf.setObject(1, "MAXUSER", "USERID", userId);
            for (int x = 0; x < apps2.size(); ++x) {
                authSqlf.setObject(x + 2, "MAXAPPS", "APP", apps2.get(x));
            }
            appAccessSet.setWhere(authSqlf.format());
            appAccessSet.reset();
            boolean bl = !appAccessSet.isEmpty();
            return bl;
        }
        finally {
            NotifyUtil.closeAndCleanup(appAccessSet);
        }
    }

    public static List<String> getApplicationsForProfile(MboRemote profile) throws RemoteException, MXException {
        ArrayList<String> rc2 = new ArrayList<String>();
        rc2.add(profile.getString("APP"));
        for (MboRemote mr : new MboSetIterator(profile.getMboSet("ASSOCAPP"))) {
            rc2.add(mr.getString("APP"));
        }
        return rc2;
    }
}

