/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.DeleteTransactable;
import com.interlocsolutions.maximo.notify.DeleteTransactableOwner;
import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.NotifyUserDeleteTransactable;
import com.interlocsolutions.maximo.notify.NotifyUserRemote;
import com.interlocsolutions.maximo.notify.NotifyUserSet;
import com.interlocsolutions.maximo.notify.UserNotificationRemote;
import com.interlocsolutions.maximo.notify.err.InformerEvalException;
import com.interlocsolutions.maximo.notify.push.PushQueueManager;
import com.interlocsolutions.maximo.notify.queue.notification.JobSpecUserRefresh;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobManager;
import com.interlocsolutions.maximo.notify.util.ImmutableLongSet;
import com.interlocsolutions.maximo.notify.util.InformerTracking;
import com.interlocsolutions.maximo.notify.util.LongAccumulator;
import com.interlocsolutions.maximo.notify.util.MboMutator;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.db.DataUtils;
import com.interlocsolutions.maximo.notify.xml.NotifyXMLUtils;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import javax.mail.MessagingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.app.signature.MaxUserRemote;
import psdi.common.commtmplt.CommTemplateRemote;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class NotifyUser
extends Mbo
implements NotifyUserRemote,
DeleteTransactableOwner<NotifyUserDeleteTransactable> {
    private NotifyUserDeleteTransactable deleteTransactable;
    private static final long serialVersionUID = 5652705219773485215L;
    private static int commitBatchSize = 100;
    private final NotificationJobManager notificationJobManager = NotificationJobManager.INSTANCE;
    private boolean notificationsActive = true;

    public NotifyUser(MboSet ms) throws RemoteException {
        super(ms);
    }

    public void add() throws RemoteException, MXException {
        MboRemote owner = this.getOwner();
        if (owner != null && !owner.getName().equals("ISNOTIFY")) {
            throw new MXApplicationException("informer", "onlyAddedFromNotify");
        }
        super.add();
        if (owner != null) {
            this.setValue("NOTIFYID", owner.getString("NOTIFYID"));
        }
        this.setValue("CREATEDATE", MXServer.getMXServer().getDate());
    }

    public void init() throws MXException {
        super.init();
        if (!this.toBeAdded()) {
            this.setFieldFlag("USERID", 7L, true);
        }
    }

    public void delete(long flag) throws RemoteException, MXException {
        try {
            super.delete(flag);
            DeleteTransactable.onDelete(this);
            this.notificationsActive = false;
            DeleteTransactable.resetDeleteAll(this.getMboSet("SESSION"), flag);
            DeleteTransactable.resetDeleteAll(this.getMboSet("$isnotifygroupuser", "ISNOTIFYGROUPUSER", "notifyuserid = :notifyuserid and notifygroupid in (select notifygroupid from isnotifygroup where notifyid = :notifyid)"), flag);
        }
        finally {
            this.sendPushMessage();
            this.notificationsActive = true;
        }
    }

    public void undelete() throws MXException, RemoteException {
        super.undelete();
        DeleteTransactable.onUndelete(this);
        this.getMboSet("SESSION").undeleteAll();
        this.getMboSet("$isnotifygroupuser", "ISNOTIFYGROUPUSER", "notifyuserid = :notifyuserid and notifygroupid in (select notifygroupid from isnotifygroup where notifyid = :notifyid)").undeleteAll();
    }

    @Override
    public boolean isNotificationsActive() throws RemoteException {
        return this.notificationsActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refreshNotifications(final long refreshQueueId) throws MXException, RemoteException {
        ImmutableLongSet userNotificationsToRemove;
        ImmutableLongSet userNotificationsToRefresh;
        Iterator recordIdsToAdd;
        ImmutableLongSet targetSet;
        MaxUserRemote maxUser;
        if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
            NotifyConstants.INFORMER_LOGGER.debug((Object)("Refreshing notifications for user " + this.getString("USERID")));
        }
        if ((maxUser = (MaxUserRemote)this.getMboSet("MAXUSER").getMbo(0)) == null) {
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Cannot get a MAXUSER for user " + this.getString("USERID") + ", exiting."));
            }
            return false;
        }
        if (!maxUser.isActive()) {
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Skipping Notification refresh for INACTIVE user " + this.getString("USERID")));
            }
            return false;
        }
        long start = System.currentTimeMillis();
        long notifyId = this.getLong("NOTIFYID");
        final String notifyNum = this.getString("NOTIFY.NOTIFYNUM");
        final String userId = this.getString("USERID");
        final String mainObjectName = this.getString("NOTIFY.MAINNOTIFYOBJECT.OBJECTNAME");
        boolean isWorkflow = this.isNull("NOTIFY.CLAUSENAME");
        MXServer mxServer = MXServer.getMXServer();
        UserInfo sysUserInfo = mxServer.getSystemUserInfo();
        final String uniqueKey = mxServer.getMaximoDD().getUniqueIdColumn(mainObjectName);
        try {
            if (isWorkflow) {
                MboSetRemote wfAssignmentsSet = this.getMboSet("NOTIFY.WFASSIGNMENT");
                SqlFormat sqlf = new SqlFormat("assigncode in (select personid from maxuser where userid = :1)");
                sqlf.setObject(1, "MAXUSER", "USERID", userId);
                wfAssignmentsSet.setWhere(sqlf.format());
                targetSet = DataUtils.collectUniqueLongsByMbo(sysUserInfo, "WFASSIGNMENT", "OWNERID", wfAssignmentsSet.getCompleteWhere());
            } else {
                String cachedClause = NotificationEventListenerManager.getClause(notifyId);
                String mainObjectWhereClause = cachedClause != null ? cachedClause : this.getString("NOTIFY.QUERY.CLAUSE");
                UserInfo thisUserInfo = NotifyUtil.getLocalUserInfo(userId);
                targetSet = MboUtil.collectUniqueIds(thisUserInfo, mainObjectName, mainObjectWhereClause);
            }
        }
        catch (SQLException e) {
            throw new InformerEvalException("UserRefresh(" + notifyNum + ", " + userId + ")", "Failed to determine user's intended set of " + mainObjectName + " for Notifications", (Throwable)e);
        }
        try {
            final LongAccumulator recordIdsToAddAccumulator = new LongAccumulator(100);
            final ImmutableLongSet.Builder userNotificationsToRefreshAccumulator = new ImmutableLongSet.Builder(100);
            final ImmutableLongSet.Builder userNotificationsToRemoveAccumulator = new ImmutableLongSet.Builder(100);
            SqlFormat sqlf = new SqlFormat("notifyid = :1 AND userid = :2 AND active = 1");
            sqlf.setLong(1, notifyId);
            sqlf.setObject(2, "ISUSERNOTIFICATION", "USERID", userId);
            DataUtils.queryByMbo(sysUserInfo, "ISUSERNOTIFICATION", new String[]{"USERNOTIFICATIONID", "RECORDID"}, sqlf.format(), "RECORDID ASC", new DataUtils.ResultSetHandler<ImmutableLongSet>(){

                @Override
                public ImmutableLongSet useResultSet(@NotNull ResultSet rs) throws RemoteException, MXException, SQLException {
                    int idxNotificationId = rs.findColumn("USERNOTIFICATIONID");
                    int idxRecordId = rs.findColumn("RECORDID");
                    long[] orderedTargetRecordidArr = targetSet.asArray();
                    int i = 0;
                    while (rs.next()) {
                        long userNotificationId;
                        long recordId = rs.getLong(idxRecordId);
                        while (i < orderedTargetRecordidArr.length && orderedTargetRecordidArr[i] < recordId) {
                            recordIdsToAddAccumulator.add(orderedTargetRecordidArr[i++]);
                        }
                        if (i < orderedTargetRecordidArr.length && orderedTargetRecordidArr[i] == recordId) {
                            userNotificationId = rs.getLong(idxNotificationId);
                            userNotificationsToRefreshAccumulator.add(userNotificationId);
                            ++i;
                            continue;
                        }
                        userNotificationId = rs.getLong(idxNotificationId);
                        userNotificationsToRemoveAccumulator.add(userNotificationId);
                    }
                    while (i < orderedTargetRecordidArr.length) {
                        recordIdsToAddAccumulator.add(orderedTargetRecordidArr[i++]);
                    }
                    return null;
                }
            });
            recordIdsToAdd = recordIdsToAddAccumulator.flushToIterator();
            userNotificationsToRefresh = userNotificationsToRefreshAccumulator.build();
            userNotificationsToRemove = userNotificationsToRemoveAccumulator.build();
        }
        catch (SQLException e) {
            throw new InformerEvalException("UserRefresh(" + notifyNum + ", " + userId + ")", "Failed to determine user's current set of " + mainObjectName + " Notifications", (Throwable)e);
        }
        boolean changesWereMade = false;
        final Date now = mxServer.getDate();
        StringBuilder errorsSeen = new StringBuilder();
        while (recordIdsToAdd.hasNext()) {
            Long recordId = (Long)recordIdsToAdd.next();
            MboSetRemote userNotificationSet = mxServer.getMboSet("ISUSERNOTIFICATION", sysUserInfo);
            try {
                new MboMutator(userNotificationSet.add(2L)).setValue("USERID", userId).setValue("OBJECTNAME", mainObjectName).setValue("LASTUPDATE", now).setValue("NOTIFYID", notifyId).setValue("RECORDID", recordId).setValue("ACTIVE", true).setValue("REFRESHED", true).setValue("HASH", NotifyXMLUtils.getNotificationContentHash(sysUserInfo, notifyId, recordId));
                userNotificationSet.save();
                changesWereMade = true;
                if (!NotifyConstants.INFORMER_NRQP_LOGGER.isDebugEnabled()) continue;
                NotifyConstants.INFORMER_NRQP_LOGGER.debug((Object)String.format("For %s's user %s, a Notification for %s %s=%d was created", notifyNum, userId, mainObjectName, uniqueKey, recordId));
            }
            catch (Exception e) {
                String notificationTuple = String.format("(profile %s, user %s, %s %s=%d)", notifyNum, userId, mainObjectName, uniqueKey, recordId);
                NotifyConstants.INFORMER_NRQP_LOGGER.error((Object)String.format("Notification %s could not be created", notificationTuple), (Throwable)e);
                errorsSeen.append(String.format("* %s. %s: %s\n", notificationTuple, e.getClass().getName(), e.getMessage()));
            }
            finally {
                NotifyUtil.closeAndCleanup(userNotificationSet);
            }
        }
        if (errorsSeen.length() > 0) {
            errorsSeen.insert(0, "Errors encountered generating these notifications:\n");
            this.notificationJobManager.enqueueError(new JobSpecUserRefresh(notifyId, this.getLong("NOTIFYUSERID")), errorsSeen.toString());
        }
        if (!userNotificationsToRemove.isEmpty()) {
            int numChanged = MboUtil.visitMbosWithRetry(sysUserInfo, "ISUSERNOTIFICATION", (Iterable<Long>)userNotificationsToRemove, new NotifyUtil.MboVisitor(){

                @Override
                public void visit(@NotNull MboRemote userNotification) throws RemoteException, MXException {
                    userNotification.setValue("ACTIVE", false, 2L);
                    userNotification.setValue("LASTUPDATE", now, 2L);
                    userNotification.setValue("REFRESHED", true);
                    userNotification.getMboSet("$filefragment", "ISFILEFRAGMENT", "usernotificationid = :usernotificationid").deleteAll();
                    if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.debug((Object)String.format("%s %s=%d for Profile %s marked inactive for user %s", mainObjectName, uniqueKey, userNotification.getLong("RECORDID"), notifyNum, userId));
                    }
                }
            }, 3);
            changesWereMade |= 0 < numChanged;
        }
        if (!userNotificationsToRefresh.isEmpty()) {
            MboUtil.visitMbosWithRetry(sysUserInfo, "ISUSERNOTIFICATION", (Iterable<Long>)userNotificationsToRefresh, new NotifyUtil.MboVisitor(){

                @Override
                public void visit(@NotNull MboRemote userNotification) throws RemoteException, MXException {
                    ((UserNotificationRemote)userNotification).markForRefresh(refreshQueueId);
                }
            }, 3);
        }
        if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
            long total = System.currentTimeMillis() - start;
            NotifyConstants.INFORMER_LOGGER.debug((Object)("Total refresh time for " + userId + " was " + total + "ms"));
        }
        return changesWereMade;
    }

    @Override
    public void markForRefresh() throws RemoteException, MXException {
        long notifyUserId;
        long notifyId = this.getLong("NOTIFYID");
        Long newJobId = this.notificationJobManager.enqueue(new JobSpecUserRefresh(notifyId, notifyUserId = this.getUniqueIDValue()));
        if (newJobId != null) {
            InformerTracking.notificationUserAdd(this, newJobId, notifyId);
        }
    }

    @Override
    public void sendPushMessage() throws RemoteException, MXException {
        this.sendPushMessage(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPushMessage(long queueid) throws RemoteException, MXException {
        if (this.isNull("NOTIFY.NOTIFYNUM")) {
            return;
        }
        MboSetRemote pushDeviceSet = null;
        try {
            pushDeviceSet = this.getMboSet("PUSHDEVICE");
            pushDeviceSet.reset();
            MboRemote device = pushDeviceSet.moveFirst();
            while (device != null) {
                PushQueueManager.getInstance().addQueuedItemForNotification(device.getUniqueIDValue(), this.getString("NOTIFY.NOTIFYNUM"));
                device = pushDeviceSet.moveNext();
            }
        }
        finally {
            NotifyUtil.closeAndCleanup(pushDeviceSet);
        }
    }

    public void sendAppLink() throws MXException, RemoteException {
        this.sendAppLink(MXServer.getMXServer().getProperty("informer.system.deploy.url"));
    }

    @Override
    public void sendAppLink(String deployURL) throws MXException, RemoteException {
        MboSetRemote commSet = null;
        if (deployURL == null || deployURL.trim().length() == 0) {
            throw new MXApplicationException("informer", "appLinkNoDeployURL");
        }
        MboRemote owner = this.getOwner();
        if (owner == null || !owner.isBasedOn("ISNOTIFY")) {
            throw new MXApplicationException("informer", "appLinkOwnerNotNotify");
        }
        if (owner.getMboSet("APPDEPLOY").count() < 1) {
            throw new MXApplicationException("informer", "noAppsInstalled");
        }
        if (!deployURL.endsWith("/")) {
            deployURL = deployURL + "/";
        }
        deployURL = deployURL + owner.getString("NOTIFYNUM").toLowerCase();
        this.setValue("APPLINKURL", deployURL);
        try {
            String commTemplate = MXServer.getMXServer().getProperty("informer.deploy.commtemplate");
            if (commTemplate == null || commTemplate.trim().length() == 0) {
                commTemplate = "INFORMER";
            }
            commSet = MXServer.getMXServer().getMboSet("COMMTEMPLATE", MXServer.getMXServer().getSystemUserInfo());
            SqlFormat sqlf = new SqlFormat("templateid = :1");
            sqlf.setObject(1, "COMMTEMPLATE", "TEMPLATEID", commTemplate);
            commSet.setWhere(sqlf.format());
            commSet.reset();
            CommTemplateRemote comm = null;
            if (!commSet.isEmpty()) {
                comm = (CommTemplateRemote)commSet.getMbo(0);
            } else {
                comm = (CommTemplateRemote)commSet.add();
                comm.setValue("TEMPLATEID", "INFORMER");
                comm.setValue("DESCRIPTION", "Informer application link template");
                comm.setValue("OBJECTNAME", "ISNOTIFYUSER");
                comm.setValue("SENDFROM", MXServer.getMXServer().getProperty("mxe.adminEmail"));
                comm.setValue("SUBJECT", ":notify.description application download link.");
                comm.setValue("MESSAGE", "<div>Please find the download link for the :notify.description application below.</div><div>\n</div><br/><div>To install click <a href=\":applinkurl\" target=\"_self\">here</a>.</div><!-- RICH TEXT -->");
                comm.setValue("STATUS", "ACTIVE", 2L);
                commSet.save();
            }
            if (!"ISNOTIFYUSER".equals(comm.getString("OBJECTNAME"))) {
                throw new MXApplicationException("informer", "commMustBeNotifyUser");
            }
            String to = comm.convertSendTo("COMMTMPLT_TO", (MboRemote)this);
            String cc = comm.convertSendTo("COMMTMPLT_CC", (MboRemote)this);
            String bcc = comm.convertSendTo("COMMTMPLT_BCC", (MboRemote)this);
            if ((to = to == null || to.trim().length() == 0 ? this.getString("MAXUSER.PERSON.PRIMARYEMAIL") : to + "," + this.getString("MAXUSER.PERSON.PRIMARYEMAIL")) == null || to.trim().length() == 0) {
                Object[] args = new String[]{this.getString("USERID")};
                throw new MXApplicationException("informer", "userNoemail", args);
            }
            SqlFormat sqf = new SqlFormat((MboRemote)this, comm.getString("SENDFROM"));
            sqf.setIgnoreUnresolved(true);
            String sendFrom = sqf.resolveContent();
            sqf = new SqlFormat((MboRemote)this, comm.getString("SUBJECT"));
            sqf.setIgnoreUnresolved(true);
            String subject = sqf.resolveContent();
            sqf = new SqlFormat((MboRemote)this, comm.getString("MESSAGE"));
            sqf.setIgnoreUnresolved(true);
            String message2 = sqf.resolveContent();
            if (message2.length() > 0) {
                message2 = message2 + "\r\n";
            }
            MXServer.sendEMail((String)to, (String)cc, (String)bcc, (String)sendFrom, (String)subject, (String)message2, (String)comm.getString("REPLYTO"), null, null);
        }
        catch (MessagingException e) {
            try {
                NotifyConstants.INFORMER_LOGGER.error((Object)"Error sending application link.", (Throwable)e);
                Object[] args = new String[]{e.getMessage()};
                throw new MXApplicationException("informer", "messageError", args);
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(commSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(commSet);
    }

    protected void save() throws MXException, RemoteException {
        if (this.toBeAdded()) {
            NotifyUserSet.Companion.enforceUserCount(this.getThisMboSet());
        }
        super.save();
    }

    @Override
    public void setDeleteTransactable(@Nullable NotifyUserDeleteTransactable transactable) {
        this.deleteTransactable = transactable;
    }

    @Override
    @Nullable
    public NotifyUserDeleteTransactable getDeleteTransactable() {
        return this.deleteTransactable;
    }

    @Override
    @NotNull
    public NotifyUserDeleteTransactable newDeleteTransactable() {
        return new NotifyUserDeleteTransactable(this);
    }
}

