/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.DeviceSetRemote;
import com.interlocsolutions.maximo.notify.NotifySession;
import com.interlocsolutions.maximo.notify.NotifySessionHistorySetRemote;
import com.interlocsolutions.maximo.notify.NotifySesssionSetRemote;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import java.util.Calendar;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboServerInterface;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.MXException;

public class NotifySessionSet
extends MboSet
implements NotifySesssionSetRemote {
    private static final long serialVersionUID = -8378564215031852681L;

    public NotifySessionSet(MboServerInterface ms) throws RemoteException {
        super(ms);
    }

    protected Mbo getMboInstance(MboSet ms) throws MXException, RemoteException {
        return new NotifySession(ms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MboRemote addSession(SessionInfo session) throws RemoteException, MXException {
        if (!session.isValid()) {
            return null;
        }
        SqlFormat sqlf = new SqlFormat("sessionkey = :1");
        sqlf.setObject(1, "ISSESSION", "SESSIONKEY", session.getSessionKey());
        this.setWhere(sqlf.format());
        this.reset();
        MboRemote mbo = null;
        if (this.isEmpty()) {
            mbo = this.add();
            mbo.setValue("SESSIONKEY", session.getSessionKey());
            MboSetRemote userSet = null;
            try {
                userSet = MXServer.getMXServer().getMboSet("MAXUSER", MXServer.getMXServer().getSystemUserInfo());
                sqlf = new SqlFormat("userid = :1");
                sqlf.setObject(1, "MAXUSER", "USERID", session.getUserId());
                userSet.setWhere(sqlf.format());
                if (!userSet.isEmpty()) {
                    session.updateLoginId(userSet.getMbo(0).getString("LOGINID"));
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(userSet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(userSet);
            mbo.setValue("LOGINID", session.getLoginId());
            mbo.setValue("USERID", session.getUserId());
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(session.getTimeout());
            mbo.setValue("EXPIRES", c.getTime());
            mbo.setValue("LASTACTIVE", MXServer.getMXServer().getDate());
            long id = ((DeviceSetRemote)mbo.getMboSet("$adddevice", "ISDEVICE", "")).addDevice(session);
            mbo.setValue("DEVICEID", id);
            mbo.setValue("SUPPORTSCOMPRESSION", session.supportsCompressions());
            mbo.setValue("PROFILES", session.getProfiles());
            mbo.setValue("LANGCODE", session.getLangCode());
            mbo.setValue("SUPPORTSSQLITE", session.supportsSqlite());
            this.save();
            session.setSessionRowId(mbo.getUniqueIDValue());
            ((NotifySessionHistorySetRemote)mbo.getMboSet("ADDSESSIONHISTORY")).addSessionToHistory(session);
            this.save();
        } else {
            mbo = this.getMbo(0);
            NotifyConstants.INFORMER_LOGGER.warn((Object)String.format("A new session was requested, but an ISSESSION record already exists with key '%s'. Returning that instance instead.", session.getSessionKey()));
        }
        return mbo;
    }
}

