/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.DeviceSetRemote;
import com.interlocsolutions.maximo.notify.NotifySessionHistory;
import com.interlocsolutions.maximo.notify.NotifySessionHistorySetRemote;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import java.rmi.RemoteException;
import java.util.Date;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboServerInterface;
import psdi.mbo.MboSet;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.MXException;

public class NotifySessionHistorySet
extends MboSet
implements NotifySessionHistorySetRemote {
    private static final long serialVersionUID = -8046891696272339266L;

    public NotifySessionHistorySet(MboServerInterface ms) throws RemoteException {
        super(ms);
    }

    protected Mbo getMboInstance(MboSet ms) throws MXException, RemoteException {
        return new NotifySessionHistory(ms);
    }

    public void clearHistoryFrom(Date date) throws RemoteException, MXException {
    }

    @Override
    public void addSessionToHistory(SessionInfo session) throws RemoteException, MXException {
        SqlFormat sqlf = new SqlFormat("sessionkey = :1");
        sqlf.setObject(1, "ISSESSIONHISTORY", "SESSIONKEY", session.getSessionKey());
        this.setWhere(sqlf.format());
        this.reset();
        if (this.isEmpty()) {
            MboRemote history = this.add();
            history.setValue("SESSIONKEY", session.getSessionKey());
            history.setValue("USERID", session.getUserId());
            history.setValue("LOGINID", session.getLoginId());
            history.setValue("ACTIVE", new Date());
            long id = ((DeviceSetRemote)history.getMboSet("$adddevice", "ISDEVICE", "")).addDevice(session);
            history.setValue("DEVICEID", id);
            history.setValue("PROFILES", session.getProfiles());
            history.setValue("NODE", MXServer.getMXServer().getName());
            history.setValue("HOSTNAME", MXServer.getMXServer().getRegistryHostName());
            this.save();
        }
    }
}

