/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.NotifyResourceRemote;
import java.rmi.RemoteException;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class NotifyResource
extends Mbo
implements NotifyResourceRemote {
    public NotifyResource(MboSet ms) throws RemoteException {
        super(ms);
    }

    public void init() throws MXException {
        super.init();
        this.setFieldFlag("CREATEDATE", 7L, true);
        this.setFieldFlag("LANGCODE", 7L, true);
        if (!this.toBeAdded()) {
            String[] readOnlyAttributes = new String[]{"RESOURCETYPE"};
            this.setFieldFlag(readOnlyAttributes, 7L, true);
        }
        this.setFieldFlag("RESROUCETYPE", 128L, true);
        this.setFieldFlag("VERSION", 128L, true);
        this.setFieldFlag("NAME", 128L, true);
        try {
            MboRemote owner = this.getOwner();
            if (owner != null && owner.isBasedOn("ISNOTIFY") && !owner.getBoolean("ANONYMOUSACCESS")) {
                this.setFieldFlag("ISANONYMOUS", 7L, true);
            }
        }
        catch (RemoteException e) {
            throw new MXApplicationException("system", "remoteexception", (Throwable)e);
        }
    }

    public void add() throws MXException, RemoteException {
        super.add();
        if (this.getOwner() != null && this.getOwner().isBasedOn("ISNOTIFY")) {
            this.setValue("NOTIFYID", this.getOwner().getUniqueIDValue());
        }
        this.setValue("CREATEDATE", MXServer.getMXServer().getDate(), 2L);
        this.setValue("LANGCODE", this.getUserInfo().getLangCode(), 2L);
        this.setValue("RESOURCETYPE", "OTHER");
        this.setValue("VERSION", 0);
    }

    public void canDelete() throws MXException, RemoteException {
        if (!this.getMboSet("$NotifyResource", "ISSESSIONRESOURCE", "notifyresourceid = :notifyresourceid").isEmpty()) {
            throw new MXApplicationException("informer", "resourceInUse");
        }
        super.canDelete();
    }

    @Override
    public void addToSession(String sessionId) throws RemoteException, MXException {
        SqlFormat sqlf = new SqlFormat("sessionkey = :1");
        sqlf.setObject(1, "ISSESSION", "SESSIONKEY", sessionId);
        MboSetRemote sessionSet = this.getMboSet("$issession", "ISSESSION", sqlf.format());
        if (sessionSet != null && !sessionSet.isEmpty()) {
            MboRemote session = sessionSet.getMbo(0);
            sqlf = new SqlFormat("sessionid = :1 and notifyresourceid = :2");
            sqlf.setLong(1, session.getUniqueIDValue());
            sqlf.setLong(2, this.getUniqueIDValue());
            MboSetRemote sessionResourceSet = this.getMboSet("$isessionresource", "ISSESSIONRESOURCE", sqlf.format());
            sessionResourceSet.reset();
            if (sessionResourceSet.isEmpty()) {
                MboRemote sessionResource = sessionResourceSet.add();
                sessionResource.setValue("SESSIONID", session.getUniqueIDValue());
                sessionResourceSet.save();
            }
        } else {
            throw new MXApplicationException("informer", "invalidSession");
        }
    }

    @Override
    public void removeFromSession(String sessionId) throws RemoteException, MXException {
        SqlFormat sqlf = new SqlFormat("sessionkey = :1");
        sqlf.setObject(1, "ISSESSION", "SESSIONKEY", sessionId);
        MboSetRemote sessionSet = this.getMboSet("$issession", "ISSESSION", sqlf.format());
        if (sessionSet != null && !sessionSet.isEmpty()) {
            MboRemote session = sessionSet.getMbo(0);
            sqlf = new SqlFormat("sessionid = :1 and notifyresourceid = :2");
            sqlf.setLong(1, session.getUniqueIDValue());
            sqlf.setLong(2, this.getUniqueIDValue());
            MboSetRemote sessionResourceSet = this.getMboSet("$isessionresource", "ISSESSIONRESOURCE", sqlf.format());
            sessionResourceSet.reset();
            if (!sessionResourceSet.isEmpty()) {
                sessionResourceSet.getMbo(0).delete();
                sessionResourceSet.save();
            }
        } else {
            throw new MXApplicationException("informer", "invalidSession");
        }
    }
}

