/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.FileFragmentRemote;
import com.interlocsolutions.maximo.notify.NotifyResourceRemote;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.security.SessionManager;
import com.interlocsolutions.maximo.notify.security.datavalidator.GetAttachedDocumentValidationManager;
import com.interlocsolutions.maximo.notify.security.datavalidator.SendFileValidationManager;
import com.interlocsolutions.maximo.notify.util.AttachedDocumentProvider;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.MaximoVersion;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.notify.xml.AttachedDocumentFragment;
import com.interlocsolutions.maximo.notify.xml.LoginPublic;
import com.interlocsolutions.maximo.notify.xml.LoginPublicResponse;
import com.interlocsolutions.maximo.notify.xml.NotifyXMLUtils;
import com.interlocsolutions.maximo.notify.xml.ProfileResource;
import com.interlocsolutions.maximo.notify.xml.ProfileResourceList;
import com.interlocsolutions.maximo.notify.xml.ServerInfo;
import com.interlocsolutions.maximo.notify.xml.SupportedLanguage;
import com.interlocsolutions.maximo.notify.xml.SupportedLanguages;
import com.interlocsolutions.maximo.util.MXServerFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import javax.jws.WebMethod;
import javax.xml.bind.JAXBException;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.AdminModeManager;
import psdi.security.UserInfo;
import psdi.server.AppService;
import psdi.server.MXServer;
import psdi.server.MaxVarServiceRemote;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class NotifyPublicService
extends AppService {
    private long timeoutDuration = 600000L;
    private AdminModeManager ad;

    public NotifyPublicService(MXServer mxServer) throws RemoteException {
        super(mxServer);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="getResource", operationName="getResource")
    public String getResource(String sessionId, String profile, String resource, String langCode, int version, int offset, int length, UserInfo userInfo) throws NotifyFault {
        String string;
        if (this.isNullOrEmpty(profile)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
        }
        SessionInfo session = SessionManager.getValidNotifyAnonymousSessionForProfile(sessionId, profile, userInfo);
        MboSetRemote resourceSet = null;
        try {
            byte[] fragmentBytes;
            int bytesRead;
            byte[] resourceBytes;
            NotifyResourceRemote r;
            block14: {
                block13: {
                    resourceSet = MXServer.getMXServer().getMboSet("ISNOTIFYRESOURCE", MXServer.getMXServer().getSystemUserInfo());
                    SqlFormat sqlf = new SqlFormat("notifyid = (select notifyid from isnotify where notifynum = :1) and name = :2 and version = :3 and langCode = :4 and isanonymous = :yes");
                    sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", profile);
                    sqlf.setObject(2, "ISNOTIFYRESOURCE", "NAME", resource);
                    sqlf.setInt(3, version);
                    sqlf.setObject(4, "LANGUAGE", "MAXLANGCODE", langCode);
                    resourceSet.setWhere(sqlf.format());
                    if (resourceSet.isEmpty()) {
                        Object[] args = new String[]{profile, resource, String.valueOf(version)};
                        throw new NotifyFault((MXException)new MXApplicationException("informer", "invalidProfileResource", args));
                    }
                    r = (NotifyResourceRemote)resourceSet.getMbo(0);
                    r.addToSession(sessionId);
                    String data = r.getString("DATA");
                    resourceBytes = Base64.decodeBase64(data);
                    bytesRead = -1;
                    if (offset >= resourceBytes.length) break block13;
                    ByteArrayInputStream bais = new ByteArrayInputStream(resourceBytes);
                    bais.skip(offset);
                    fragmentBytes = new byte[length];
                    bytesRead = bais.read(fragmentBytes);
                    if (bytesRead == -1) {
                        fragmentBytes = new byte[]{};
                        break block14;
                    } else if (bytesRead < length) {
                        byte[] tmp = new byte[bytesRead];
                        System.arraycopy(fragmentBytes, 0, tmp, 0, bytesRead);
                        fragmentBytes = tmp;
                    }
                    break block14;
                }
                fragmentBytes = new byte[]{};
            }
            ProfileResource pr = new ProfileResource((long)resourceBytes.length, (long)offset, (long)fragmentBytes.length, fragmentBytes);
            if (bytesRead == -1 || offset + bytesRead == resourceBytes.length) {
                r.removeFromSession(sessionId);
            }
            String xml = InformerObjectSerializer.getInstance().serialize(pr, InformerObjectSerializer.MARSHAL_PPRINT);
            string = this.compressMessage(xml, session);
        }
        catch (RemoteException e) {
            try {
                throw new NotifyFault(e);
                catch (MXException e2) {
                    throw new NotifyFault(e2);
                }
                catch (IOException e3) {
                    throw new NotifyFault(e3);
                }
                catch (JAXBException e4) {
                    throw new NotifyFault((Exception)((Object)e4));
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(resourceSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(resourceSet);
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="getAvailableResources", operationName="getAvailableResources")
    public String getAvailableResources(String sessionId, String profile, UserInfo userInfo) throws NotifyFault {
        String string;
        if (this.isNullOrEmpty(profile)) {
            throw new NotifyFault((MXException)new MXApplicationException("informer", "notificationRequired"));
        }
        SessionInfo session = SessionManager.getValidNotifyAnonymousSessionForProfile(sessionId, profile, userInfo);
        MboSetRemote resourcesSet = null;
        try {
            MboRemote resource;
            resourcesSet = MXServer.getMXServer().getMboSet("ISNOTIFYRESOURCE", MXServer.getMXServer().getSystemUserInfo());
            SqlFormat sqlf = new SqlFormat("isanonymous = :yes and notifyid in (select notifyid from isnotify where notifynum = :1)");
            sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", profile);
            resourcesSet.setWhere(sqlf.format());
            resourcesSet.reset();
            ProfileResourceList prl = new ProfileResourceList();
            while ((resource = resourcesSet.getMbo(0)) != null) {
                if (session.isAnonymous()) {
                    prl.addResource(resource);
                }
                resourcesSet.remove(0);
            }
            String xml = InformerObjectSerializer.getInstance().serialize(prl, InformerObjectSerializer.MARSHAL_PPRINT);
            string = this.compressMessage(xml, session);
        }
        catch (RemoteException e) {
            try {
                throw new NotifyFault(e);
                catch (MXException e2) {
                    throw new NotifyFault(e2);
                }
                catch (JAXBException e3) {
                    throw new NotifyFault((Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(resourcesSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(resourcesSet);
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="sendFile", operationName="sendFile")
    public String sendFile(String sessionId, String fragment, String fileId, String docType, String fileName, String description, boolean complete, boolean isCompressed, UserInfo userInfo) throws NotifyFault {
        SessionInfo session = SessionManager.getValidNotifyAnonymousSession(sessionId, userInfo);
        MboSetRemote fileFragmentSet = null;
        FileFragmentRemote fileFragment = null;
        fileName = this.sanitizeFileName(fileName);
        try {
            fileFragmentSet = MXServer.getMXServer().getMboSet("ISFILEFRAGMENT", NotifyUtil.getLocalUserInfo(session.getUserId()));
            if (fileId == null || fileId.trim().length() <= 0) {
                SendFileValidationManager.validateFileToReceive(session, docType, fileName);
                fileId = UUID.randomUUID().toString();
                fileFragment = (FileFragmentRemote)fileFragmentSet.add();
                fileFragment.setValue("FILEID", fileId);
                fileFragment.setValue("DOCTYPE", docType);
                fileFragment.setValue("DESCRIPTION", description);
                fileFragment.setValue("FILENAME", fileName);
            } else {
                SqlFormat sqlf = new SqlFormat("fileid = :1");
                sqlf.setObject(1, "ISFILEFRAGMENT", "FILEID", fileId);
                fileFragmentSet.setWhere(sqlf.format());
                fileFragmentSet.reset();
                if (fileFragmentSet.isEmpty()) {
                    Object[] args = new String[]{fileId};
                    throw new MXApplicationException("informer", "fileIdNotFound", args);
                }
                fileFragment = (FileFragmentRemote)fileFragmentSet.getMbo(0);
            }
            byte[] data = Base64.decodeBase64(fragment);
            if (isCompressed) {
                data = NotifyXMLUtils.decompressMessage(data);
            }
            if (fileFragment.isNull("DATA")) {
                fileFragment.setValue("DATA", data);
            } else {
                byte[] existingData = fileFragment.getBytes("DATA");
                byte[] buffer = new byte[existingData.length + data.length];
                System.arraycopy(existingData, 0, buffer, 0, existingData.length);
                System.arraycopy(data, 0, buffer, existingData.length, data.length);
                fileFragment.setValue("DATA", buffer);
            }
            if (complete) {
                fileFragmentSet.save();
                long docInfoId = SendFileValidationManager.validateAndFinalizeReceivedFile(session, docType, fileName, fileFragment);
                NumberFormat nf = NumberFormat.getNumberInstance();
                nf.setGroupingUsed(false);
                fileId = nf.format(docInfoId);
                long id = fileFragment.getUniqueIDValue();
                NotifyUtil.closeAndCleanup(fileFragmentSet);
                fileFragmentSet = MXServer.getMXServer().getMboSet("ISFILEFRAGMENT", NotifyUtil.getLocalUserInfo(session.getUserId()));
                fileFragmentSet.getMboForUniqueId(id).delete();
                fileFragmentSet.save();
            }
            fileFragmentSet.save();
        }
        catch (NotifyFault e) {
            try {
                throw e;
                catch (RemoteException e2) {
                    throw new NotifyFault(e2);
                }
                catch (MXException e3) {
                    throw new NotifyFault(e3);
                }
                catch (IOException e4) {
                    throw new NotifyFault(e4);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(fileFragmentSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(fileFragmentSet);
        return fileId;
    }

    @WebMethod(action="getAttachedDocument", operationName="getAttachedDocument")
    public String getAttachedDocument(String sessionId, long docInfoId, long offset, int length, UserInfo userInfo) throws NotifyFault {
        SessionInfo session = SessionManager.getValidNotifyAnonymousSession(sessionId, userInfo);
        try {
            AttachedDocumentProvider adp;
            AttachedDocumentFragment ad;
            GetAttachedDocumentValidationManager.validateGetAttachedDocument(session, docInfoId);
            String provider = MXServer.getMXServer().getProperty("informer.attacheddocument.provider");
            if (provider == null || provider.trim().length() == 0) {
                provider = "com.interlocsolutions.maximo.notify.util.DefaultAttachedDocumentProvider";
            }
            if ((ad = (adp = (AttachedDocumentProvider)Class.forName(provider).newInstance()).getAttachedDocumentFragment(docInfoId, offset, length)) == null) {
                NotifyFault nf = new NotifyFault(AttachedDocumentProvider.ERROR_CODE.DOCINFO_NOT_FOUND.toString());
                nf.setFaultCodeAsString(AttachedDocumentProvider.ERROR_CODE.DOCINFO_NOT_FOUND.toString());
                throw nf;
            }
            return this.compressMessage(InformerObjectSerializer.getInstance().serialize(ad), session);
        }
        catch (NotifyFault f) {
            throw f;
        }
        catch (MXException e) {
            throw new NotifyFault(e);
        }
        catch (Exception e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)"Unexpected error getting attached document:", (Throwable)e);
            throw new NotifyFault(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebMethod(action="login", operationName="login")
    public String login(String profile, String xml) throws NotifyFault {
        String string;
        MboSetRemote userSet;
        MboSetRemote notifySet;
        MboSetRemote langSet;
        block30: {
            String string2;
            block29: {
                String string3;
                block28: {
                    String string4;
                    block27: {
                        String string5;
                        block26: {
                            String string6;
                            block25: {
                                String string7;
                                block24: {
                                    LoginPublicResponse lpr = new LoginPublicResponse();
                                    langSet = null;
                                    notifySet = null;
                                    userSet = null;
                                    try {
                                        if (MXServer.getMXServer().isAdminModeOn(false) || MXServer.getMXServer().isAdminModePending()) {
                                            lpr.setResponseMessage("Server is in admin mode and is not accepting logins.");
                                            lpr.setResponse(LoginPublicResponse.LoginResponse.ADMIN_MODE);
                                            String string8 = InformerObjectSerializer.getInstance().serialize(lpr, InformerObjectSerializer.MARSHAL_PPRINT);
                                            return string8;
                                        }
                                        if (this.isNullOrEmpty(profile)) {
                                            throw new NotifyFault("informer", "noProfileExtras");
                                        }
                                        SqlFormat sqlf = new SqlFormat("notifynum = :1 and active = :yes and anonymousaccess = :yes");
                                        sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", profile);
                                        notifySet = MXServer.getMXServer().getMboSet("ISNOTIFY", MXServer.getMXServer().getSystemUserInfo());
                                        notifySet.setWhere(sqlf.format());
                                        if (notifySet.isEmpty()) {
                                            Object[] args = new String[]{profile};
                                            lpr.setResponseMessage(MXServer.getMXServer().getMaxMessageCache().getTaggedMessage("informer", "noPublicProfile").getMessage(args));
                                            lpr.setResponse(LoginPublicResponse.LoginResponse.ERROR);
                                            string7 = InformerObjectSerializer.getInstance().serialize(lpr, InformerObjectSerializer.MARSHAL_PPRINT);
                                            NotifyUtil.closeAndCleanup(langSet);
                                            break block24;
                                        }
                                        MboRemote notify = notifySet.getMbo(0);
                                        if (this.isNullOrEmpty(xml)) {
                                            lpr.setResponseMessage(MXServer.getMXServer().getMaxMessageCache().getTaggedMessage("informer", "noPubLoginXML").getMessage());
                                            lpr.setResponse(LoginPublicResponse.LoginResponse.ERROR);
                                            string6 = InformerObjectSerializer.getInstance().serialize(lpr, InformerObjectSerializer.MARSHAL_PPRINT);
                                            NotifyUtil.closeAndCleanup(langSet);
                                            break block25;
                                        }
                                        LoginPublic lp = (LoginPublic)InformerObjectSerializer.getInstance().deserialize(new StringReader(xml));
                                        if (!lp.isAnonymous()) {
                                            lpr.setResponse(LoginPublicResponse.LoginResponse.INVALID_CREDENTIALS);
                                            string5 = InformerObjectSerializer.getInstance().serialize(lpr, InformerObjectSerializer.MARSHAL_PPRINT);
                                            NotifyUtil.closeAndCleanup(langSet);
                                            break block26;
                                        }
                                        if (!notify.getBoolean("ANONYMOUSACCESS")) {
                                            Object[] args = new String[]{profile};
                                            lpr.setResponseMessage(MXServer.getMXServer().getMaxMessageCache().getTaggedMessage("informer", "noAnonProfile").getMessage(args));
                                            lpr.setResponse(LoginPublicResponse.LoginResponse.ERROR);
                                            string4 = InformerObjectSerializer.getInstance().serialize(lpr, InformerObjectSerializer.MARSHAL_PPRINT);
                                            NotifyUtil.closeAndCleanup(langSet);
                                            break block27;
                                        }
                                        String langCode = lp.getLangCode();
                                        if (!this.isNullOrEmpty(langCode)) {
                                            langSet = MXServerFactory.getMXServer().getMboSet("LANGUAGE", MXServerFactory.getMXServer().getSystemUserInfo());
                                            sqlf = new SqlFormat("maxlangcode = :1 and enabled = :yes");
                                            sqlf.setObject(1, "LANGUAGE", "MAXLANGCODE", langCode);
                                            langSet.setWhere(sqlf.format());
                                            if (langSet.isEmpty()) {
                                                Object[] args = new String[]{langCode};
                                                lpr.setResponseMessage(MXServer.getMXServer().getMaxMessageCache().getTaggedMessage("informer", "invalidLanguage").getMessage(args));
                                                lpr.setResponse(LoginPublicResponse.LoginResponse.ERROR);
                                                string3 = InformerObjectSerializer.getInstance().serialize(lpr, InformerObjectSerializer.MARSHAL_PPRINT);
                                                NotifyUtil.closeAndCleanup(langSet);
                                                break block28;
                                            }
                                        }
                                        userSet = MXServer.getMXServer().getMboSet("MAXUSER", MXServer.getMXServer().getSystemUserInfo());
                                        userSet.setQbe("loginid", "=" + notify.getString("ANONYMOUSUSER"));
                                        if (userSet.isEmpty()) {
                                            Object[] args = new String[]{profile};
                                            lpr.setResponseMessage(MXServer.getMXServer().getMaxMessageCache().getTaggedMessage("informer", "noAnonProfile").getMessage(args));
                                            lpr.setResponse(LoginPublicResponse.LoginResponse.ERROR);
                                            string2 = InformerObjectSerializer.getInstance().serialize(lpr, InformerObjectSerializer.MARSHAL_PPRINT);
                                            NotifyUtil.closeAndCleanup(langSet);
                                            break block29;
                                        }
                                        MboRemote user = userSet.getMbo(0);
                                        lpr.setResponse(LoginPublicResponse.LoginResponse.SUCCESS);
                                        this.createSession(lpr, user, lp.getLangCode(), profile, lp.isSupportsCompression(), lp.getPlatform());
                                        string = InformerObjectSerializer.getInstance().serialize(lpr, InformerObjectSerializer.MARSHAL_PPRINT);
                                        NotifyUtil.closeAndCleanup(langSet);
                                        break block30;
                                    }
                                    catch (JAXBException e) {
                                        NotifyConstants.INFORMER_LOGGER.error((Object)"An error occurred while parsing the public login xml.");
                                        NotifyConstants.INFORMER_LOGGER.error((Object)e);
                                        throw new NotifyFault((Exception)((Object)e));
                                    }
                                    catch (RemoteException e) {
                                        throw new NotifyFault(e);
                                    }
                                    catch (MXException e) {
                                        throw new NotifyFault(e);
                                    }
                                    catch (Throwable t) {
                                        throw new NotifyFault(t);
                                    }
                                }
                                NotifyUtil.closeAndCleanup(notifySet);
                                NotifyUtil.closeAndCleanup(userSet);
                                return string7;
                            }
                            NotifyUtil.closeAndCleanup(notifySet);
                            NotifyUtil.closeAndCleanup(userSet);
                            return string6;
                        }
                        NotifyUtil.closeAndCleanup(notifySet);
                        NotifyUtil.closeAndCleanup(userSet);
                        return string5;
                    }
                    NotifyUtil.closeAndCleanup(notifySet);
                    NotifyUtil.closeAndCleanup(userSet);
                    return string4;
                }
                NotifyUtil.closeAndCleanup(notifySet);
                NotifyUtil.closeAndCleanup(userSet);
                return string3;
            }
            NotifyUtil.closeAndCleanup(notifySet);
            NotifyUtil.closeAndCleanup(userSet);
            return string2;
        }
        NotifyUtil.closeAndCleanup(notifySet);
        NotifyUtil.closeAndCleanup(userSet);
        return string;
        finally {
            NotifyUtil.closeAndCleanup(langSet);
            NotifyUtil.closeAndCleanup(notifySet);
            NotifyUtil.closeAndCleanup(userSet);
        }
    }

    @WebMethod(action="logout", operationName="logout")
    public void logout(String sessionId) throws RemoteException {
        try {
            SessionManager.removeSession(sessionId);
        }
        catch (Exception e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
        }
    }

    /*
     * Exception decompiling
     */
    @WebMethod(action="executeCommand", operationName="executeCommand")
    public String executeCommand(String sessionId, String profile, String command, String xml, boolean isCompressed, UserInfo userInfo) throws NotifyFault {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 21[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @WebMethod(action="getSystemLanguages", operationName="getSystemLanguages")
    public String getSystemLanguages() throws NotifyFault {
        try {
            String baseLang = MXServer.getMXServer().getBaseLang();
            String[][] langList = MXServer.getMXServer().getLanguageList();
            Collection<String> informerLangs = NotifyUtil.getLangCodes();
            ArrayList<SupportedLanguage> languages = new ArrayList<SupportedLanguage>();
            for (String[] langInfo : langList) {
                String langCode = langInfo[0].toUpperCase();
                if (!informerLangs.contains(langCode)) continue;
                String langName = langInfo[1];
                Boolean isBaseLang = baseLang.equals(langCode) ? Boolean.valueOf(true) : null;
                languages.add(new SupportedLanguage(langCode, langName, isBaseLang));
            }
            SupportedLanguages sl = new SupportedLanguages();
            sl.setLanguages(languages);
            return NotifyXMLUtils.getLanguages(sl);
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)"An error occurred while getting languages.");
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
        catch (MXException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)"An error occurred while while getting languages.");
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            throw new NotifyFault(e);
        }
    }

    @WebMethod(action="getVersion", operationName="getVersion")
    public String getVersion() throws NotifyFault {
        try {
            if (this.ad == null) {
                this.ad = (AdminModeManager)MXServer.getMXServer().getFromMaximoCache("ADMINMODE");
            }
            if (this.ad != null && (this.ad.isAdminModePendingThisInstance() || this.ad.isAdminModeOnThisInstance())) {
                NotifyFault nf = new NotifyFault("Admin mode is either pending or active.");
                nf.setFaultCodeAsString("ADMIN_MODE");
                throw nf;
            }
        }
        catch (RemoteException e) {
            throw new NotifyFault(e);
        }
        return "6.4.1-rc.2";
    }

    @WebMethod(action="getServerInfo", operationName="getServerInfo")
    public String getServerInfo() throws NotifyFault {
        try {
            if (this.ad == null) {
                this.ad = (AdminModeManager)MXServer.getMXServer().getFromMaximoCache("ADMINMODE");
            }
            MaxVarServiceRemote mvs = (MaxVarServiceRemote)MXServer.getMXServer().lookup("MAXVARS");
            String instanceID = mvs.getString("INFORMERINSTID", null);
            ServerInfo si = new ServerInfo("6.4.1-rc.2", instanceID);
            try {
                String maximoVersion = MaximoVersion.Companion.getSystemVersion().majorVersion + "." + MaximoVersion.Companion.getSystemVersion().minorVersion + "." + MaximoVersion.Companion.getSystemVersion().modLevel + "." + MaximoVersion.Companion.getSystemVersion().patch;
                si.setMaximoVersion(maximoVersion);
            }
            catch (Exception e) {
                si.setMaximoVersion("UNKNOWN");
            }
            if (this.ad != null && (this.ad.isAdminModePendingThisInstance() || this.ad.isAdminModeOnThisInstance())) {
                si.setStatus("ADMIN_MODE");
            } else {
                si.setStatus("ACTIVE");
            }
            return InformerObjectSerializer.getInstance().serialize(si, InformerObjectSerializer.MARSHAL_PPRINT);
        }
        catch (JAXBException e) {
            Object[] args = new String[]{"Session", e.getMessage()};
            throw new NotifyFault((MXException)new MXApplicationException("informer", "jaxberror", args));
        }
        catch (RemoteException e) {
            throw new NotifyFault(e);
        }
        catch (MXException e) {
            throw new NotifyFault(e);
        }
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void createSession(LoginPublicResponse lpr, MboRemote maxUser, String langCode, String profile, boolean compression, LoginPublic.Platform platform) {
        block17: {
            MboSetRemote sessionSet = null;
            try {
                long timeout;
                try {
                    this.timeoutDuration = Long.parseLong(MXServerFactory.getMXServer().getProperty("informer.session.timeout"));
                    if (this.timeoutDuration > 0L) {
                        this.timeoutDuration *= 60000L;
                    }
                }
                catch (NumberFormatException e) {
                    NotifyConstants.INFORMER_LOGGER.warn((Object)"The property informer.session.timeout could not be parsed, using default value of 10 minutes.");
                }
                catch (RemoteException e) {
                    NotifyConstants.INFORMER_LOGGER.warn((Object)"The property informer.session.timeout could not be read, using default value of 10 minutes.");
                }
                catch (MXException e) {
                    NotifyConstants.INFORMER_LOGGER.warn((Object)"The property informer.session.timeout could not be read, using default value of 10 minutes.");
                }
                if (this.timeoutDuration <= 0L) {
                    this.timeoutDuration = 600000L;
                }
                try {
                    timeout = MXServer.getMXServer().getDate().getTime() + this.timeoutDuration;
                }
                catch (RemoteException e) {
                    timeout = System.currentTimeMillis() + this.timeoutDuration;
                }
                Date expires = new Date(timeout);
                String userId = maxUser.getString("USERID");
                if (this.isNullOrEmpty(langCode)) {
                    langCode = NotifyUtil.getLocalUserInfo(userId).getDefaultLang();
                }
                sessionSet = MXServer.getMXServer().getMboSet("ISSESSION", MXServer.getMXServer().getSystemUserInfo());
                MboRemote session = sessionSet.add();
                session.setValue("LOGINID", maxUser.getString("LOGINID"));
                session.setValue("USERID", userId);
                session.setValue("EXPIRES", expires);
                session.setValue("LANGCODE", langCode);
                session.setValue("LASTACTIVE", MXServer.getMXServer().getDate());
                session.setValue("NODE", MXServer.getMXServer().getName());
                session.setValue("HOSTNAME", MXServer.getMXServer().getRegistryHostName());
                session.setValue("PROFILES", profile);
                session.setValue("SESSIONKEY", UUID.randomUUID().toString());
                session.setValue("SUPPORTSCOMPRESSION", compression);
                session.setValue("ISANONYMOUS", true);
                if (platform != null) {
                    session.setValue("PLATFORM", platform.toString());
                }
                sessionSet.save();
                lpr.setExpires(expires);
                lpr.setSessionId(session.getString("SESSIONKEY"));
                NotifyUtil.closeAndCleanup(sessionSet);
            }
            catch (RemoteException e) {
                NotifyConstants.INFORMER_LOGGER.error((Object)e);
            }
            catch (MXException e2) {
                NotifyConstants.INFORMER_LOGGER.error((Object)e2);
                break block17;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                NotifyUtil.closeAndCleanup(sessionSet);
            }
        }
    }

    private String compressMessage(String message2, SessionInfo session) throws RemoteException, MXException {
        if (session.supportsCompressions() && (long)message2.getBytes().length > this.getCompressionThreshold()) {
            message2 = "<compressed>\n" + NotifyXMLUtils.compressMessage(message2) + "\n</compressed>";
        }
        return message2;
    }

    private long getCompressionThreshold() throws RemoteException, MXException {
        String val = MXServerFactory.getMXServer().getProperty("informer.compression.threshold", "4096");
        try {
            return Long.valueOf(val);
        }
        catch (Exception e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            return 4096L;
        }
    }

    private String sanitizeFileName(String fileName) {
        File file = new File(fileName);
        return file.getName();
    }
}

