/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.NotifyEvent;
import com.interlocsolutions.maximo.notify.err.NoSuchCatalogException;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.xml.NotificationEvent;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.event.EventListener;
import psdi.server.event.EventMessage;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class NotifyListener
implements EventListener {
    private Object syncLock = null;
    private String userId = null;
    private MXLogger logger = NotifyConstants.INFORMER_LOGGER;
    private String objectName = null;
    private List<String> notificationNames = null;
    private long recordId = 0L;
    private long notificationId = 0L;
    private NotifyEvent event = null;
    private NotificationEvent.EVENT_TYPE type = NotificationEvent.EVENT_TYPE.NOTIFICATION;
    private long deviceId = 0L;

    public NotifyListener(String userId, Object syncLock) {
        this.syncLock = syncLock;
        this.userId = userId;
    }

    public NotifyListener(String userId, Object syncLock, List<String> notificationNames) {
        this.syncLock = syncLock;
        this.userId = userId;
        this.notificationNames = notificationNames;
    }

    public NotifyListener(String userId, Object syncLock, List<String> notificationNames, long deviceId) {
        this.syncLock = syncLock;
        this.userId = userId;
        this.notificationNames = notificationNames;
        this.deviceId = deviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommitEventAction(EventMessage event) throws MXException {
        block21: {
            try {
                MboRemote eventObject;
                block23: {
                    if (!(event.getEventObject() instanceof MboRemote)) break block21;
                    eventObject = (MboRemote)event.getEventObject();
                    if (eventObject.getName().equalsIgnoreCase("ISUSERNOTIFICATION")) {
                        if (!this.userId.equalsIgnoreCase(eventObject.getString("USERID"))) break block21;
                        String notificationName = eventObject.getString("notify.notifynum");
                        if (!this.isNotificationNameOfInterest(notificationName)) {
                            return;
                        }
                        this.notificationId = eventObject.getUniqueIDValue();
                        this.recordId = eventObject.getLong("RECORDID");
                        this.objectName = eventObject.getString("OBJECTNAME");
                        Date lastUpdate = eventObject.getDate("LASTUPDATE");
                        boolean active = eventObject.getBoolean("ACTIVE");
                        this.type = NotificationEvent.EVENT_TYPE.NOTIFICATION;
                        this.event = new NotifyEvent(this.notificationId, this.recordId, this.objectName, notificationName, lastUpdate, active, this.type, eventObject.getLong("SEQUENCE"));
                        Object object = this.syncLock;
                        synchronized (object) {
                            this.syncLock.notify();
                            break block21;
                        }
                    }
                    if (!eventObject.getName().equalsIgnoreCase("ISCATALOGDATA")) break block23;
                    try {
                        CachedCatalog catInfo = NotificationEventListenerManager.CatalogCache.getCatalogOrThrow(eventObject.getLong("CATALOGID"), eventObject.getLong("REVISION"));
                        String notificationName = catInfo.notifyNum;
                        if (!this.isNotificationNameOfInterest(notificationName)) {
                            return;
                        }
                        long catalogId = catInfo.catalogId;
                        String catalog = catInfo.catalogName;
                        Date lastUpdate = eventObject.getDate("CHANGEDATE");
                        String catalogPartitionName = null;
                        if (this.deviceId > 0L) {
                            MboSetRemote catalogDeviceSet;
                            block22: {
                                SqlFormat catalogDeviceFormat;
                                if (eventObject.isNull("PARTITIONNAME")) {
                                    catalogDeviceFormat = new SqlFormat("catalogid = :1 AND devicekey = :2 AND partitionname is null");
                                    catalogDeviceFormat.setLong(1, catInfo.catalogId);
                                    catalogDeviceFormat.setLong(2, this.deviceId);
                                } else {
                                    catalogDeviceFormat = new SqlFormat("catalogid = :1 AND devicekey = :2 AND (partitionname = :3 OR partitionname is null)");
                                    catalogDeviceFormat.setLong(1, catInfo.catalogId);
                                    catalogDeviceFormat.setLong(2, this.deviceId);
                                    catalogDeviceFormat.setObject(3, "ISCATALOGDEVICE", "PARTITIONNAME", eventObject.getString("PARTITIONNAME"));
                                }
                                catalogDeviceSet = null;
                                try {
                                    catalogDeviceSet = eventObject.getMboSet("$catalogdevice" + this.deviceId, "ISCATALOGDEVICE", catalogDeviceFormat.format());
                                    catalogDeviceSet.reset();
                                    if (catalogDeviceSet.isEmpty()) break block22;
                                    MboRemote catalogDevice = catalogDeviceSet.getMbo(0);
                                    catalogPartitionName = catalogDevice.isNull("PARTITIONNAME") ? null : catalogDevice.getString("PARTITIONNAME");
                                }
                                catch (Throwable throwable) {
                                    NotifyUtil.closeAndCleanup(catalogDeviceSet);
                                    throw throwable;
                                }
                            }
                            NotifyUtil.closeAndCleanup(catalogDeviceSet);
                            return;
                            NotifyUtil.closeAndCleanup(catalogDeviceSet);
                        }
                        this.type = NotificationEvent.EVENT_TYPE.CATALOG;
                        this.recordId = eventObject.getLong("RECORDID");
                        this.event = new NotifyEvent(catalogId, catalog, catalogPartitionName, this.recordId, lastUpdate, this.type);
                        this.event.setNotificationName(notificationName);
                        Object object = this.syncLock;
                        synchronized (object) {
                            this.syncLock.notify();
                            break block21;
                        }
                    }
                    catch (NoSuchCatalogException noSuchCatalogException) {}
                    break block21;
                }
                if (!eventObject.getName().equalsIgnoreCase("ISCATALOGDEVICE") || this.deviceId != eventObject.getLong("DEVICEKEY")) break block21;
                this.type = NotificationEvent.EVENT_TYPE.CATALOG;
                long catalogId = eventObject.getLong("CATALOGID");
                String catalog = eventObject.getMboSet("CATALOG").getMbo(0).getString("CATALOG");
                String catalogPartitionName = eventObject.isNull("PARTITIONNAME") ? null : eventObject.getString("PARTITIONNAME");
                this.event = new NotifyEvent(catalogId, catalog, catalogPartitionName, this.recordId, new Date(), this.type);
                this.event.setNotificationName(eventObject.getString("CATALOG.NOTIFY.NOTIFYNUM"));
                this.event.setCatalogReset(true);
                Object object = this.syncLock;
                synchronized (object) {
                    this.syncLock.notify();
                }
            }
            catch (RemoteException e) {
                this.logger.error((Object)e);
            }
        }
    }

    boolean isNotificationNameOfInterest(String notificationName) {
        if (this.notificationNames != null) {
            boolean found = false;
            for (String name : this.notificationNames) {
                if (!name.equalsIgnoreCase(notificationName)) continue;
                found = true;
                break;
            }
            return found;
        }
        return true;
    }

    public NotifyEvent getNotifyEvent() {
        return this.event;
    }

    public void eventAction(EventMessage event) throws MXException {
    }

    public void preSaveEventAction(EventMessage event) throws MXException {
    }

    public boolean eventValidate(EventMessage event) throws MXException {
        return true;
    }
}

