/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.server.event.EventListener;
import psdi.server.event.EventMessage;
import psdi.util.MXException;

public class NotifyDeviceAssetListener
implements EventListener {
    public void eventAction(EventMessage em) throws MXException {
    }

    public boolean eventValidate(EventMessage em) throws MXException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommitEventAction(EventMessage em) throws MXException {
        if (em.getEventName().toLowerCase().endsWith("delete") && em.getEventObject() != null && em.getEventObject() instanceof MboRemote) {
            MboRemote asset = (MboRemote)em.getEventObject();
            MboSetRemote deviceSet = null;
            try {
                if (asset.isBasedOn("ASSET")) {
                    deviceSet = MXServer.getMXServer().getMboSet("ISDEVICE", MXServer.getMXServer().getSystemUserInfo());
                    SqlFormat sqlf = new SqlFormat("assetid = :1");
                    sqlf.setLong(1, asset.getUniqueIDValue());
                    deviceSet.setWhere(sqlf.format());
                    if (!deviceSet.isEmpty()) {
                        MboRemote device = deviceSet.moveFirst();
                        while (device != null) {
                            device.setValueNull("ASSETID");
                            device = deviceSet.moveNext();
                        }
                        deviceSet.save();
                    }
                }
            }
            catch (RemoteException e) {
                NotifyConstants.INFORMER_LOGGER.warn((Object)"Error clearing asset id from associated device", (Throwable)e);
            }
            finally {
                NotifyUtil.closeAndCleanup(deviceSet);
            }
        }
    }

    public void preSaveEventAction(EventMessage em) throws MXException {
    }
}

