/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.DeviceRemote;
import com.interlocsolutions.maximo.notify.DeviceSetRemote;
import com.interlocsolutions.maximo.notify.LoginRequest;
import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.security.Authenticator;
import com.interlocsolutions.maximo.notify.security.Authenticator2;
import com.interlocsolutions.maximo.notify.security.Authenticator2Adapter;
import com.interlocsolutions.maximo.notify.security.Authenticator3;
import com.interlocsolutions.maximo.notify.security.AuthenticatorAdapter;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.security.SessionManager;
import com.interlocsolutions.maximo.notify.security.UserIdentifier;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.MaxMessageUtilsKt;
import com.interlocsolutions.maximo.notify.util.MaximoVersion;
import com.interlocsolutions.maximo.notify.util.MboExtensionsKt;
import com.interlocsolutions.maximo.notify.util.MboSetRemoteClosableWrapper;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.xml.LoginExtras;
import com.interlocsolutions.maximo.notify.xml.NotificationSession;
import java.io.Closeable;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aBG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\t\u0010\u0017\u001a\u00020\u0016H\u0086\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/interlocsolutions/maximo/notify/LoginRequest;", "", "loginId", "", "password", "deviceName", "deviceSerialNumber", "deviceOS", "compressionSupported", "", "extras", "userInfo", "Lpsdi/security/UserInfo;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Lpsdi/security/UserInfo;)V", "Lcom/interlocsolutions/maximo/notify/xml/LoginExtras;", "logger", "Lpsdi/util/logging/MXLogger;", "profiles", "", "supportsSqlite", "userSpecifiedLangCode", "evaluate", "Lcom/interlocsolutions/maximo/notify/xml/NotificationSession;", "invoke", "Companion", "ErrorCodes", "LoginResponses", "isinformer"})
public final class LoginRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String loginId;
    @NotNull
    private final String password;
    @NotNull
    private final String deviceName;
    @NotNull
    private final String deviceSerialNumber;
    @NotNull
    private final String deviceOS;
    private final boolean compressionSupported;
    @NotNull
    private final UserInfo userInfo;
    @NotNull
    private final MXLogger logger;
    @NotNull
    private final LoginExtras extras;
    private final boolean supportsSqlite;
    @Nullable
    private final String userSpecifiedLangCode;
    @NotNull
    private List<String> profiles;
    @NotNull
    public static final String DEFAULT_AUTHENTICATOR = "com.interlocsolutions.maximo.notify.security.MaximoAuthenticator";
    @NotNull
    public static final String NO_CHECK_AUTHENTICATOR = "com.interlocsolutions.maximo.notify.security.NoCheckAuthenticator";
    @NotNull
    public static final String PROP_AUTHENTICATOR = "informer.authenticator";
    @NotNull
    public static final String DEFAULT_USER_IDENTIFIER = "com.interlocsolutions.maximo.notify.security.DefaultUserIdentifier";
    @NotNull
    public static final String PROP_USER_IDENTIFIER = "informer.userIdentifier";

    /*
     * WARNING - void declaration
     */
    public LoginRequest(@NotNull String loginId, @NotNull String password, @NotNull String deviceName, @NotNull String deviceSerialNumber, @NotNull String deviceOS, boolean compressionSupported, @Nullable String extras, @NotNull UserInfo userInfo) {
        void it;
        List list;
        String string;
        LoginRequest loginRequest;
        Object object;
        block10: {
            block9: {
                Object object2;
                Intrinsics.checkNotNullParameter((Object)loginId, (String)"loginId");
                Intrinsics.checkNotNullParameter((Object)password, (String)"password");
                Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
                Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
                Intrinsics.checkNotNullParameter((Object)deviceOS, (String)"deviceOS");
                Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
                this.loginId = loginId;
                this.password = password;
                this.deviceName = deviceName;
                this.deviceSerialNumber = deviceSerialNumber;
                this.deviceOS = deviceOS;
                this.compressionSupported = compressionSupported;
                this.userInfo = userInfo;
                MXLogger mXLogger = NotifyConstants.INFORMER_LOGGER;
                Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"INFORMER_LOGGER");
                this.logger = mXLogger;
                LoginRequest loginRequest2 = this;
                object = extras;
                if (object == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) break block9;
                Object object3 = object;
                loginRequest = loginRequest2;
                boolean bl = false;
                try {
                    void xml;
                    boolean bl2 = false;
                    Object object4 = InformerObjectSerializer.getInstance().deserialize(new StringReader((String)xml));
                    Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.LoginExtras");
                    object2 = Result.constructor-impl((Object)((LoginExtras)object4));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Throwable e = throwable;
                    boolean bl3 = false;
                    this.logger.error((Object)"An error occurred while parsing the session extras.", e);
                    throw new NotifyFault("Malformed \"extras\" in login request");
                }
                LoginExtras loginExtras = (LoginExtras)object2;
                loginRequest2 = loginRequest;
                object = loginExtras;
                if (loginExtras != null) break block10;
            }
            object = new LoginExtras();
        }
        loginRequest2.extras = object;
        Object[] objectArray = this.extras.getCatalogTypes();
        this.supportsSqlite = objectArray != null ? ArraysKt.contains((Object[])objectArray, (Object)"SQLITE") : false;
        String string2 = this.extras.getLangCode();
        if (string2 != null) {
            String string3 = string2.toUpperCase();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase()");
        } else {
            string = null;
        }
        this.userSpecifiedLangCode = string;
        String[] stringArray = this.extras.getNotificationNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"this.extras.notificationNames");
        List list2 = list = SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)ArraysKt.asSequence((Object[])stringArray)), (Function1)profiles.1.INSTANCE), (Function1)profiles.2.INSTANCE)));
        loginRequest = this;
        boolean bl = false;
        boolean bl4 = !((Collection)it).isEmpty();
        List list3 = bl4 ? list : null;
        if (list3 == null) {
            throw new InformerException("noProfileExtras");
        }
        loginRequest.profiles = list3;
    }

    @NotNull
    public final NotificationSession invoke() throws MXException, RemoteException, NotifyFault {
        Object object;
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)this.evaluate());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            this.logger.error((Object)"An error occurred during 'login' call", it);
            if (it instanceof NotifyFault) {
                throw it;
            }
            throw new NotifyFault("An error occurred during 'login' call");
        }
        return (NotificationSession)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final NotificationSession evaluate() {
        boolean bl;
        Object object;
        MboRemote mboRemote;
        Object it$iv;
        Object $i$a$-debugLazy$default-LoginRequest$evaluate$62;
        Object device;
        Object it$iv2;
        String langCode;
        String string3;
        MXServer mxServer = MXServer.getMXServer();
        if (mxServer.isAdminModeOn(false) || mxServer.isAdminModePending()) {
            return LoginResponses.INSTANCE.adminMode();
        }
        UserInfo userInfo = Companion.identifyUser(this.loginId, this.userInfo, this.extras, this.logger);
        if (userInfo == null) {
            NotificationSession notificationSession;
            NotificationSession it = notificationSession = LoginResponses.INSTANCE.authFailure();
            boolean bl2 = false;
            MXLogger $this$infoLazy_u24default$iv = this.logger;
            Object e$iv = null;
            boolean $i$f$infoLazy = false;
            if ($this$infoLazy_u24default$iv.isInfoEnabled()) {
                Object $i$a$-infoLazy$default-LoginRequest$evaluate$identifiedUserInfo$1$22;
                try {
                    boolean $i$a$-infoLazy$default-LoginRequest$evaluate$identifiedUserInfo$1$22 = false;
                    $i$a$-infoLazy$default-LoginRequest$evaluate$identifiedUserInfo$1$22 = Result.constructor-impl((Object)("User could not be identified for loginID '" + this.loginId + '\''));
                }
                catch (Throwable throwable) {
                    $i$a$-infoLazy$default-LoginRequest$evaluate$identifiedUserInfo$1$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string2 = "(Unable to form error msg)";
                String msg$iv = (String)(Result.isFailure-impl((Object)$i$a$-infoLazy$default-LoginRequest$evaluate$identifiedUserInfo$1$22) ? string2 : $i$a$-infoLazy$default-LoginRequest$evaluate$identifiedUserInfo$1$22);
                $this$infoLazy_u24default$iv.info((Object)msg$iv);
            }
            return notificationSession;
        }
        UserInfo identifiedUserInfo = userInfo;
        MXLogger $this$debugLazy_u24default$iv = this.logger;
        NotificationSession e$iv = null;
        boolean $i$f$debugLazy = false;
        if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
            Object $this$infoLazy_u24default$iv;
            try {
                boolean bl3 = false;
                $this$infoLazy_u24default$iv = Result.constructor-impl((Object)("User " + identifiedUserInfo.getUserName() + " (" + identifiedUserInfo.getDisplayName() + ") was identified for '" + this.loginId + '\''));
            }
            catch (Throwable bl3) {
                $this$infoLazy_u24default$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            String bl3 = "(Unable to form error msg)";
            String msg$iv = (String)(Result.isFailure-impl((Object)$this$infoLazy_u24default$iv) ? bl3 : $this$infoLazy_u24default$iv);
            $this$debugLazy_u24default$iv.debug((Object)msg$iv);
        }
        boolean authenticated = Companion.authenticate(identifiedUserInfo, this.password, this.extras, this.logger);
        if (!authenticated) {
            NotificationSession it3 = e$iv = LoginResponses.INSTANCE.authFailure();
            boolean string3 = false;
            MXLogger $this$debugLazy_u24default$iv2 = this.logger;
            Object e$iv2 = null;
            boolean $i$f$debugLazy2 = false;
            if ($this$debugLazy_u24default$iv2.isDebugEnabled()) {
                Object $i$a$-debugLazy$default-LoginRequest$evaluate$2$22;
                try {
                    boolean $i$a$-debugLazy$default-LoginRequest$evaluate$2$22 = false;
                    $i$a$-debugLazy$default-LoginRequest$evaluate$2$22 = Result.constructor-impl((Object)("Login of user " + identifiedUserInfo.getUserName() + " (" + identifiedUserInfo.getDisplayName() + ") failed due to authentication failure."));
                }
                catch (Throwable throwable) {
                    $i$a$-debugLazy$default-LoginRequest$evaluate$2$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string4 = "(Unable to form error msg)";
                String msg$iv = (String)(Result.isFailure-impl((Object)$i$a$-debugLazy$default-LoginRequest$evaluate$2$22) ? string4 : $i$a$-debugLazy$default-LoginRequest$evaluate$2$22);
                $this$debugLazy_u24default$iv2.debug((Object)msg$iv);
            }
            return e$iv;
        }
        String string5 = this.userSpecifiedLangCode;
        String it = string3 = string5 != null ? ((Object)StringsKt.trim((CharSequence)string5)).toString() : null;
        boolean bl4 = false;
        String string6 = (it != null ? ((CharSequence)it).length() > 0 : false) ? string3 : null;
        if (string6 == null) {
            String it2 = it = NotifyUtil.getLocalUserInfo(identifiedUserInfo.getUserName()).getDefaultLang();
            boolean bl5 = false;
            CharSequence $i$a$-debugLazy$default-LoginRequest$evaluate$2$22 = it2;
            string6 = !($i$a$-debugLazy$default-LoginRequest$evaluate$2$22 == null || StringsKt.isBlank((CharSequence)$i$a$-debugLazy$default-LoginRequest$evaluate$2$22)) ? it : null;
            if (string6 == null) {
                string6 = langCode = mxServer.getBaseLang();
            }
        }
        if (!NotifyUtil.getLangCodes().contains(langCode)) {
            Object it3 = new String[]{this.userSpecifiedLangCode};
            Object it4 = it3 = LoginResponses.INSTANCE.postAuthError(ErrorCodes.INVALID_LANGCODE, MaxMessageUtilsKt.getInformerMessage$default("invalidLanguage", (Object[])it3, null, null, 12, null));
            boolean bl6 = false;
            MXLogger $this$debugLazy_u24default$iv3 = this.logger;
            Object e$iv3 = null;
            boolean $i$f$debugLazy3 = false;
            if ($this$debugLazy_u24default$iv3.isDebugEnabled()) {
                Object $i$a$-debugLazy$default-LoginRequest$evaluate$3$22;
                try {
                    boolean $i$a$-debugLazy$default-LoginRequest$evaluate$3$22 = false;
                    $i$a$-debugLazy$default-LoginRequest$evaluate$3$22 = Result.constructor-impl((Object)("Login failed, reason: " + ((NotificationSession)it4).getServerErrorMessage()));
                }
                catch (Throwable msg$iv) {
                    $i$a$-debugLazy$default-LoginRequest$evaluate$3$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)msg$iv));
                }
                String msg$iv = "(Unable to form error msg)";
                String msg$iv2 = (String)(Result.isFailure-impl((Object)$i$a$-debugLazy$default-LoginRequest$evaluate$3$22) ? msg$iv : $i$a$-debugLazy$default-LoginRequest$evaluate$3$22);
                $this$debugLazy_u24default$iv3.debug((Object)msg$iv2);
            }
            return it3;
        }
        MboSetRemote $this$use$iv = MboExtensionsKt.getNewMboSet$default("ISDEVICE", null, null, true, 6, null);
        boolean $i$f$use = false;
        Closeable bl6 = new MboSetRemoteClosableWrapper($this$use$iv);
        Throwable $this$debugLazy_u24default$iv3 = null;
        try {
            it$iv2 = (MboSetRemoteClosableWrapper)bl6;
            boolean bl7 = false;
            MboSetRemote deviceSet = $this$use$iv;
            boolean bl8 = false;
            deviceSet.setWhere(MboExtensionsKt.sqlFormat$default("serialnum = :1", null, null, (Function1)new Function1<SqlFormat, Unit>(this){
                final /* synthetic */ LoginRequest this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull SqlFormat $this$sqlFormat) {
                    Intrinsics.checkNotNullParameter((Object)$this$sqlFormat, (String)"$this$sqlFormat");
                    $this$sqlFormat.setObject(1, "ISDEVICE", "SERIALNUM", LoginRequest.access$getDeviceSerialNumber$p(this.this$0));
                }
            }, 3, null));
            Sequence<MboRemote> $this$forEach$iv = MboExtensionsKt.asSequence(deviceSet);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NotificationSession notificationSession;
                device = (MboRemote)element$iv;
                boolean bl9 = false;
                if (device.getBoolean("WIPE")) {
                    NotificationSession notificationSession2;
                    NotificationSession it5 = notificationSession2 = LoginResponses.INSTANCE.postAuthError(ErrorCodes.WIPE, "Device is marked for data wipe.");
                    boolean bl10 = false;
                    this.logger.info((Object)new Function0<String>(it5){
                        final /* synthetic */ NotificationSession $it;
                        {
                            this.$it = $it;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Login failed despite authentication, reason: " + this.$it.getServerErrorMessage();
                        }
                    });
                    NotificationSession notificationSession3 = notificationSession2;
                    return notificationSession3;
                }
                if (!device.getBoolean("BLOCKED")) continue;
                NotificationSession it6 = notificationSession = LoginResponses.INSTANCE.postAuthError(ErrorCodes.BLOCKED, "Device is blocked by the administrator.");
                boolean bl11 = false;
                this.logger.info((Object)new Function0<String>(it6){
                    final /* synthetic */ NotificationSession $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Login failed despite authentication, reason: " + this.$it.getServerErrorMessage();
                    }
                });
                NotificationSession notificationSession4 = notificationSession;
                return notificationSession4;
            }
            it$iv2 = Unit.INSTANCE;
        }
        catch (Throwable it$iv3) {
            $this$debugLazy_u24default$iv3 = it$iv3;
            throw it$iv3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)bl6, (Throwable)$this$debugLazy_u24default$iv3);
        }
        MXLogger $this$debugLazy_u24default$iv4 = this.logger;
        Object e$iv4 = null;
        boolean $i$f$debugLazy4 = false;
        if ($this$debugLazy_u24default$iv4.isDebugEnabled()) {
            try {
                boolean $i$a$-debugLazy$default-LoginRequest$evaluate$62 = false;
                $i$a$-debugLazy$default-LoginRequest$evaluate$62 = Result.constructor-impl((Object)("Initial authentication is valid for " + this.deviceSerialNumber + " and user " + this.loginId));
            }
            catch (Throwable it$iv3) {
                $i$a$-debugLazy$default-LoginRequest$evaluate$62 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it$iv3));
            }
            it$iv2 = "(Unable to form error msg)";
            String msg$iv = (String)(Result.isFailure-impl((Object)$i$a$-debugLazy$default-LoginRequest$evaluate$62) ? it$iv2 : $i$a$-debugLazy$default-LoginRequest$evaluate$62);
            $this$debugLazy_u24default$iv4.debug((Object)msg$iv);
        }
        MboSetRemote $this$use$iv2 = MboExtensionsKt.getNewMboSet$default("ISNOTIFYUSER", null, null, false, 14, null);
        boolean $i$f$use2 = false;
        $i$a$-debugLazy$default-LoginRequest$evaluate$62 = new MboSetRemoteClosableWrapper($this$use$iv2);
        it$iv2 = null;
        try {
            void $this$mapTo$iv$iv;
            it$iv = (MboSetRemoteClosableWrapper)$i$a$-debugLazy$default-LoginRequest$evaluate$62;
            boolean bl12 = false;
            MboSetRemote userCheckSet = $this$use$iv2;
            boolean bl13 = false;
            SqlFormat accessCheckSqlf = new SqlFormat("notifyid = (SELECT notifyid FROM isnotify WHERE notifynum = :1)\nAND userid = :2\nAND disabled = 0");
            accessCheckSqlf.setObject(2, "ISNOTIFYUSER", "USERID", identifiedUserInfo.getUserName());
            Iterable $this$map$iv = this.profiles;
            boolean $i$f$map = false;
            device = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            mboRemote = $this$mapTo$iv$iv.iterator();
            while (mboRemote.hasNext()) {
                void notifyNum;
                Object item$iv$iv = mboRemote.next();
                String string7 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl14 = false;
                accessCheckSqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", (String)notifyNum);
                userCheckSet.setWhere(accessCheckSqlf.format());
                userCheckSet.reset();
                MboRemote notifyUser = userCheckSet.moveFirst();
                if (notifyUser == null) {
                    Object object2 = new String[]{notifyNum};
                    Object it7 = object2 = LoginResponses.INSTANCE.postAuthError(ErrorCodes.USER_NOT_FOUND, MaxMessageUtilsKt.getInformerMessage$default("noProfileAccess", object2, null, null, 12, null));
                    boolean bl15 = false;
                    this.logger.info((Object)new Function0<String>((NotificationSession)it7){
                        final /* synthetic */ NotificationSession $it;
                        {
                            this.$it = $it;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Login failed despite authentication, reason: " + this.$it.getServerErrorMessage();
                        }
                    });
                    Object object3 = object2;
                    return object3;
                }
                if (!notifyUser.getBoolean("NOTIFY.ACTIVE")) {
                    Object object4 = new String[]{notifyNum};
                    Object it8 = object4 = LoginResponses.INSTANCE.postAuthError(ErrorCodes.INACTIVE, MaxMessageUtilsKt.getInformerMessage$default("requestedProfileInactive", object4, null, null, 12, null));
                    boolean bl16 = false;
                    this.logger.info((Object)new Function0<String>((NotificationSession)it8){
                        final /* synthetic */ NotificationSession $it;
                        {
                            this.$it = $it;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Login failed despite authentication, reason: " + this.$it.getServerErrorMessage();
                        }
                    });
                    Object object5 = object4;
                    return object5;
                }
                collection.add(notifyUser.getUniqueIDValue());
            }
            it$iv = (List)destination$iv$iv;
        }
        catch (Throwable it$iv4) {
            it$iv2 = it$iv4;
            throw it$iv4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$i$a$-debugLazy$default-LoginRequest$evaluate$62, (Throwable)it$iv2);
        }
        Object notifyUserIds2 = it$iv;
        String compoundUserId = CollectionsKt.joinToString$default((Iterable)((Iterable)notifyUserIds2), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
        MboSetRemote $this$use$iv3 = MboExtensionsKt.getNewMboSet$default("ISDEVICE", null, null, false, 14, null);
        boolean $i$f$use3 = false;
        it$iv = new MboSetRemoteClosableWrapper($this$use$iv3);
        Object object6 = null;
        try {
            boolean bl17;
            MboSetRemoteClosableWrapper it$iv5 = (MboSetRemoteClosableWrapper)it$iv;
            boolean bl18 = false;
            MboSetRemote set = $this$use$iv3;
            boolean bl19 = false;
            Intrinsics.checkNotNull((Object)set, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.DeviceSetRemote");
            DeviceSetRemote deviceSet = (DeviceSetRemote)set;
            object = deviceSet.getDeviceForIdentifiers(this.deviceSerialNumber, this.deviceName, identifiedUserInfo.getUserName());
            MboRemote mboRemote2 = object;
            if (mboRemote2 != null) {
                boolean bl20;
                MboRemote device2;
                block67: {
                    Intrinsics.checkNotNullExpressionValue((Object)mboRemote2, (String)"getDeviceForIdentifiers(\u2026ntifiedUserInfo.userName)");
                    device2 = object;
                    boolean bl21 = false;
                    MboRemote it9 = mboRemote = device2;
                    boolean bl22 = false;
                    Object object7 = it9.getBoolean("ACTIVE") ? mboRemote : null;
                    if (object7 != null) {
                        MboRemote it10 = object7;
                        boolean bl23 = false;
                        MXLogger $this$debugLazy_u24default$iv5 = this.logger;
                        Object e$iv5 = null;
                        boolean $i$f$debugLazy5 = false;
                        if ($this$debugLazy_u24default$iv5.isDebugEnabled()) {
                            Object $i$a$-debugLazy$default-LoginRequest$evaluate$isFirstTime$1$1$firstTime$2$22;
                            try {
                                boolean $i$a$-debugLazy$default-LoginRequest$evaluate$isFirstTime$1$1$firstTime$2$22 = false;
                                $i$a$-debugLazy$default-LoginRequest$evaluate$isFirstTime$1$1$firstTime$2$22 = Result.constructor-impl((Object)("Existing device (ISDEVICE id=" + device2.getUniqueIDValue() + ") was found and is active."));
                            }
                            catch (Throwable bl16) {
                                $i$a$-debugLazy$default-LoginRequest$evaluate$isFirstTime$1$1$firstTime$2$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl16));
                            }
                            String bl16 = "(Unable to form error msg)";
                            String msg$iv = (String)(Result.isFailure-impl((Object)$i$a$-debugLazy$default-LoginRequest$evaluate$isFirstTime$1$1$firstTime$2$22) ? bl16 : $i$a$-debugLazy$default-LoginRequest$evaluate$isFirstTime$1$1$firstTime$2$22);
                            $this$debugLazy_u24default$iv5.debug((Object)msg$iv);
                        }
                        Iterable $this$none$iv = this.profiles;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl20 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                String it11 = (String)element$iv;
                                boolean bl24 = false;
                                if (!((DeviceRemote)device2).profileListContains(it11)) continue;
                                bl20 = false;
                                break block67;
                            }
                            bl20 = true;
                        }
                    } else {
                        bl20 = true;
                    }
                }
                boolean firstTime = bl20;
                device2.setValue("NAME", this.deviceName, 2L);
                device2.setValue("OS", this.deviceOS, 2L);
                deviceSet.save(2L);
                bl17 = firstTime;
            } else {
                bl17 = true;
            }
            bl = bl17;
        }
        catch (Throwable throwable) {
            object6 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it$iv, (Throwable)object6);
        }
        boolean isFirstTime = bl;
        SessionManager sessionManager = SessionManager.getInstance();
        String string8 = identifiedUserInfo.getUserName();
        String string9 = CollectionsKt.joinToString$default((Iterable)this.profiles, (CharSequence)"|", (CharSequence)"|", (CharSequence)"|", (int)0, null, null, (int)56, null);
        Intrinsics.checkNotNullExpressionValue((Object)langCode, (String)"langCode");
        String string10 = langCode.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"this as java.lang.String).toUpperCase()");
        SessionManager.SessionResult newSession = sessionManager.createSession(new SessionInfo(string8, this.deviceName, this.deviceSerialNumber, this.deviceOS, this.compressionSupported, string9, string10, identifiedUserInfo.getLoginID(), this.supportsSqlite));
        MboSetRemote $this$use$iv4 = MboExtensionsKt.getNewMboSet$default("ISDEVICE", null, null, false, 14, null);
        boolean $i$f$use4 = false;
        object6 = new MboSetRemoteClosableWrapper($this$use$iv4);
        Throwable throwable = null;
        try {
            Unit unit;
            MboSetRemoteClosableWrapper it$iv6 = (MboSetRemoteClosableWrapper)object6;
            boolean bl25 = false;
            MboSetRemote deviceSet = $this$use$iv4;
            boolean bl26 = false;
            Object object8 = object = SessionManager.getValidNotifySession(newSession.sessionKey, identifiedUserInfo);
            if (object8 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"getValidNotifySession(ne\u2026nKey, identifiedUserInfo)");
                Object session = object;
                boolean bl27 = false;
                MboRemote mboRemote3 = mboRemote = ((SessionInfo)session).getDevice(deviceSet);
                if (mboRemote3 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)mboRemote3, (String)"getDevice(deviceSet)");
                    MboRemote device3 = mboRemote;
                    boolean bl28 = false;
                    for (String profileName : this.profiles) {
                        ((DeviceRemote)device3).profileListAdd(profileName);
                    }
                    deviceSet.save();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object6, (Throwable)throwable);
        }
        LoginResponses loginResponses = LoginResponses.INSTANCE;
        String string11 = newSession.sessionKey;
        object6 = newSession.expiration;
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"sessionKey");
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"expiration");
        return loginResponses.successful(isFirstTime, string11, (Date)object6, compoundUserId);
    }

    public static final /* synthetic */ String access$getDeviceSerialNumber$p(LoginRequest $this) {
        return $this.deviceSerialNumber;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J(\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002\u00a8\u0006\u0016"}, d2={"Lcom/interlocsolutions/maximo/notify/LoginRequest$Companion;", "", "()V", "DEFAULT_AUTHENTICATOR", "", "DEFAULT_USER_IDENTIFIER", "getDEFAULT_USER_IDENTIFIER$annotations", "NO_CHECK_AUTHENTICATOR", "PROP_AUTHENTICATOR", "PROP_USER_IDENTIFIER", "getPROP_USER_IDENTIFIER$annotations", "authenticate", "", "userInfo", "Lpsdi/security/UserInfo;", "password", "extras", "Lcom/interlocsolutions/maximo/notify/xml/LoginExtras;", "logger", "Lpsdi/util/logging/MXLogger;", "identifyUser", "loginId", "isinformer"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getDEFAULT_USER_IDENTIFIER$annotations() {
        }

        public static /* synthetic */ void getPROP_USER_IDENTIFIER$annotations() {
        }

        @Nullable
        public final UserInfo identifyUser(@NotNull String loginId, @NotNull UserInfo userInfo, @NotNull LoginExtras extras, @NotNull MXLogger logger2) {
            Intrinsics.checkNotNullParameter((Object)loginId, (String)"loginId");
            Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
            Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            Object object = PropUtil.INSTANCE.getProp(LoginRequest.PROP_USER_IDENTIFIER);
            if (object == null || (object = ((InformerProp)object).asString()) == null) {
                object = LoginRequest.DEFAULT_USER_IDENTIFIER;
            }
            Object className = object;
            Object object2 = this;
            try {
                Companion $this$identifyUser_u24lambda_u240 = object2;
                boolean bl = false;
                Object obj = Class.forName((String)className).getConstructor(new Class[0]).newInstance(new Object[0]);
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.security.UserIdentifier");
                return ((UserIdentifier)obj).identify(loginId, userInfo, extras, logger2);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Throwable e = throwable;
                    boolean bl2 = false;
                    MXLogger $this$errorLazy$iv = logger2;
                    boolean $i$f$errorLazy = false;
                    if ($this$errorLazy$iv.isErrorEnabled()) {
                        Object object3;
                        try {
                            boolean bl3 = false;
                            object3 = Result.constructor-impl((Object)("UserIdentifier " + (String)className + " encountered an error"));
                        }
                        catch (Throwable throwable2) {
                            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                        }
                        String string = "(Unable to form error msg)";
                        String msg$iv = (String)(Result.isFailure-impl((Object)object3) ? string : object3);
                        if (e != null) {
                            $this$errorLazy$iv.error((Object)msg$iv, e);
                        } else {
                            $this$errorLazy$iv.error((Object)msg$iv);
                        }
                    }
                    throw new NotifyFault("User identification could not be completed. Please contact the system administrator.");
                }
                throw new KotlinNothingValueException();
            }
        }

        public final boolean authenticate(@NotNull UserInfo userInfo, @NotNull String password, @NotNull LoginExtras extras, @NotNull MXLogger logger2) {
            Object $this$authenticate_u24lambda_u247;
            MXLogger $this$errorLazy$iv;
            Throwable e;
            Object $this$authenticate_u24lambda_u244;
            Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            Object object = PropUtil.INSTANCE.getProp(LoginRequest.PROP_AUTHENTICATOR);
            if (object == null || (object = ((InformerProp)object).asString()) == null) {
                object = LoginRequest.DEFAULT_AUTHENTICATOR;
            }
            Object it = object;
            boolean bl = false;
            Object className = MaximoVersion.Companion.getSystemVersion().majorVersion >= 8 && Intrinsics.areEqual((Object)it, (Object)LoginRequest.DEFAULT_AUTHENTICATOR) ? LoginRequest.NO_CHECK_AUTHENTICATOR : it;
            Object object2 = this;
            try {
                Authenticator3 authenticator3;
                $this$authenticate_u24lambda_u244 = object2;
                boolean bl2 = false;
                Object obj = Class.forName((String)className).getConstructor(new Class[0]).newInstance(new Object[0]);
                if (obj instanceof Authenticator) {
                    authenticator3 = new AuthenticatorAdapter((Authenticator)obj);
                } else if (obj instanceof Authenticator2) {
                    authenticator3 = new Authenticator2Adapter((Authenticator2)obj);
                } else {
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.security.Authenticator3");
                    authenticator3 = (Authenticator3)obj;
                }
                $this$authenticate_u24lambda_u244 = Result.constructor-impl((Object)authenticator3);
            }
            catch (Throwable bl2) {
                $this$authenticate_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = $this$authenticate_u24lambda_u244;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                e = throwable;
                boolean bl3 = false;
                $this$errorLazy$iv = logger2;
                boolean $i$f$errorLazy = false;
                if ($this$errorLazy$iv.isErrorEnabled()) {
                    Object $i$a$-errorLazy-LoginRequest$Companion$authenticate$auth$2$22;
                    try {
                        boolean $i$a$-errorLazy-LoginRequest$Companion$authenticate$auth$2$22 = false;
                        $i$a$-errorLazy-LoginRequest$Companion$authenticate$auth$2$22 = Result.constructor-impl((Object)("Failed to create Authenticator " + (String)className));
                    }
                    catch (Throwable throwable2) {
                        $i$a$-errorLazy-LoginRequest$Companion$authenticate$auth$2$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    String string = "(Unable to form error msg)";
                    String msg$iv = (String)(Result.isFailure-impl((Object)$i$a$-errorLazy-LoginRequest$Companion$authenticate$auth$2$22) ? string : $i$a$-errorLazy-LoginRequest$Companion$authenticate$auth$2$22);
                    if (e != null) {
                        $this$errorLazy$iv.error((Object)msg$iv, e);
                    } else {
                        $this$errorLazy$iv.error((Object)msg$iv);
                    }
                }
                throw new NotifyFault("Authentication could not be completed. Please contact the system administrator.");
            }
            Authenticator3 auth = (Authenticator3)object2;
            object2 = this;
            try {
                $this$authenticate_u24lambda_u247 = (Companion)object2;
                boolean bl4 = false;
                $this$authenticate_u24lambda_u247 = Result.constructor-impl((Object)auth.authenticate(userInfo, password, extras, logger2));
            }
            catch (Throwable bl4) {
                $this$authenticate_u24lambda_u247 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl4));
            }
            object2 = $this$authenticate_u24lambda_u247;
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object2);
            if (throwable3 != null) {
                e = throwable3;
                boolean bl5 = false;
                $this$errorLazy$iv = logger2;
                boolean $i$f$errorLazy = false;
                if ($this$errorLazy$iv.isErrorEnabled()) {
                    Object object3;
                    try {
                        boolean bl6 = false;
                        object3 = Result.constructor-impl((Object)("Authenticator " + (String)className + " encountered an error"));
                    }
                    catch (Throwable throwable4) {
                        object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable4));
                    }
                    String string = "(Unable to form error msg)";
                    String msg$iv = (String)(Result.isFailure-impl((Object)object3) ? string : object3);
                    if (e != null) {
                        $this$errorLazy$iv.error((Object)msg$iv, e);
                    } else {
                        $this$errorLazy$iv.error((Object)msg$iv);
                    }
                }
                throw new NotifyFault("Authentication could not be completed. Please contact the system administrator.");
            }
            return (Boolean)object2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/interlocsolutions/maximo/notify/LoginRequest$ErrorCodes;", "", "(Ljava/lang/String;I)V", "ADMIN_MODE", "LOGIN_FAILED", "BLOCKED", "WIPE", "INVALID_LANGCODE", "USER_NOT_FOUND", "INACTIVE", "isinformer"})
    public static final class ErrorCodes
    extends Enum<ErrorCodes> {
        public static final /* enum */ ErrorCodes ADMIN_MODE = new ErrorCodes();
        public static final /* enum */ ErrorCodes LOGIN_FAILED = new ErrorCodes();
        public static final /* enum */ ErrorCodes BLOCKED = new ErrorCodes();
        public static final /* enum */ ErrorCodes WIPE = new ErrorCodes();
        public static final /* enum */ ErrorCodes INVALID_LANGCODE = new ErrorCodes();
        public static final /* enum */ ErrorCodes USER_NOT_FOUND = new ErrorCodes();
        public static final /* enum */ ErrorCodes INACTIVE = new ErrorCodes();
        private static final /* synthetic */ ErrorCodes[] $VALUES;

        public static ErrorCodes[] values() {
            return (ErrorCodes[])$VALUES.clone();
        }

        public static ErrorCodes valueOf(String value) {
            return Enum.valueOf(ErrorCodes.class, value);
        }

        static {
            $VALUES = errorCodesArray = new ErrorCodes[]{ErrorCodes.ADMIN_MODE, ErrorCodes.LOGIN_FAILED, ErrorCodes.BLOCKED, ErrorCodes.WIPE, ErrorCodes.INVALID_LANGCODE, ErrorCodes.USER_NOT_FOUND, ErrorCodes.INACTIVE};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004JN\u0010\u0006\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0002J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bJ&\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\b\u00a8\u0006\u0014"}, d2={"Lcom/interlocsolutions/maximo/notify/LoginRequest$LoginResponses;", "", "()V", "adminMode", "Lcom/interlocsolutions/maximo/notify/xml/NotificationSession;", "authFailure", "createSessionResponse", "sessionId", "", "expiration", "Ljava/util/Date;", "firstLoginToProfile", "", "userId", "errorCode", "Lcom/interlocsolutions/maximo/notify/LoginRequest$ErrorCodes;", "serverErrorMessage", "postAuthError", "successful", "sessionKey", "isinformer"})
    public static final class LoginResponses {
        @NotNull
        public static final LoginResponses INSTANCE = new LoginResponses();

        private LoginResponses() {
        }

        @NotNull
        public final NotificationSession adminMode() {
            return LoginResponses.createSessionResponse$default(this, null, null, false, null, ErrorCodes.ADMIN_MODE, MaxMessageUtilsKt.getMaxMessage$default("system", "AdminOnThis", null, null, null, 28, null), 15, null);
        }

        @NotNull
        public final NotificationSession authFailure() {
            return LoginResponses.createSessionResponse$default(this, null, null, false, null, ErrorCodes.LOGIN_FAILED, MaxMessageUtilsKt.getMaxMessage$default("system", "NoLogin", null, null, null, 28, null), 15, null);
        }

        @NotNull
        public final NotificationSession postAuthError(@NotNull ErrorCodes errorCode, @NotNull String serverErrorMessage) {
            Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
            Intrinsics.checkNotNullParameter((Object)serverErrorMessage, (String)"serverErrorMessage");
            return LoginResponses.createSessionResponse$default(this, null, null, false, null, errorCode, serverErrorMessage, 15, null);
        }

        @NotNull
        public final NotificationSession successful(boolean firstLoginToProfile, @NotNull String sessionKey, @NotNull Date expiration, @NotNull String userId) {
            Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
            Intrinsics.checkNotNullParameter((Object)expiration, (String)"expiration");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            return LoginResponses.createSessionResponse$default(this, sessionKey, expiration, firstLoginToProfile, userId, null, null, 48, null);
        }

        private final NotificationSession createSessionResponse(String sessionId, Date expiration, boolean firstLoginToProfile, String userId, ErrorCodes errorCode, String serverErrorMessage) {
            NotificationSession nSession = new NotificationSession();
            nSession.setSessionId(sessionId);
            nSession.setAuthenticated(sessionId != null);
            nSession.setUserId(userId);
            nSession.setFirstLogin(firstLoginToProfile);
            nSession.setExpires(expiration);
            nSession.setServerErrorMessage(serverErrorMessage);
            ErrorCodes errorCodes = errorCode;
            nSession.setErrorCode(errorCodes != null ? errorCodes.toString() : null);
            return nSession;
        }

        static /* synthetic */ NotificationSession createSessionResponse$default(LoginResponses loginResponses, String string, Date date, boolean bl, String string2, ErrorCodes errorCodes, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                date = null;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                string2 = null;
            }
            if ((n & 0x10) != 0) {
                errorCodes = null;
            }
            if ((n & 0x20) != 0) {
                string3 = null;
            }
            return loginResponses.createSessionResponse(string, date, bl, string2, errorCodes, string3);
        }
    }
}

