/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.DeviceRemote;
import com.interlocsolutions.maximo.notify.InstrumentCollector;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.xml.InstrumentData;
import com.interlocsolutions.maximo.notify.xml.InstrumentReading;
import java.rmi.RemoteException;
import java.text.ParseException;
import psdi.server.MXServer;
import psdi.util.MXException;

public class InstrumentCollectorImpl
implements InstrumentCollector {
    @Override
    public String recordInstrumentData(DeviceRemote device, InstrumentData data) throws MXException, RemoteException {
        InstrumentReading reading = data.getReading("altitude");
        if (reading != null) {
            device.setValue("ALTITUDE", reading.getValueAsDouble());
        }
        if ((reading = data.getReading("batterylevel")) != null) {
            device.setValue("BATTERYLEVEL", reading.getValueAsInt());
        }
        if ((reading = data.getReading("haccuracy")) != null) {
            device.setValue("HACCURACY", reading.getValueAsDouble());
        }
        if ((reading = data.getReading("heading")) != null) {
            device.setValue("HEADING", reading.getValueAsDouble());
        }
        if ((reading = data.getReading("latitude")) != null) {
            device.setValue("LATITUDE", reading.getValueAsDouble());
        }
        if ((reading = data.getReading("longitude")) != null) {
            device.setValue("LONGITUDE", reading.getValueAsDouble());
        }
        if ((reading = data.getReading("speed")) != null) {
            device.setValue("SPEED", reading.getValueAsDouble());
        }
        if ((reading = data.getReading("timestamp")) != null) {
            try {
                device.setValue("TIMESTAMPREADING", reading.getValueAsDate());
            }
            catch (ParseException e) {
                NotifyConstants.INFORMER_LOGGER.warn((Object)"Error getting timestamp for instrument reading", (Throwable)e);
                device.setValue("TIMESTAMPREADING", MXServer.getMXServer().getDate());
            }
        } else {
            device.setValue("TIMESTAMPREADING", MXServer.getMXServer().getDate());
        }
        reading = data.getReading("vaccuracy");
        if (reading != null) {
            device.setValue("VACCURACY", reading.getValueAsDouble());
        }
        return null;
    }
}

