/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogPartitioner;
import com.interlocsolutions.maximo.notify.util.InformerClassUtils;
import java.rmi.RemoteException;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.MboValue;
import psdi.mbo.MboValueAdapter;
import psdi.util.MXException;

public class FldCatalogPartitionerClass
extends MboValueAdapter {
    public FldCatalogPartitionerClass(MboValue mv) {
        super(mv);
    }

    public void validate() throws MXException, RemoteException {
        if (this.getMboValue().isNull()) {
            return;
        }
        String specifiedClassname = this.getMboValue().getString();
        String catalogObjectName = this.getMboValue("OBJECTNAME").getString();
        try {
            Class partitionerClass = InformerClassUtils.loadClass(specifiedClassname);
            if (!CatalogPartitioner.class.isAssignableFrom(partitionerClass)) {
                throw new InformerException("classNotOfType", new String[]{specifiedClassname, CatalogPartitioner.class.getName()});
            }
            CatalogPartitioner partitioner = (CatalogPartitioner)partitionerClass.newInstance();
            if (!partitioner.validForObject(catalogObjectName)) {
                throw new InformerException("partitionerInapplicable", new String[]{specifiedClassname, catalogObjectName});
            }
        }
        catch (ClassNotFoundException e) {
            throw new InformerException("classNotFound", new String[]{specifiedClassname}, e);
        }
        catch (IllegalAccessException e) {
            throw new InformerException("classUninstantiable", new String[]{specifiedClassname}, e);
        }
        catch (InstantiationException e) {
            throw new InformerException("classUninstantiable", new String[]{specifiedClassname}, e);
        }
    }

    public void action() throws MXException, RemoteException {
        MboValue ourValue = this.getMboValue();
        if (ourValue.isModified() && !ourValue.isNull()) {
            this.getMboValue("PARTITIONBYATTR").setValueNull();
        }
    }

    public boolean hasList() {
        return true;
    }

    public void setValueFromLookup(MboRemote sourceMbo) throws MXException, RemoteException {
        this.getMboValue().setValue(sourceMbo.getString("NAME"));
    }

    public MboSetRemote getList() throws RemoteException, MXException {
        MboSetRemote lookupSet = this.getMboValue().getMbo().getMboSet("$partitionerLookup", "ISNOTIFYCLASSES");
        lookupSet.reset();
        return lookupSet;
    }
}

