/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.FileFragmentRemote;
import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.attachment.IAttachmentService;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetRemote;
import psdi.server.MXServer;
import psdi.util.MXException;

public class FileFragment
extends Mbo
implements FileFragmentRemote {
    private static final long serialVersionUID = 9105993641629803150L;
    private IAttachmentService attachmentService;

    public FileFragment(MboSet ms) throws RemoteException {
        super(ms);
    }

    public void init() throws MXException {
        super.init();
        this.attachmentService = IAttachmentService.getInstance();
    }

    public void add() throws MXException, RemoteException {
        super.add();
        this.setValue("CREATEDATE", MXServer.getMXServer().getDate());
    }

    @Override
    public String getPreparedDestinationPath() throws RemoteException {
        return this.attachmentService.getPreparedDestinationPath(this);
    }

    @Override
    public long writeFile() throws RemoteException, MXException {
        String destinationFilePath = this.getPreparedDestinationPath();
        try {
            this.writeFile(destinationFilePath);
            return this.createDocInfo(destinationFilePath);
        }
        catch (IOException e) {
            throw new InformerException("fileFragmentIOError", new String[]{String.format("Failed to write to the destination file %s", this.getPreparedDestinationPath())}, e);
        }
    }

    @Override
    public void writeFile(String destinationFilePath) throws IOException {
        this.attachmentService.writeFile(destinationFilePath, this);
    }

    @Override
    public long moveFileToDestinationFilePath(String currentFilePath) throws RemoteException, MXException {
        return this.createDocInfo(this.attachmentService.moveFileToDestinationFilePath(currentFilePath, this));
    }

    private long createDocInfo(String filePath) throws RemoteException, MXException {
        File f = new File(filePath);
        MboSetRemote docinfoSet = this.getMboSet("$docinfo", "DOCINFO");
        MboRemote doc = docinfoSet.add();
        int len = docinfoSet.getMboSetInfo().getMboValueInfo("DOCUMENT").getLength();
        if (len < f.getName().length()) {
            String newName = String.valueOf(System.currentTimeMillis());
            if (newName.length() > len) {
                newName = newName.substring(0, len);
            }
            doc.setValue("DOCUMENT", newName);
        } else {
            doc.setValue("DOCUMENT", f.getName());
        }
        doc.setValue("DESCRIPTION", this.getString("DESCRIPTION"));
        doc.setValue("DOCTYPE", this.getString("DOCTYPE"));
        doc.setValue("URLTYPE", MXServer.getMXServer().getMaximoDD().getTranslator().toExternalDefaultValue("URLTYPE", "FILE", doc));
        doc.setValue("NEWURLNAME", filePath);
        doc.setValue("URLNAME", filePath);
        docinfoSet.save();
        if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
            NotifyConstants.INFORMER_LOGGER.debug((Object)("Created DOCINFO " + doc.getString("DOCUMENT") + " for file " + filePath));
        }
        return doc.getUniqueIDValue();
    }
}

