/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.CatalogRemote;
import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.NotifyService;
import com.interlocsolutions.maximo.notify.err.NoSuchCatalogException;
import com.interlocsolutions.maximo.notify.filter.AcceptAllFilter;
import com.interlocsolutions.maximo.notify.filter.BaseFilterFactory;
import com.interlocsolutions.maximo.notify.filter.EventFilter;
import com.interlocsolutions.maximo.notify.filter.FilterConfig;
import com.interlocsolutions.maximo.notify.filter.FilterFactory;
import com.interlocsolutions.maximo.notify.filter.FilterFactory2;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobEval;
import com.interlocsolutions.maximo.notify.queue.catalog.JobRelationshipEval;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.LogLevel;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PerformanceTimer;
import com.interlocsolutions.maximo.notify.util.WeakReferenceSet;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.server.MXServer;
import psdi.server.event.EventListener;
import psdi.server.event.EventMessage;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;
import psdi.util.logging.MXLoggerFactory;

public class CatalogEventListener
implements EventListener {
    public static final String KEY_EVENTFILTER = "informer.eventfilter";
    public static final MXLogger LOGGER = NotifyConstants.INFORMER_LOGGER;
    private static MXLogger logger = NotifyConstants.INFORMER_LOGGER;
    private final PerformanceTimer timerSingleEvalQueue = new PerformanceTimer(MXLoggerFactory.getLogger((String)"maximo.informer.crqp.nycha"), LogLevel.DEBUG, TimeUnit.MILLISECONDS, "Queueing evaluation of a single Catalog record change took %dms");
    private final WeakReferenceSet<EventMessage> handledMessages = new WeakReferenceSet();
    private EventFilter mEventFilter;
    private long catalogId;
    private long revision;
    private String catalogObject;
    private long notifyId;
    private String listenerObjectName = null;
    private String whereClause = null;
    private String relationship = null;
    private Object lastObservedFilterFactoryInstance;

    public CatalogEventListener(CatalogRemote catalog) throws MXException, RemoteException {
        if (catalog == null) {
            throw new MXApplicationException("informer", "catalogCannotBeNull");
        }
        this.catalogId = catalog.getUniqueIDValue();
        this.notifyId = catalog.getLong("NOTIFYID");
        this.revision = catalog.getLong("REVISION");
        this.catalogObject = catalog.getString("OBJECTNAME");
        this.initEventFilter(catalog);
    }

    public CatalogEventListener(CatalogRemote catalog, String listenerObjectName, String relationship, String whereClause) throws MXException, RemoteException {
        if (catalog == null) {
            throw new MXApplicationException("informer", "catalogCannotBeNull");
        }
        this.catalogId = catalog.getUniqueIDValue();
        this.notifyId = catalog.getLong("NOTIFYID");
        this.revision = catalog.getLong("REVISION");
        this.catalogObject = catalog.getString("OBJECTNAME");
        this.listenerObjectName = listenerObjectName;
        this.whereClause = whereClause;
        this.relationship = relationship;
        this.initEventFilter(catalog);
    }

    @NotNull
    private Object getFilterFactoryObj() throws MXApplicationException {
        Object factoryObj;
        try {
            factoryObj = FilterConfig.getInstance().getFilterFactory();
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Unable to instantiate event filter factory specified by the System Property `%s`. No filtering will occur.", KEY_EVENTFILTER));
            factoryObj = new BaseFilterFactory();
        }
        return factoryObj;
    }

    private void initEventFilter(CatalogRemote catalog) throws RemoteException, MXException {
        Object factoryObj;
        this.lastObservedFilterFactoryInstance = factoryObj = this.getFilterFactoryObj();
        if (factoryObj instanceof FilterFactory2) {
            this.mEventFilter = null;
        } else if (factoryObj instanceof FilterFactory) {
            FilterFactory factory1 = (FilterFactory)factoryObj;
            EventFilter filter = this.whereClause != null && !this.whereClause.isEmpty() ? factory1.getCatalogAnonRelationshipFilter(catalog, this.listenerObjectName, this.whereClause) : (this.relationship != null && !this.relationship.isEmpty() ? factory1.getCatalogNamedRelationshipFilter(catalog, this.listenerObjectName, this.relationship) : factory1.getCatalogMainFilter(catalog));
            this.mEventFilter = filter != null ? filter : new AcceptAllFilter();
        } else {
            LOGGER.error((Object)String.format("The class specified via property `%s` implements neither `%s` nor `%s`, and will therefore be ignored.", KEY_EVENTFILTER, FilterFactory.class.getName(), FilterFactory2.class.getName()));
            this.mEventFilter = new AcceptAllFilter();
        }
    }

    @NotNull
    private EventFilter getEventFilter() throws MXException, RemoteException, NoSuchCatalogException {
        Object factoryObj = this.getFilterFactoryObj();
        if (factoryObj != this.lastObservedFilterFactoryInstance) {
            this.mEventFilter = null;
            this.lastObservedFilterFactoryInstance = factoryObj;
        }
        if (this.mEventFilter != null) {
            return this.mEventFilter;
        }
        if (factoryObj instanceof FilterFactory2) {
            FilterFactory2 factory2 = (FilterFactory2)factoryObj;
            CachedCatalog catalogMeta = NotificationEventListenerManager.CatalogCache.getCatalogOrThrow(this.catalogId, this.revision);
            EventFilter filter = this.whereClause != null && !this.whereClause.isEmpty() ? factory2.getCatalogAnonRelationshipFilter(catalogMeta, this.listenerObjectName, this.whereClause) : (this.relationship != null && !this.relationship.isEmpty() ? factory2.getCatalogNamedRelationshipFilter(catalogMeta, this.listenerObjectName, this.relationship) : factory2.getCatalogMainFilter(catalogMeta));
            this.mEventFilter = filter != null ? filter : new AcceptAllFilter();
            return this.mEventFilter;
        }
        if (factoryObj instanceof FilterFactory) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)String.format("No cached Event Filter is available. The class specified via property `%s` does not implement `%s` and therefore cannot be applied during runtime. No filtering will occur.", KEY_EVENTFILTER, FilterFactory2.class.getName()));
            }
            return new AcceptAllFilter();
        }
        LOGGER.error((Object)String.format("No cached Event Filter is available. The class specified via property `%s` does not implement `%s` and therefore cannot be applied during runtime. No filtering will occur.", KEY_EVENTFILTER, FilterFactory2.class.getName()));
        return new AcceptAllFilter();
    }

    public void postCommitEventAction(EventMessage event) throws MXException {
        Object eventObject;
        if (!(event.getEventName().endsWith(".add") || event.getEventName().endsWith(".update") || event.getEventName().endsWith(".delete"))) {
            return;
        }
        if (this.handledMessages.contains(event)) {
            logger.debug((Object)("Ignoring replayed EventMessage for catalog id " + this.catalogId));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Event action for catalog id " + this.catalogId));
        }
        if ((eventObject = event.getEventObject()) instanceof MboRemote) {
            MboRemote eventMbo = (MboRemote)eventObject;
            try {
                if (!this.getEventFilter().filterEvent(eventMbo)) {
                    logger.debug((Object)String.format("Aborting evaluation of event action \"%1$s\", fired on %2$s (%3$s = %4$d), for Catalog %5$d (object %6$s), due to event filter", event.getEventName(), eventMbo.getName(), eventMbo.getUniqueIDName(), eventMbo.getUniqueIDValue(), this.catalogId, this.catalogObject));
                    return;
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Event filtering failed, due to an exception. Filter will be bypassed.", (Throwable)e);
            }
            try {
                String eventName = event.toString();
                String eventMboName = eventMbo.getName();
                long eventMboUniqueId = eventMbo.getUniqueIDValue();
                EvalContext evalContext = new EvalContext();
                evalContext.setFlag(EvalFlags.MBOEVENT);
                if (eventMbo.getUserInfo().isInteractive()) {
                    evalContext.setFlag(EvalFlags.USER_WAITING);
                }
                if (eventMbo.isBasedOn(this.catalogObject) && this.whereClause == null && this.relationship == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Queueing evaluation of event %s with object %s and record id %d for catalog %d", eventName, eventMboName, eventMboUniqueId, this.catalogId));
                    }
                    this.timerSingleEvalQueue.start();
                    Collection<String> langCodes = NotifyUtil.getLangCodes();
                    ArrayList<JobEval.JobSpecEval> jobSpecs = new ArrayList<JobEval.JobSpecEval>(langCodes.size());
                    for (String langCode : langCodes) {
                        jobSpecs.add(new JobEval.JobSpecEval(eventMbo, this.catalogId, this.revision, langCode));
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)String.format("Queueing evaluation of object %s with record id %d for catalog %d, langCode %s", eventMbo.getName(), eventMbo.getUniqueIDValue(), this.catalogId, langCode));
                    }
                    JobConfig.getJobDispatcher().doEvals(evalContext.duplicate(), jobSpecs, eventMbo);
                    this.timerSingleEvalQueue.stop();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Handled event %s with object %s and record id %d for catalog %d", event.toString(), eventMbo.getName(), eventMbo.getUniqueIDValue(), this.catalogId));
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Handling event %s with object %s and record id %d for catalog %d", eventName, eventMboName, eventMboUniqueId, this.catalogId));
                    }
                    if (this.whereClause != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Requesting evaluation of event %s with object %s and record id %d for catalog %d", eventName, eventMboName, eventMboUniqueId, this.catalogId));
                        }
                        JobConfig.getJobDispatcher().doRelationEval(evalContext, new JobRelationshipEval.JobSpecRelationshipEval(this.notifyId, this.catalogId, this.revision, this.catalogObject, this.whereClause, false, eventMbo), eventMbo);
                    } else if (this.relationship != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Requesting evaluation of event %s with object %s and record id %d for catalog %d", eventName, eventMboName, eventMboUniqueId, this.catalogId));
                        }
                        JobConfig.getJobDispatcher().doRelationEval(evalContext, new JobRelationshipEval.JobSpecRelationshipEval(this.notifyId, this.catalogId, this.revision, this.catalogObject, this.relationship, true, eventMbo), eventMbo);
                    }
                }
            }
            catch (RemoteException e) {
                NotifyConstants.INFORMER_LOGGER.error((Object)"Error evaluating catalog update", (Throwable)e);
                throw new MXApplicationException("informer", "remoteError", (Throwable)e);
            }
        }
        this.handledMessages.add(event);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Post commit action %s for catalog id %d; waking any local Catalog queue processors", event.getEventName(), this.catalogId));
        }
        this.wakeCatalogQueue();
    }

    private void wakeCatalogQueue() {
        try {
            ((NotifyService)MXServer.getMXServer().lookup("NOTIFY")).wakeCatalogQueue();
        }
        catch (RemoteException | MXException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)"Error waking catalog queue for catalog update", e);
        }
    }

    public void preSaveEventAction(EventMessage event) throws MXException {
    }

    public void eventAction(EventMessage event) throws MXException {
    }

    public boolean eventValidate(EventMessage event) throws MXException {
        return true;
    }
}

