/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.xml.CatalogObject;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

@XmlRootElement(name="entry", namespace="http://www.interlocsolutions.com/maximo/notify")
public class CatalogEntry
implements Serializable {
    public static final CatalogObjectUnmarshallingPolicy POLICY_UNMARSHALL_CATALOG_OBJECT = new CatalogObjectUnmarshallingPolicy();
    private static final long serialVersionUID = 5653563649634099333L;
    private long id;
    private boolean delete;
    private long sequence;
    private String xml;
    private long catalogDataId = -1L;

    public CatalogEntry() {
    }

    public CatalogEntry(long id, long sequence) {
        this(id, sequence, false);
    }

    public CatalogEntry(long id, long sequence, boolean delete) {
        this.id = id;
        this.delete = delete;
        this.sequence = sequence;
    }

    public CatalogEntry(long id, long sequence, boolean delete, long catalogDataId) {
        this.id = id;
        this.delete = delete;
        this.sequence = sequence;
        this.catalogDataId = catalogDataId;
    }

    public CatalogEntry(long id, long sequence, boolean delete, String xml) {
        this.id = id;
        this.delete = delete;
        this.sequence = sequence;
        this.xml = xml == null || xml.trim().isEmpty() ? null : xml;
    }

    @XmlElement(name="dataid", namespace="http://www.interlocsolutions.com/maximo/notify")
    public long getCatalogDataId() {
        return this.catalogDataId;
    }

    public void setCatalogDataId(long catalogDataId) {
        this.catalogDataId = catalogDataId;
    }

    @XmlElement(name="id", namespace="http://www.interlocsolutions.com/maximo/notify")
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @XmlElement(name="delete", namespace="http://www.interlocsolutions.com/maximo/notify")
    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    @XmlElement(name="sequence", namespace="http://www.interlocsolutions.com/maximo/notify")
    public long getSequence() {
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    @XmlElement(name="xml", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public boolean hasXmlRepresentation() {
        return this.getXml() != null && !this.getXml().trim().isEmpty();
    }

    public CatalogObject getCatalogObjectFromXml() throws JAXBException, XMLStreamException {
        InformerObjectSerializer serializer2 = InformerObjectSerializer.getInstance();
        CatalogObject catObj = (CatalogObject)serializer2.deserialize(this.getXml(), POLICY_UNMARSHALL_CATALOG_OBJECT);
        catObj.setSeqeunce(this.getSequence());
        return catObj;
    }

    public static class CatalogObjectUnmarshallingPolicy
    implements InformerObjectSerializer.UnmarshallingPolicy<String> {
        public CatalogObject useUnmarshaller(Unmarshaller unmarshaller, String message2) throws JAXBException, XMLStreamException {
            XMLStreamReader xsr = InformerObjectSerializer.getInstance().getXMLInputFactory().createXMLStreamReader(new StringReader(message2));
            return (CatalogObject)unmarshaller.unmarshal(xsr, CatalogObject.class).getValue();
        }

        @Override
        public boolean modifiesConfiguration() {
            return false;
        }

        @Override
        public void configureUnmarshaller(Unmarshaller unmarshaller) throws PropertyException {
        }
    }
}

